(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    415173,      10023]
NotebookOptionsPosition[    408355,       9807]
NotebookOutlinePosition[    408764,       9825]
CellTagsIndexPosition[    408721,       9822]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Preamble", "Section",
 CellChangeTimes->{{3.662904801309491*^9, 3.6629048071540203`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{
  3.6616962331275797`*^9, 3.6617106227993717`*^9, 3.661711488885393*^9, 
   3.661712714316824*^9, {3.662108540951069*^9, 3.6621085564213057`*^9}, {
   3.662143536239328*^9, 3.662143538157866*^9}, 3.662398420604671*^9, 
   3.6624007457105494`*^9, 3.662451125728088*^9, 3.662452189437161*^9, 
   3.662465776584539*^9, 3.6624674741487293`*^9, 3.6628914190648813`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$PreRead", "=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"#", "/.", 
      RowBox[{
       RowBox[{"s_String", "/;", 
        RowBox[{
         RowBox[{"StringMatchQ", "[", 
          RowBox[{"s", ",", "NumberString"}], "]"}], "&&", 
         RowBox[{
          RowBox[{"Precision", "@", 
           RowBox[{"ToExpression", "@", "s"}]}], "\[Equal]", 
          "MachinePrecision"}]}]}], "\[RuleDelayed]", 
       RowBox[{"s", "<>", "\"\<`100.\>\""}]}]}], "&"}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"3", "/", "1.5"}], "+", 
  RowBox[{"Pi", "/", "7"}]}], "\n", 
 RowBox[{
  RowBox[{"Precision", "[", "%", "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"$MinPrecision", "=", 
  RowBox[{"4", "*", "$MachinePrecision"}]}]}], "Input",
 CellChangeTimes->{{3.661709950406673*^9, 3.6617099565459843`*^9}, {
   3.66171001195397*^9, 3.6617100375046873`*^9}, {3.6617103335912857`*^9, 
   3.661710334187392*^9}, 3.661710499406128*^9, {3.661710540996215*^9, 
   3.661710562125654*^9}, {3.662397723723793*^9, 3.6623977274980993`*^9}, {
   3.662885826797958*^9, 3.662885826892108*^9}, {3.662904604684309*^9, 
   3.662904604874454*^9}, {3.662904923831978*^9, 3.662904924070608*^9}}],

Cell[BoxData["2.\
448798950512827605494663340468500412028167057053586545853563513186830915183744\
142661147832191731009711735440930468900949584834944221513`100.08792313479879"]\
, "Output",
 CellChangeTimes->{{3.6617099569284763`*^9, 3.6617099812404003`*^9}, {
   3.661710012506362*^9, 3.6617100384082623`*^9}, {3.661710506852536*^9, 
   3.661710523305223*^9}, {3.6617105578860703`*^9, 3.661710564791472*^9}, {
   3.661710623555771*^9, 3.661710636990754*^9}, 3.6617112858918543`*^9, 
   3.6617114896045*^9, 3.661712715291013*^9, 3.6617131719895287`*^9, 
   3.661713209912673*^9, 3.661752904521997*^9, 3.6617535867713118`*^9, 
   3.661754011963746*^9, 3.661754060928838*^9, 3.661754134951688*^9, {
   3.6617541814326897`*^9, 3.6617542307384157`*^9}, {3.661754274411038*^9, 
   3.6617542957568197`*^9}, 3.661755978974861*^9, 3.661756172937132*^9, 
   3.661756516202907*^9, 3.661756843276073*^9, 3.6617572302714357`*^9, {
   3.662108543271372*^9, 3.662108557739957*^9}, {3.6621432901538467`*^9, 
   3.662143300573915*^9}, {3.662143524793378*^9, 3.662143539403919*^9}, 
   3.6621438169881563`*^9, 3.662144209161915*^9, 3.662144241528921*^9, 
   3.6621443678185673`*^9, 3.662386280337462*^9, 3.662386540185423*^9, 
   3.6623871829597797`*^9, 3.6623971842663307`*^9, 3.6623972863099337`*^9, 
   3.662397395998931*^9, 3.6623974433428164`*^9, {3.6623976991486998`*^9, 
   3.662397734403988*^9}, 3.662397876006646*^9, 3.662397925167726*^9, 
   3.662398024561902*^9, 3.6623984223441057`*^9, {3.662400110673503*^9, 
   3.66240012800143*^9}, 3.6624004055803413`*^9, 3.6624007468383493`*^9, 
   3.662451126673245*^9, 3.662451628648733*^9, 3.6624519787793217`*^9, 
   3.6624521904765453`*^9, 3.6624523874936037`*^9, {3.662452478119276*^9, 
   3.662452489368067*^9}, 3.6624657779441442`*^9, 3.662467475137452*^9, 
   3.662468996091877*^9, 3.662472757121182*^9, 3.662473064473074*^9, 
   3.662483934305211*^9, 3.662483976016444*^9, 3.662484272479868*^9, {
   3.662488035942678*^9, 3.662488057339769*^9}, 3.662883195708178*^9, 
   3.662883242897889*^9, 3.6628832934661016`*^9, 3.662884304255122*^9, 
   3.662884543163178*^9, 3.662885400594767*^9, {3.66288546221395*^9, 
   3.66288549189824*^9}, 3.662885541549923*^9, 3.662885682690213*^9, 
   3.662885718669159*^9, {3.662885812650559*^9, 3.662885828267192*^9}, 
   3.6628859376182747`*^9, 3.662886079975251*^9, 3.662895078994488*^9, 
   3.662904538033802*^9, 3.66290460603275*^9, 3.662904788209737*^9, {
   3.662904895518458*^9, 3.662904924844247*^9}, 3.66290527149193*^9, 
   3.6629053167749443`*^9, 3.662905354535694*^9, {3.662905393215949*^9, 
   3.662905401936193*^9}, 3.6629054839877243`*^9, 3.662916908980957*^9, 
   3.662917482331112*^9, 3.662917775939065*^9, 3.6665194853970346`*^9}],

Cell[BoxData["100.08792313479879`"], "Output",
 CellChangeTimes->{{3.6617099569284763`*^9, 3.6617099812404003`*^9}, {
   3.661710012506362*^9, 3.6617100384082623`*^9}, {3.661710506852536*^9, 
   3.661710523305223*^9}, {3.6617105578860703`*^9, 3.661710564791472*^9}, {
   3.661710623555771*^9, 3.661710636990754*^9}, 3.6617112858918543`*^9, 
   3.6617114896045*^9, 3.661712715291013*^9, 3.6617131719895287`*^9, 
   3.661713209912673*^9, 3.661752904521997*^9, 3.6617535867713118`*^9, 
   3.661754011963746*^9, 3.661754060928838*^9, 3.661754134951688*^9, {
   3.6617541814326897`*^9, 3.6617542307384157`*^9}, {3.661754274411038*^9, 
   3.6617542957568197`*^9}, 3.661755978974861*^9, 3.661756172937132*^9, 
   3.661756516202907*^9, 3.661756843276073*^9, 3.6617572302714357`*^9, {
   3.662108543271372*^9, 3.662108557739957*^9}, {3.6621432901538467`*^9, 
   3.662143300573915*^9}, {3.662143524793378*^9, 3.662143539403919*^9}, 
   3.6621438169881563`*^9, 3.662144209161915*^9, 3.662144241528921*^9, 
   3.6621443678185673`*^9, 3.662386280337462*^9, 3.662386540185423*^9, 
   3.6623871829597797`*^9, 3.6623971842663307`*^9, 3.6623972863099337`*^9, 
   3.662397395998931*^9, 3.6623974433428164`*^9, {3.6623976991486998`*^9, 
   3.662397734403988*^9}, 3.662397876006646*^9, 3.662397925167726*^9, 
   3.662398024561902*^9, 3.6623984223441057`*^9, {3.662400110673503*^9, 
   3.66240012800143*^9}, 3.6624004055803413`*^9, 3.6624007468383493`*^9, 
   3.662451126673245*^9, 3.662451628648733*^9, 3.6624519787793217`*^9, 
   3.6624521904765453`*^9, 3.6624523874936037`*^9, {3.662452478119276*^9, 
   3.662452489368067*^9}, 3.6624657779441442`*^9, 3.662467475137452*^9, 
   3.662468996091877*^9, 3.662472757121182*^9, 3.662473064473074*^9, 
   3.662483934305211*^9, 3.662483976016444*^9, 3.662484272479868*^9, {
   3.662488035942678*^9, 3.662488057339769*^9}, 3.662883195708178*^9, 
   3.662883242897889*^9, 3.6628832934661016`*^9, 3.662884304255122*^9, 
   3.662884543163178*^9, 3.662885400594767*^9, {3.66288546221395*^9, 
   3.66288549189824*^9}, 3.662885541549923*^9, 3.662885682690213*^9, 
   3.662885718669159*^9, {3.662885812650559*^9, 3.662885828267192*^9}, 
   3.6628859376182747`*^9, 3.662886079975251*^9, 3.662895078994488*^9, 
   3.662904538033802*^9, 3.66290460603275*^9, 3.662904788209737*^9, {
   3.662904895518458*^9, 3.662904924844247*^9}, 3.66290527149193*^9, 
   3.6629053167749443`*^9, 3.662905354535694*^9, {3.662905393215949*^9, 
   3.662905401936193*^9}, 3.6629054839877243`*^9, 3.662916908980957*^9, 
   3.662917482331112*^9, 3.662917775939065*^9, 3.666519485401515*^9}],

Cell[BoxData["63.81835908076401`"], "Output",
 CellChangeTimes->{{3.6617099569284763`*^9, 3.6617099812404003`*^9}, {
   3.661710012506362*^9, 3.6617100384082623`*^9}, {3.661710506852536*^9, 
   3.661710523305223*^9}, {3.6617105578860703`*^9, 3.661710564791472*^9}, {
   3.661710623555771*^9, 3.661710636990754*^9}, 3.6617112858918543`*^9, 
   3.6617114896045*^9, 3.661712715291013*^9, 3.6617131719895287`*^9, 
   3.661713209912673*^9, 3.661752904521997*^9, 3.6617535867713118`*^9, 
   3.661754011963746*^9, 3.661754060928838*^9, 3.661754134951688*^9, {
   3.6617541814326897`*^9, 3.6617542307384157`*^9}, {3.661754274411038*^9, 
   3.6617542957568197`*^9}, 3.661755978974861*^9, 3.661756172937132*^9, 
   3.661756516202907*^9, 3.661756843276073*^9, 3.6617572302714357`*^9, {
   3.662108543271372*^9, 3.662108557739957*^9}, {3.6621432901538467`*^9, 
   3.662143300573915*^9}, {3.662143524793378*^9, 3.662143539403919*^9}, 
   3.6621438169881563`*^9, 3.662144209161915*^9, 3.662144241528921*^9, 
   3.6621443678185673`*^9, 3.662386280337462*^9, 3.662386540185423*^9, 
   3.6623871829597797`*^9, 3.6623971842663307`*^9, 3.6623972863099337`*^9, 
   3.662397395998931*^9, 3.6623974433428164`*^9, {3.6623976991486998`*^9, 
   3.662397734403988*^9}, 3.662397876006646*^9, 3.662397925167726*^9, 
   3.662398024561902*^9, 3.6623984223441057`*^9, {3.662400110673503*^9, 
   3.66240012800143*^9}, 3.6624004055803413`*^9, 3.6624007468383493`*^9, 
   3.662451126673245*^9, 3.662451628648733*^9, 3.6624519787793217`*^9, 
   3.6624521904765453`*^9, 3.6624523874936037`*^9, {3.662452478119276*^9, 
   3.662452489368067*^9}, 3.6624657779441442`*^9, 3.662467475137452*^9, 
   3.662468996091877*^9, 3.662472757121182*^9, 3.662473064473074*^9, 
   3.662483934305211*^9, 3.662483976016444*^9, 3.662484272479868*^9, {
   3.662488035942678*^9, 3.662488057339769*^9}, 3.662883195708178*^9, 
   3.662883242897889*^9, 3.6628832934661016`*^9, 3.662884304255122*^9, 
   3.662884543163178*^9, 3.662885400594767*^9, {3.66288546221395*^9, 
   3.66288549189824*^9}, 3.662885541549923*^9, 3.662885682690213*^9, 
   3.662885718669159*^9, {3.662885812650559*^9, 3.662885828267192*^9}, 
   3.6628859376182747`*^9, 3.662886079975251*^9, 3.662895078994488*^9, 
   3.662904538033802*^9, 3.66290460603275*^9, 3.662904788209737*^9, {
   3.662904895518458*^9, 3.662904924844247*^9}, 3.66290527149193*^9, 
   3.6629053167749443`*^9, 3.662905354535694*^9, {3.662905393215949*^9, 
   3.662905401936193*^9}, 3.6629054839877243`*^9, 3.662916908980957*^9, 
   3.662917482331112*^9, 3.662917775939065*^9, 3.666519485404603*^9}]
}, Open  ]],

Cell["\<\

Above commands enable us to globally work at a higher than default precision\
\>", "Text",
 CellChangeTimes->{{3.662904815052484*^9, 3.662904840258367*^9}, {
  3.664804019255335*^9, 3.664804023620372*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Epsilon]in", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"steps", "=", "50"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"min\[Epsilon]pow", "=", "25"}], ";"}]}], "Input",
 CellChangeTimes->{{3.662144085546682*^9, 3.662144108768538*^9}, 
   3.662144235061804*^9, {3.662904534087521*^9, 3.6629045370635653`*^9}}],

Cell[TextData[{
 "\nAbove are global parameters.  Very important is \[Epsilon]in, which in \
the paper is also called ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Epsilon]", "raw"], ",", " ", 
    RowBox[{"where", " ", "we"}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " consider the cases\n\[Epsilon]in=0.01    (the high noise regime)\n\
\[Epsilon]in=0.001  (the low noise regime)\n"
}], "Text",
 CellChangeTimes->{{3.664804025536503*^9, 3.664804112407695*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Distillation Cost", "Chapter",
 CellChangeTimes->{{3.662916926541147*^9, 3.662916943528555*^9}}],

Cell[CellGroupData[{

Cell["Protocols", "Section",
 CellChangeTimes->{{3.661679768566916*^9, 3.661679781066697*^9}, 
   3.6616942136067877`*^9, {3.6629048092395153`*^9, 3.6629048114411077`*^9}}],

Cell["\<\

Success probabiltiy and error out for various protocols.  Also a map funciton \
that takes as input a sqeuence, e.g.  {\[Epsilon] , C} where \[Epsilon] is \
the error of inpout states and C is there cost.  The function then outputs a \
new pair.\
\>", "Text",
 CellChangeTimes->{{3.66480412488344*^9, 3.6648041931629972`*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "standard ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["MEK", "3"], TraditionalForm]],
  FormatType->"TraditionalForm"]
}], "Subsection",
 CellChangeTimes->{{3.661706881474552*^9, 3.661706889935183*^9}, 
   3.661707096054743*^9, {3.662904665436211*^9, 3.662904671377054*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"PsMEK", "[", "\[Epsilon]_", "]"}], "=", 
     RowBox[{"1", "-", 
      RowBox[{"10", "\[Epsilon]"}], "+", 
      RowBox[{"58", 
       SuperscriptBox["\[Epsilon]", "2"]}], "-", 
      RowBox[{"192", 
       SuperscriptBox["\[Epsilon]", "3"]}], "+", 
      RowBox[{"400", 
       SuperscriptBox["\[Epsilon]", "4"]}], "-", 
      RowBox[{"544", 
       SuperscriptBox["\[Epsilon]", "5"]}], "+", 
      RowBox[{"480", 
       SuperscriptBox["\[Epsilon]", "6"]}], "-", 
      RowBox[{"256", 
       SuperscriptBox["\[Epsilon]", "7"]}], "+", 
      RowBox[{"64", 
       SuperscriptBox["\[Epsilon]", "8"]}]}]}], ";"}], "\[IndentingNewLine]", 
   
   RowBox[{
    RowBox[{
     RowBox[{"\[Epsilon]outMEK", "[", "\[Epsilon]_", "]"}], "=", 
     FractionBox[
      RowBox[{
       RowBox[{"9", 
        SuperscriptBox["\[Epsilon]", "2"]}], "-", 
       RowBox[{"56", 
        SuperscriptBox["\[Epsilon]", "3"]}], "+", 
       RowBox[{"160", 
        SuperscriptBox["\[Epsilon]", "4"]}], "-", 
       RowBox[{"256", 
        SuperscriptBox["\[Epsilon]", "5"]}], "+", 
       RowBox[{"240", 
        SuperscriptBox["\[Epsilon]", "6"]}], "-", 
       RowBox[{"128", 
        SuperscriptBox["\[Epsilon]", "7"]}], "+", 
       RowBox[{"32", 
        SuperscriptBox["\[Epsilon]", "8"]}]}], 
      RowBox[{"PsMEK", "[", "\[Epsilon]", "]"}]]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"MapMEK", "[", "input_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"\[Epsilon]outMEK", "[", 
        RowBox[{"input", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
       FractionBox[
        RowBox[{"5", "*", 
         RowBox[{"input", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], 
        RowBox[{"PsMEK", "[", 
         RowBox[{"input", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.661706898765862*^9, 3.661706987347528*^9}, {
  3.662904675629526*^9, 3.662904717566537*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["standard Bravyi-Haah", "Subsection",
 CellChangeTimes->{{3.661707008255546*^9, 3.661707020731599*^9}, 
   3.6617070985022593`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Pbh", "[", 
    RowBox[{"\[Epsilon]_", ",", " ", "k_"}], "]"}], "=", 
   RowBox[{
    RowBox[{
     FractionBox["1", "8"], "*", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       SuperscriptBox["x", "8"], "+", 
       RowBox[{"6", 
        SuperscriptBox["x", 
         RowBox[{"4", "+", 
          RowBox[{"2", "k"}]}]]}]}], ")"}]}], "/.", 
    RowBox[{"x", "\[Rule]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", "\[Epsilon]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Epsilon]outbh", "[", 
    RowBox[{"\[Epsilon]_", ",", " ", "k_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1", "-", 
      FractionBox[
       RowBox[{"1", "+", 
        RowBox[{"2", 
         SuperscriptBox["x", "7"]}], "+", 
        SuperscriptBox["x", "8"], "+", 
        RowBox[{"6", 
         SuperscriptBox["x", 
          RowBox[{"3", "+", 
           RowBox[{"2", "k"}]}]]}], "+", 
        RowBox[{"6", 
         SuperscriptBox["x", 
          RowBox[{"4", "+", 
           RowBox[{"2", "k"}]}]]}]}], 
       RowBox[{"2", "*", 
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["x", "8"], "+", 
          RowBox[{"6", 
           SuperscriptBox["x", 
            RowBox[{"4", "+", 
             RowBox[{"2", "k"}]}]]}]}], ")"}]}]]}], ")"}], "/.", 
    RowBox[{"x", "\[Rule]", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", "\[Epsilon]"}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MapBH", "[", 
   RowBox[{"input_", ",", " ", "k_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Epsilon]outbh", "[", 
     RowBox[{
      RowBox[{"input", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", " ", "k"}], "]"}], ",", 
    FractionBox[
     RowBox[{
      RowBox[{"(", 
       RowBox[{"3", "+", 
        FractionBox["8", "k"]}], ")"}], "*", 
      RowBox[{"input", "[", 
       RowBox[{"[", "2", "]"}], "]"}]}], 
     RowBox[{"Pbh", "[", 
      RowBox[{
       RowBox[{"input", "[", 
        RowBox[{"[", "1", "]"}], "]"}], ",", "k"}], "]"}]]}], 
   "}"}]}]}], "Input",
 CellChangeTimes->{{3.661707031917489*^9, 3.661707072926538*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["15 qubit Reed-Muller code", "Subsection",
 CellChangeTimes->{{3.6617070768270817`*^9, 3.6617071003663816`*^9}, {
  3.6629046576129427`*^9, 3.662904660171783*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Ps15", "[", "\[Epsilon]_", "]"}], ":=", 
     FractionBox[
      RowBox[{"1", "+", 
       RowBox[{"15", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "\[Epsilon]"}]}], ")"}], "8"]}]}], "16"]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Er15", "[", "\[Epsilon]_", "]"}], ":=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"15", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", "\[Epsilon]"}]}], ")"}], "7"]}], "+", 
        RowBox[{"15", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", 
            RowBox[{"2", "\[Epsilon]"}]}], ")"}], "8"]}], "-", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "\[Epsilon]"}]}], ")"}], "15"]}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"32", "*", 
        RowBox[{"Ps15", "[", "\[Epsilon]", "]"}]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Map15", "[", "input_", "]"}], ":=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Er15", "[", 
        RowBox[{"input", "[", 
         RowBox[{"[", "1", "]"}], "]"}], "]"}], ",", 
       FractionBox[
        RowBox[{"15", "*", 
         RowBox[{"input", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], 
        RowBox[{"Ps15", "[", 
         RowBox[{"input", "[", 
          RowBox[{"[", "1", "]"}], "]"}], "]"}]]}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.6617071467648287`*^9, {3.6617071846038713`*^9, 3.6617072591170673`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 FormBox[
  SubscriptBox["MEK", "L"], TraditionalForm]],
 FormatType->"TraditionalForm"]], "Subsection",
 CellChangeTimes->{
  3.6617070907059793`*^9, {3.661707286560197*^9, 3.66170730290851*^9}, {
   3.6617073359371643`*^9, 3.66170733652922*^9}, {3.6629046461116533`*^9, 
   3.662904649453744*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PmekL", "[", 
    RowBox[{"\[Epsilon]3_", ",", "\[Epsilon]k_", ",", "\[Delta]_"}], "]"}], 
   "=", 
   RowBox[{"1", "-", 
    RowBox[{"448", " ", 
     SuperscriptBox["\[Epsilon]3", "5"]}], "+", 
    RowBox[{"448", " ", 
     SuperscriptBox["\[Epsilon]3", "6"]}], "-", 
    RowBox[{"256", " ", 
     SuperscriptBox["\[Epsilon]3", "7"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["\[Epsilon]3", "8"]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[Delta]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "\[Epsilon]3"}]}], ")"}], "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "\[Epsilon]k"}]}], ")"}], "2"]}], "-", 
    RowBox[{"2", " ", "\[Epsilon]k"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
    RowBox[{"64", " ", 
     SuperscriptBox["\[Epsilon]3", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", "\[Epsilon]k", "+", 
       SuperscriptBox["\[Epsilon]k", "2"]}], ")"}]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["\[Epsilon]3", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"9", "-", "\[Epsilon]k", "+", 
       SuperscriptBox["\[Epsilon]k", "2"]}], ")"}]}], "-", 
    RowBox[{"8", " ", "\[Epsilon]3", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "\[Epsilon]k"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["\[Epsilon]3", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"6", " ", "\[Epsilon]k"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Epsilon]outmekL", "[", 
    RowBox[{"\[Epsilon]3_", ",", "\[Epsilon]k_", ",", "\[Delta]_"}], "]"}], 
   "=", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"PmekL", "[", 
      RowBox[{"\[Epsilon]3", ",", "\[Epsilon]k", ",", "\[Delta]"}], "]"}]], 
    "*", 
    RowBox[{"(", 
     RowBox[{
      FractionBox["\[Delta]", "4"], "-", 
      RowBox[{"2", " ", "\[Delta]", " ", "\[Epsilon]3"}], "+", 
      RowBox[{"8", " ", 
       SuperscriptBox["\[Epsilon]3", "2"]}], "+", 
      RowBox[{"6", " ", "\[Delta]", " ", 
       SuperscriptBox["\[Epsilon]3", "2"]}], "-", 
      RowBox[{"48", " ", 
       SuperscriptBox["\[Epsilon]3", "3"]}], "-", 
      RowBox[{"8", " ", "\[Delta]", " ", 
       SuperscriptBox["\[Epsilon]3", "3"]}], "+", 
      RowBox[{"136", " ", 
       SuperscriptBox["\[Epsilon]3", "4"]}], "+", 
      RowBox[{"4", " ", "\[Delta]", " ", 
       SuperscriptBox["\[Epsilon]3", "4"]}], "-", 
      RowBox[{"224", " ", 
       SuperscriptBox["\[Epsilon]3", "5"]}], "+", 
      RowBox[{"224", " ", 
       SuperscriptBox["\[Epsilon]3", "6"]}], "-", 
      RowBox[{"128", " ", 
       SuperscriptBox["\[Epsilon]3", "7"]}], "+", 
      RowBox[{"32", " ", 
       SuperscriptBox["\[Epsilon]3", "8"]}], "+", 
      SuperscriptBox["\[Epsilon]k", "2"], "-", 
      RowBox[{"\[Delta]", " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
      RowBox[{"8", " ", "\[Epsilon]3", " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
      RowBox[{"8", " ", "\[Delta]", " ", "\[Epsilon]3", " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
      RowBox[{"24", " ", 
       SuperscriptBox["\[Epsilon]3", "2"], " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
      RowBox[{"24", " ", "\[Delta]", " ", 
       SuperscriptBox["\[Epsilon]3", "2"], " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
      RowBox[{"32", " ", 
       SuperscriptBox["\[Epsilon]3", "3"], " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
      RowBox[{"32", " ", "\[Delta]", " ", 
       SuperscriptBox["\[Epsilon]3", "3"], " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
      RowBox[{"16", " ", 
       SuperscriptBox["\[Epsilon]3", "4"], " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
      RowBox[{"16", " ", "\[Delta]", " ", 
       SuperscriptBox["\[Epsilon]3", "4"], " ", 
       SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MapMEKLbeyond", "[", 
   RowBox[{"input3_", ",", "inputk_", ",", "input\[Delta]_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Epsilon]outmekL", "[", 
     RowBox[{
      RowBox[{"input3", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"inputk", "[", 
       RowBox[{"[", "1", "]"}], "]"}], ",", 
      RowBox[{"input\[Delta]", "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ",", 
    FractionBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"2", "*", 
        RowBox[{"inputk", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "+", 
       RowBox[{"8", "*", 
        RowBox[{"input3", "[", 
         RowBox[{"[", "2", "]"}], "]"}]}], "+", 
       RowBox[{"input\[Delta]", "[", 
        RowBox[{"[", "2", "]"}], "]"}]}], ")"}], 
     RowBox[{"2", "*", 
      RowBox[{"PmekL", "[", 
       RowBox[{
        RowBox[{"input3", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"inputk", "[", 
         RowBox[{"[", "1", "]"}], "]"}], ",", 
        RowBox[{"input\[Delta]", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}]]}], 
   "}"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.661707493610581*^9, 3.661707506426157*^9}, {
   3.661713166097911*^9, 3.661713169292515*^9}, 3.6621431054900503`*^9, {
   3.662385933608713*^9, 3.662386113804791*^9}, {3.6623861466554117`*^9, 
   3.662386276386744*^9}, 3.66238636189769*^9, 3.662396504144024*^9, {
   3.662488029005186*^9, 3.6624880292196693`*^9}, {3.662712263585457*^9, 
   3.662712277649845*^9}, {3.6627124681048307`*^9, 3.6627124683291073`*^9}, {
   3.662714828256957*^9, 3.662714852190538*^9}, {3.662883171874749*^9, 
   3.662883224417057*^9}, {3.662883278836562*^9, 3.6628832792102423`*^9}, {
   3.6628842661858263`*^9, 3.662884302877589*^9}, {3.662890227324395*^9, 
   3.662890233387226*^9}, {3.6629047287675667`*^9, 3.6629047470714197`*^9}, {
   3.662905391960553*^9, 3.6629053961834173`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["DP", "Subsection"]], "Subsection",
 CellChangeTimes->{
  3.6617070907059793`*^9, {3.661707286560197*^9, 3.66170730290851*^9}, {
   3.6617073359371643`*^9, 3.66170733652922*^9}, {3.6624504492688227`*^9, 
   3.662450469680159*^9}, {3.66290487093235*^9, 3.662904890244102*^9}, 
   3.664804212251719*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"PsDP", "[", 
    RowBox[{"\[Epsilon]3_", ",", "\[Epsilon]k_", ",", "\[Delta]_"}], "]"}], 
   "=", 
   RowBox[{"1", "-", 
    RowBox[{"2", "*", "\[Epsilon]k"}], "-", 
    RowBox[{"16", "*", "\[Epsilon]3"}], "-", "\[Delta]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[Epsilon]outDP", "[", 
    RowBox[{"\[Epsilon]3_", ",", "\[Epsilon]k_", ",", "\[Delta]_"}], "]"}], 
   "=", 
   RowBox[{
    SuperscriptBox["\[Epsilon]k", "2"], "+", 
    RowBox[{"15", "*", 
     SuperscriptBox["\[Epsilon]3", "2"]}], "+", "\[Delta]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.661707493610581*^9, 3.661707506426157*^9}, {
   3.661713166097911*^9, 3.661713169292515*^9}, 3.6621431054900503`*^9, {
   3.662385933608713*^9, 3.662386113804791*^9}, {3.6623861466554117`*^9, 
   3.662386276386744*^9}, 3.66238636189769*^9, 3.662396504144024*^9, {
   3.662450486513295*^9, 3.662450492913068*^9}, {3.662450530707325*^9, 
   3.662450552450308*^9}, {3.662450602820651*^9, 3.6624506759408693`*^9}, 
   3.6624509339467783`*^9, 3.662883249586339*^9, {3.662904887914465*^9, 
   3.662904887919249*^9}, {3.666504731812633*^9, 3.666504739262505*^9}}],

Cell["\<\
Approximate, leading order expressions for the Duclos-Ciani and Poulin \
protcol.  Provided by Duclos-Ciani in private communication.  Note they \
differ from those given in their paper as the published paper gives an \
expression that counts all the weight 2 errors as contirbuting to \
\[Epsilon]out, when in fact only a fraction actually contribute to \
\[Epsilon]out.  While the equation in the Duclos-Ciani and Poulin paper is \
incorrect, their analysis and plots are based on the correct expression \
obtained by explicit simulation in mathematica.
\
\>", "Text",
 CellChangeTimes->{{3.66480421407381*^9, 3.664804251852517*^9}, {
  3.6665047460461607`*^9, 3.666504801215847*^9}, {3.6665052323514977`*^9, 
  3.6665053634908037`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MEK performance for 1 round", "Section",
 CellChangeTimes->{{3.662450689778887*^9, 3.662450724789761*^9}, 
   3.662451078740109*^9, {3.662917788654726*^9, 3.662917790676697*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Epsilon]plot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Epsilon]outDP", "[", 
          RowBox[{"\[Epsilon]", ",", "\[Epsilon]", ",", 
           SuperscriptBox["\[Epsilon]", "2"]}], "]"}], ",", 
         RowBox[{"\[Epsilon]outmekL", "[", 
          RowBox[{"\[Epsilon]", ",", "\[Epsilon]", ",", 
           SuperscriptBox["\[Epsilon]", "2"]}], "]"}], ",", 
         RowBox[{"\[Epsilon]outMEK", "[", "\[Epsilon]", "]"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Epsilon]", ",", 
         SuperscriptBox["10", 
          RowBox[{"-", "5"}]], ",", "0.01"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Solid", ",", " ", "Blue"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"Pink", ",", "Solid"}], "}"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", "Dotted"}], "}"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"probplot", "=", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "-", 
          RowBox[{"PsDP", "[", 
           RowBox[{"\[Epsilon]", ",", "\[Epsilon]", ",", 
            SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}], ",", 
         RowBox[{"1", "-", 
          RowBox[{"PmekL", "[", 
           RowBox[{"\[Epsilon]", ",", "\[Epsilon]", ",", 
            SuperscriptBox["\[Epsilon]", "2"]}], "]"}]}], ",", 
         RowBox[{"1", "-", 
          RowBox[{"PsMEK", "[", "\[Epsilon]", "]"}]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Epsilon]", ",", "0", ",", "0.01"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Solid", ",", " ", "Blue"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"{", 
            RowBox[{"Pink", ",", "Solid"}], "}"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Purple", ",", "Dotted"}], "}"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", "\[Epsilon]plot", "}"}], ",", 
      RowBox[{"{", "probplot", "}"}]}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.662450726369952*^9, 3.662450776222908*^9}, {
   3.662450818792371*^9, 3.66245090068225*^9}, 3.662450937006124*^9, {
   3.6624509748936653`*^9, 3.662451020844782*^9}, {3.662465644947338*^9, 
   3.662465726630569*^9}, {3.662467775104437*^9, 3.662467778751176*^9}, 
   3.662468274147019*^9, {3.6624727510072527`*^9, 3.66247283689023*^9}, {
   3.662483946368417*^9, 3.6624839474804068`*^9}, {3.6624880414329863`*^9, 
   3.662488042804174*^9}, {3.662712319876828*^9, 3.662712340341324*^9}, {
   3.66271237566949*^9, 3.6627124620880737`*^9}, {3.6627148698554573`*^9, 
   3.6627149042405653`*^9}, {3.662714969236444*^9, 3.662714970930689*^9}, {
   3.662720802403502*^9, 3.6627208073475733`*^9}, {3.662720955322411*^9, 
   3.662720960968752*^9}, {3.662720999199926*^9, 3.6627210002021713`*^9}, {
   3.662721089374938*^9, 3.662721091469248*^9}, 3.662725572127861*^9, {
   3.662883257027094*^9, 3.6628832617957487`*^9}, {3.6628833021955423`*^9, 
   3.662883304882534*^9}, {3.662894999252913*^9, 3.662895234463847*^9}, {
   3.6629047595215473`*^9, 3.66290476472157*^9}, {3.662904887926409*^9, 
   3.662904887947299*^9}, {3.662914922389208*^9, 3.662914951397195*^9}, {
   3.666504741710457*^9, 3.666504744048359*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {InsetBox[
     GraphicsBox[{{}, {}, 
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV1Pk/1HsbgHHZ6hzGkhDVQdl3jmT93PYZmpiZiGaEDLJF9j1MX1kSJUsS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         "]]}, 
       {RGBColor[1, 0.5, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwV0Hk81IkbwHFC2XWnSJJjidYREoqexzhyNM2MQSmKDDlz5UrI8RUhahaF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         "]]}, 
       {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{0, Small}], LineBox[CompressedData["
1:eJwVlWk41Asbxu10bK0ke9kKoSSh56GxTkxjUEKSpSyDbJGQ5S+RLdnn6GRJ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         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
        AbsolutePointSize[6], "ScalingFunctions" -> None},
      PlotRange->NCache[{{
          Rational[1, 100000], 
          0.010000000000000000000000000000000000000000000000000000000000000000\
000000000000000000000000000000000000000000000000000000000000000000001`100.}, {
         0., 0.0016999999306816338`}}, {{0.00001, 0.01}, {0., 
        0.0016999999306816338`}}],
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {189., -118.66252583997979`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
     GraphicsBox[{{}, {}, 
       {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVUGs0lAkA/VivIitZj1INTXmctmi1RTVXKSGikZ3yaiJajxhbhPEY+sJa
emybTjWEWrXOHMYjMpSh8Q1nh3TITOVVHiGssZHaatf+uOfec+6P+zALimaG
qBIE4bGI/3nb3vkprs7krkXJ0b6wmdGjtTqrVtTGIMSDf+rO6mB84/roVNFz
BkHLVO1UmuJvxh9BwaJxBjEzZ1Kh3IiF/RH+PqIPDIIYyS9W7kSiu/vRg6Il
IAoPeOUr3VHf0SB3E5mAoAdkFyj90fv1nKGryArEEfPxEmUkXq/LTHJ54gBC
dXd8oFUKeHKFbsSEE3ix6uoTJzMgDI/rTHV3Ay/zFiM0Lxft3EzfbL4XxAkm
xWzhr1jGeLm9XO4NR7uQC5reebBOFlgaHGFhkLVrosDpBoyHVJbTWn3hSA4E
y80K0CkJDNH4HACboBpVSX8hqi7zQ/Lq2aBpxNhc7SrGUEpuh6FfEGiHNtHM
794BN1VcFT4bjMEXEx9TYkqQzqgsChSEQI9T5f0s6B6i6u+2NLqcBFsw9XR0
Syna5v1mxZphmNmcz5y1EiBnH/Pm1UfhKPx5YKbdqAx2TPdEOSsSNKa9wYnh
chxYrR5UtyIK8a/Y0R/fCrG/pClVqzIajgWHp9c+q8DzuDVd3DoOLvWyv3r8
tBJO9GR639UYjMk2aHW0VaFQ2KcXG/wTOBkrerZWVMOOn68SsOc0xLe7clYJ
7qM+9FguV/8MFtTLhwLyajDvsEd+rv8MZpZ/q9BMqsWPUeT63vpY6PE2adjE
PkA7r1U3IjsOetUD56sD6hA2G/HJNfwssjaEptUeFaHulM09fed4KOyHvzM/
VI9P0vnp5SsSMPO+6c3YtgbEpZk6HFcm4NKtubBNWx5iyGQv7Y04EVqCG5In
qx5BrSFH8kMOF5fafUkF0Qj/h3anDMOSQCscDWJ/aMTd/H6hzrZkbE9SjBRx
xLDqe7PANExBJFXt5j0tRsE/sy+fjKaAyDJjVwY3QbpubfL3Vamwcbtv3NLT
hCs+PpfjXHiY3GBdes27GQ1afNupch60do5JjFqbkRah361NS8O7hUfPWc6P
QfO+7rP2Qhq6pZEFB5ofw966iN7xbtHfbS2Z3CrBlFAxRz+RDlkNc9nBKglW
Wlw2MJKlI6t06W1/yxaYm/vqf7E9hyzW9cY1N1vQImPq5xaeg+PggEWREYXX
obJjtZokOhey73f+QsH0lacmuYREJGzT5bkUWH5dZV7aJB4kDB/sv0hB5vni
87guCZe2mLG3VyjUbB+7aWpIwr/bwlSTTyF7qZoijU7iyA2VjF0CCrZlO7zc
d5Pgj0QEl8ooRFo2vjd2IsEpEtpWdFAoKd5za2QviXdeqsSDTgorr7lOp7iQ
mMyW8Vu6KajxWDkVniQGwz/1DPZSUBw63WoYSOK3F20eRlMU9GXz0UPHSKg9
7TNd8xcFD+dEI+FxEvT6L2/pSgrNDmmhriGLfcJPZm+ZoyBYd1EtKXJxj123
1OMzhdF8fYFLFIn4Vs9rh/+lYGac5/0NZzHPUxHqpyJFnk5+cdlpEkJ7PY0w
dSk6M2hu3FgSxvzGZ9GaUmir3FHuP0vCcpb7e9wSKZy5FtcNEkgM79gXm6wt
BW+u1PFV4uJfCav2kcuk+A+EBEWn
         "]]}, 
       {RGBColor[1, 0.5, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
        LineBox[CompressedData["
1:eJwVkn8wlAkYx1+dWkVo7UklrehS1zjNdSl1+xViOUWMlIT8WGVZIor1Y+md
NOKUQxS1nKRs67V+vGupZDKYQ5q6lkqnXEW0JyHKNffeH888z3eeZz7Pd555
zIOjvcIWEASxh4n/s63TzHux3vjPTBnTk2nOe6Kz+iyt6uIRxFczKYfA6KZ1
0WmqAR5hvzgpgmOIj7wbwSGqUR4h6ev4kcPFrIvQ30c1x/R/ooaMbJDk7n5w
r2oxCDKo2sXIHs29LWo31QoQEW3OpmxPPDeYNnZVbQCRHG3QZRCEVxaZyfwH
diA0U7JEOgYSdb++8J0jJHPc0D96T4GKSOhLc3dDq+Ucddxfgh5xpl9WiSck
YwcvdlWQWMp7tq1G7c3oiqrcsrPYmCKz4hzwBTFC6Vh/yIbJsNYybqcfpBMN
d78pOI+++wFhi/49DEkWq3PiXB7qLpSEFTYHQTLD6lggy8dwak6v8aFgEAvX
pqgqCyFOa62LmAyB/VxTvl9hETJ4irIAWRi4zxVFT+WXIGq+3n6XH47WUHON
c3kJumYOTbayjmHoa8IJvztXkL3b63LBnQhI8s4dLAuXYouXe5LaNxKeZsW5
NYfL8MvqhcFNRiKc9xBGacLL4VJ5L01HEQ3uNeLOQODvGEgweyRuisFQzQ8Z
A8IKOFqmWA4WHIdh+6Uur9hrkFKDhvEhsaDGeLtKBJXYUlKqddghDq0rbWPU
outoFgTmiNkn4GlhbjQdWoUZOwf16RcnIJ0qu0f53MBREbnueXM8WnPkJ3f6
3USPpFNfmJUAqtLfpMe9GscmhfOuESdhU+jEZnvL0BRlU8V2PgUba72MMe9b
mO+Y0SwzSsTQAtE/4w5yJKSb2h35kIgg0Y4rkt01GF7hxH3bmoSR75NXrV9F
Qbsl+/7+bDH4sXkG785T8L+9Jcr4WDKqSs+UhBnW4nrpC0rPNgWUypFlkFmL
DYNvZ72MUxH0MDI+hKXAlS+Tzx68YXTjbLUmVYEOizUpW+vSMGJL2wx+VOA3
H58LCXwJitw+8wWxdWjRKdn8vkaCICp8futIHdKF7Me63HTwP9+6lx9eD653
sc+aX9NB1Y1b7fu7Hts3lln2TqWjr1jPTXCgAe+p/mnL0AwcsO59+unPBqxc
f4GzvDsD3LgNr9+5NWLtWj/2182ncfR2wLK9txvR3u3FzpGextmlj8+t3k7j
laA7kGaRzD/VaAXKaJi+9GCRi0n0W0TqHpHT8D30SO6pSyLm0V8GIRSNbo+n
/47qM/OcMZ3wehqN20YumxqTmAjOaxa10Mhaot2fbkliKMXaIqWbxmb5Dk/3
XSSkDzRfCsZpRFrd/WTiSMKqPd//ooZGZbnD1ddOJGbbJumiCRorL7pqUvkk
Ti1SB1yeoqEt8c2u9SBRNL0rSjpPo39fXKdxAMNvrM6+oacEu3smejiQ8VOr
Lrqpr8Qe56Tl1BGGH91ytdpQiTa7dIFrGAmugCq9xVFCZpGrnRxJojPT0a/W
VIk3pWwZX8TsH926U2GmhLlJofe3MQw/atikjqtEoV5puTyO4S852lZvqUTf
Ga6bOJ7xs90+t+E7JXS1Kj64nCTR1/Rwf6OVEs7i9cWcROZehaYr6I1KSKZv
2r9MImHyjPuE3qTEf2TvOyA=
         "]]}, 
       {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
        Dashing[{0, Small}], LineBox[CompressedData["
1:eJwVUH0w1AkA/XVxFIldLUpnsUaqa7iakpv2bflaWrU4EWKjVa2vLSWsZZdf
p5O+S8nSUvn+WKTfWkI3danT2pmuw1UuTEoXg4uYU3P64817M+/Nm3nPNiox
QPgNQRB+C/jKWzxmxiTGH7YtSPHTHFv2n4arT1Gax2xCVjx9w5zA6HqHxExN
P5tg8hxF5qb4l10ZFa0ZZRMToXYbzZmY9Y4ND9LMsQnDEOHfdGek8Xh7d2mW
gDjQv8KTzkGrtq3XV2MFYj7d2oLGx8vl0wwfjRMI68Xt7csFGLLPSef2uIF4
bhQYTYkh6+0ziX3vDmKv1frr2hSoRMm6TJ4vCA5t0CtchqeSnNBcBR9EyGvx
yVsklrFfuNb3BoI4u7lsQ8kprJXWrDEPCQbnI9e6YiIPlsOLzJhdoRDEjDyv
vnweugcRwm8/7wNTWaHLOn0RTRcUwvxWAV5nH9yQVn0ZwxlntIywKMiMjWWM
snxIMjubRFPRkClsogquXEMWu7EkokYIYlUz41PtdSS0lj/s4B4E02nlLKdE
gcczYVOdBochsOJlrb9XjDzPgMIr7SLwTXvjpmOU2BTAS+sNjsN5P+6H8fAS
7FytH9VCTwBnsnAZ42ApvMvuZxo2JoJflmnwPuIm+pO/eyZpWfiFM7+1R3QL
7iwp69WVI3DuVdh9f+Q2lKpXpsejj0LlzxgPE5Zhk6Jo0b4dSRBws2dS4svR
GhN5RkI7Br6+vl9qdAVm3Hb0Zg8cgyCB7mLxUyUOJZAOL1uPQ8UeF8pDqvBU
1mUSm5uMzqXK8knfahyeip33EZ0Ax2NjKM2/Bi3xzhU0rxTwpbvmfvOvxfyj
mXEzeiqIVg/iNqcOyXJrt/2TqTBVb3Qwc6/HsJUH821nGpiDqv0vrVTQa8t7
sCdPggnhiGveORXC722KZxxOR2eSjWTKpAHlRQMq4y1SGOaeJnNONsDp1dvZ
AEYG3p2I5z3Ub0Txf1MvekYyoGxe2ucmbcQjexvp5qZMHGJxbtKnGnEpKOhC
MlcGQcuXElLchDZDhctYvQymGUPB7JEmyGNpfxgx5RDXiyuzhHfADCwIsjkr
h3M0+YvD0B1sXVvC0n6Uo6/OUGC3pxljqr5p1oEs6NYVryh41oyVjhfMLbqz
YGlhe/Eo9y7s7EJpX1yyodt5ld2muYuH3QG0M8psXKuqPJe4mcJQTHckZUDC
9OO4d34lBevB3QbkEhKuzu79V6spBIc9q+MbkZhd5yksqKXQvfuvz6MmJEIu
BsQrGijcdX1XaM0g8S7u8rbSFgq5S/X65CwSnaPtAzWPKbjU/cjnbScxIVvM
ah+lELem45Ol+0I/zdGo4x8KZaU7brzxIMF5M/ehY4zCyqs+4xncr/la5f1J
Cnqy4LyG3STOv/brejBHoc8/qYsRQUKplVo+WaIGrXsmcTiSBMEqrHpipIaf
V5qFav/CnvRDW35fpsavbvIYHyEJ3QH69m4zNWrsz+mlx5FYI6o211qpMVJE
q+EmkOA6+qZrV6lha5kfuEJM4pp3wYB2tRr5xkWldUkL/hD3Uo+tGrqfmb6S
4wv+sco3PfZqGC26Nel9gkTKdc0POgc1vCSOBeapJLoi09N0jmrIpqs4g2kk
VLrxNp2TGv8DDiIrEA==
         "]]}},
      AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
      Axes->{True, True},
      AxesLabel->{None, None},
      AxesOrigin->{0, 0},
      DisplayFunction->Identity,
      Frame->{{False, False}, {False, False}},
      FrameLabel->{{None, None}, {None, None}},
      FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
      GridLines->{None, None},
      GridLinesStyle->Directive[
        GrayLevel[0.5, 0.4]],
      Method->{
       "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
        AbsolutePointSize[6], "ScalingFunctions" -> None},
      PlotRange->{{0, 0.01}, {0., 0.180099996322449}},
      PlotRangeClipping->True,
      PlotRangePadding->{{
         Scaled[0.02], 
         Scaled[0.02]}, {
         Scaled[0.05], 
         Scaled[0.05]}},
      Ticks->{Automatic, Automatic}], {189., -355.98757751993935`}, 
     ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}, {}},
  ContentSelectable->True,
  ImageSize->{370.234375, Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.662895222847713*^9, 3.662895235097045*^9}, 
   3.662904538220107*^9, 3.662904606225168*^9, 3.662904788419985*^9, {
   3.662904895664727*^9, 3.662904924991289*^9}, 3.662905271705846*^9, 
   3.662905316952326*^9, 3.66290535470298*^9, {3.6629053933596487`*^9, 
   3.6629054022260857`*^9}, 3.662905484222643*^9, {3.662914927464005*^9, 
   3.662914971991251*^9}, 3.6629169091588383`*^9, 3.662917482496727*^9, 
   3.6629177760979757`*^9, 3.666519485661278*^9}]
}, Open  ]],

Cell[TextData[{
 "\nComparison of the failure probabiltiy and error out for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["MEL", "3"], ",", " ", 
    RowBox[{
     SubscriptBox["MEL", "L"], " ", "and", " ", 
     RowBox[{
      SubscriptBox["DP", "L"], ".", " "}]}]}], TraditionalForm]]],
 " Equations used are exact for ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox["MEL", "3"], " ", "and", " ", 
   SubscriptBox["MEL", "L"]}]]],
 " but only leading order approximations for ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["DP", "L"], "."}], TraditionalForm]]],
 "\n\nPlots above used as basis for Fig 4.a of paper."
}], "Text",
 CellChangeTimes->{{3.6648042638328867`*^9, 3.664804351728266*^9}, {
  3.6648726114141083`*^9, 3.664872623530725*^9}, {3.664872688181456*^9, 
  3.6648726886531343`*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Functions for manipulating lists of data", \
"Section"]], "Subsection",
 CellChangeTimes->{{3.662386365792305*^9, 3.662386384950595*^9}, {
  3.662916971274509*^9, 3.662916979346034*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"BestOf", "[", "listin_", "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "size", ",", " ", "best", ",", "j", ",", "\[Epsilon]upper", ",", 
       "now"}], "}"}], ",", 
     RowBox[{
      RowBox[{"size", "=", 
       RowBox[{
        RowBox[{"Dimensions", "[", "listin", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"best", "=", 
       RowBox[{"{", 
        RowBox[{"{", 
         RowBox[{"\[Epsilon]in", ",", " ", "1"}], "}"}], "}"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"now", "=", "listin"}], ";", "\[IndentingNewLine]", 
      RowBox[{"For", "[", 
       RowBox[{
        RowBox[{"j", "=", "0"}], ",", 
        RowBox[{"j", "<", "steps"}], ",", 
        RowBox[{
         RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
         RowBox[{"\[Epsilon]upper", "=", 
          RowBox[{"\[Epsilon]in", "*", 
           SuperscriptBox["10", 
            RowBox[{"-", 
             FractionBox[
              RowBox[{"min\[Epsilon]pow", "*", "j"}], "steps"]}]]}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"now", "=", 
          RowBox[{"Select", "[", 
           RowBox[{"now", ",", " ", 
            RowBox[{
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "\[LessEqual]", 
              "\[Epsilon]upper"}], "&"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"now", "=", 
          RowBox[{"SortBy", "[", 
           RowBox[{"now", ",", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], "&"}]}], "]"}]}], ";", 
         "\[IndentingNewLine]", 
         RowBox[{"If", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Dimensions", "[", "now", "]"}], "[", 
             RowBox[{"[", "1", "]"}], "]"}], ">", "0"}], ",", 
           "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{"best", "=", 
             RowBox[{"Append", "[", 
              RowBox[{"best", ",", 
               RowBox[{"now", "[", 
                RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";"}]}], "]"}], 
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"best", "=", 
       RowBox[{"DeleteDuplicates", "[", "best", "]"}]}], ";", 
      "\[IndentingNewLine]", "best"}]}], "\[IndentingNewLine]", 
    "]"}]}]}]], "Input"],

Cell["\<\
BestOf takes large lists of the form {epsilon, Cost} and sifts for the lowest \
cost protocols within a certain epsilon window.
\
\>", "Text",
 CellChangeTimes->{{3.6629169879041767`*^9, 3.6629170317574863`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"nextPIV", "[", 
   RowBox[{"oldPIV_", ",", " ", "MagicCost_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
     "tempCost", ",", "dimOLD", ",", " ", "dimNEW", ",", "j", ",", "k", ",", 
      " ", "jkelement", ",", " ", "\[Delta]", ",", " ", "C", ",", " ", 
      "\[Epsilon]new", ",", " ", "\[Epsilon]old"}], "}"}], ",", " ", 
    RowBox[{
     RowBox[{"tempCost", "=", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], "}"}]}], ";", 
     RowBox[{"dimOLD", "=", 
      RowBox[{
       RowBox[{"Dimensions", "[", "oldPIV", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", 
     RowBox[{"dimNEW", "=", 
      RowBox[{
       RowBox[{"Dimensions", "[", "MagicCost", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"tempCost", "=", 
      RowBox[{"{", 
       RowBox[{"{", 
        RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"j", "=", "0"}], ",", 
       RowBox[{"j", "<", "dimOLD"}], ",", " ", 
       RowBox[{
        RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"k", "=", "0"}], ",", 
          RowBox[{"k", "<", "dimNEW"}], ",", 
          RowBox[{
           RowBox[{"k", "++"}], ";", "\[IndentingNewLine]", 
           RowBox[{"\[Epsilon]new", "=", 
            RowBox[{"MagicCost", "[", 
             RowBox[{"[", 
              RowBox[{"k", ",", "1"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"\[Epsilon]old", "=", 
            RowBox[{"oldPIV", "[", 
             RowBox[{"[", 
              RowBox[{"j", ",", "1"}], "]"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"\[Delta]", "=", 
            RowBox[{
             RowBox[{
              FractionBox["1", "2"], "*", "\[Epsilon]new"}], " ", "+", 
             RowBox[{
              FractionBox["1", "2"], "*", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"\[Epsilon]new", "*", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "\[Epsilon]old"}], ")"}]}], "+", 
                RowBox[{"\[Epsilon]old", "*", 
                 RowBox[{"(", 
                  RowBox[{"1", "-", "\[Epsilon]new"}], ")"}]}]}], ")"}]}]}]}],
            ";", "\[IndentingNewLine]", 
           RowBox[{"C", "=", 
            RowBox[{
             RowBox[{"MagicCost", "[", 
              RowBox[{"[", 
               RowBox[{"k", ",", "2"}], "]"}], "]"}], "+", 
             RowBox[{
              FractionBox["1", "2"], "*", 
              RowBox[{"oldPIV", "[", 
               RowBox[{"[", 
                RowBox[{"j", ",", "2"}], "]"}], "]"}]}]}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"jkelement", "=", 
            RowBox[{"{", " ", 
             RowBox[{"\[Delta]", " ", ",", "C"}], "}"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"tempCost", "=", 
            RowBox[{"Append", "[", 
             RowBox[{"tempCost", ",", " ", "jkelement"}], "]"}]}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";"}]}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"tempCost", "=", 
      RowBox[{"BestOf", "[", "tempCost", "]"}]}], ";", "\[IndentingNewLine]", 
     
     RowBox[{"Print", "[", 
      RowBox[{
      "\"\<Pivotal compile complete with output of size =>\>\"", ",", " ", 
       RowBox[{
        RowBox[{"Dimensions", "[", "tempCost", "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]", 
     "tempCost"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.662917119609961*^9, 3.662917126651082*^9}, {
  3.66291776834424*^9, 3.662917773744371*^9}, {3.66296247448674*^9, 
  3.662962482598524*^9}}],

Cell[TextData[{
 "\nnestPIV outputs a cost function C( ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Delta]", "L"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "L"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ") for a pivotal rotation based on the oldPIV C( ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Delta]", 
    RowBox[{"L", "-", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", 
    RowBox[{"L", "-", "1"}]], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ")  and the relevant Magic Cost C( ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Epsilon]", "L"], ",", " ", 
    SubscriptBox["W", "L"], " "}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 ")."
}], "Text",
 CellChangeTimes->{{3.662917043385227*^9, 3.662917170098997*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nextRound", "[", 
     RowBox[{"cost3_", ",", " ", "costk_", " ", ",", "costPIV_"}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "size3", ",", " ", "sizek", ",", " ", "sizePIV", ",", "n3", ",", "nk", 
        ",", "nPIV", ",", " ", "tempCost"}], "}"}], ",", 
      RowBox[{
       RowBox[{"tempCost", "=", "costk"}], ";", "\[IndentingNewLine]", 
       RowBox[{"size3", "=", 
        RowBox[{
         RowBox[{"Dimensions", "[", "cost3", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"sizek", "=", 
        RowBox[{
         RowBox[{"Dimensions", "[", "costk", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"sizePIV", "=", 
        RowBox[{
         RowBox[{"Dimensions", "[", "costPIV", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"n3", "=", "0"}], ",", 
         RowBox[{"n3", "<", "size3"}], ",", 
         RowBox[{
          RowBox[{"n3", "++"}], ";", "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"nk", "=", "0"}], ",", 
            RowBox[{"nk", "<", "sizek"}], ",", 
            RowBox[{
             RowBox[{"nk", "++"}], ";", "\[IndentingNewLine]", 
             RowBox[{"For", "[", 
              RowBox[{
               RowBox[{"nPIV", "=", "0"}], ",", 
               RowBox[{"nPIV", "<", "sizePIV"}], ",", 
               RowBox[{
                RowBox[{"nPIV", "++"}], ";", "\[IndentingNewLine]", 
                RowBox[{"tempCost", "=", 
                 RowBox[{"Append", "[", 
                  RowBox[{"tempCost", ",", " ", 
                   RowBox[{"MapMEKLbeyond", "[", 
                    RowBox[{
                    RowBox[{"cost3", "[", 
                    RowBox[{"[", "n3", "]"}], "]"}], ",", 
                    RowBox[{"costk", "[", 
                    RowBox[{"[", "nk", "]"}], "]"}], ",", 
                    RowBox[{"costPIV", "[", 
                    RowBox[{"[", "nPIV", "]"}], "]"}]}], "]"}]}], "]"}]}], 
                ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
           "\[IndentingNewLine]", "]"}], ";"}]}], "\[IndentingNewLine]", 
        "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"tempCost", "=", 
        RowBox[{"BestOf", "[", "tempCost", "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Print", "[", 
        RowBox[{"\"\<round complete with output of size =>\>\"", ",", " ", 
         RowBox[{
          RowBox[{"Dimensions", "[", "tempCost", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], ";", "\[IndentingNewLine]",
        "tempCost"}]}], "\[IndentingNewLine]", "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.662386363811894*^9, 3.6623865728481703`*^9}, {
   3.662386647649784*^9, 3.662386664131219*^9}, {3.662386713671486*^9, 
   3.662386769544829*^9}, {3.662386801224389*^9, 3.6623869117549562`*^9}, {
   3.662386955087051*^9, 3.662387111620942*^9}, {3.662396869160687*^9, 
   3.662397197756792*^9}, 3.662397323842331*^9, {3.6623973729407587`*^9, 
   3.66239738321279*^9}, {3.662397417599773*^9, 3.662397418525762*^9}, {
   3.662397588393413*^9, 3.6623975916959*^9}, {3.662397846009245*^9, 
   3.6623978530323057`*^9}, {3.6623979773739643`*^9, 3.662398016429817*^9}, {
   3.662398315755821*^9, 3.66239831647383*^9}, {3.6623984669910173`*^9, 
   3.662398468774432*^9}, {3.662398507353525*^9, 3.662398528312071*^9}, {
   3.6623985743986807`*^9, 3.662398582462669*^9}, {3.662398715710622*^9, 
   3.662398720604787*^9}, {3.6623987806721087`*^9, 3.662398780958891*^9}, {
   3.6623990188324003`*^9, 3.662399019441621*^9}, {3.6623990912961893`*^9, 
   3.662399116750786*^9}, {3.6624020710620527`*^9, 3.662402301001132*^9}, {
   3.662402371463423*^9, 3.662402403444933*^9}, {3.6624024490601063`*^9, 
   3.662402456177692*^9}, {3.662402489092328*^9, 3.662402566776778*^9}, {
   3.662402598055525*^9, 3.662402675721003*^9}, {3.662402767997409*^9, 
   3.662402769956048*^9}, {3.662448587344782*^9, 3.662448591823481*^9}, {
   3.662449589362069*^9, 3.662449594450115*^9}, {3.662449637427445*^9, 
   3.6624496376529417`*^9}, {3.662449676405007*^9, 3.6624497217656813`*^9}, {
   3.662449764868433*^9, 3.66244979256345*^9}, {3.6624500679782248`*^9, 
   3.6624500727287607`*^9}, {3.662451603293951*^9, 3.662451624972639*^9}, {
   3.6624519739770937`*^9, 3.66245197415215*^9}, {3.6624689798858356`*^9, 
   3.6624689948472557`*^9}, {3.662469171942265*^9, 3.662469172804428*^9}, {
   3.66248364796763*^9, 3.662483693010742*^9}, {3.662483728971691*^9, 
   3.662483758100994*^9}, {3.662483798553587*^9, 3.6624839165748367`*^9}, {
   3.662884425757235*^9, 3.662884538976795*^9}, {3.662885436097414*^9, 
   3.662885452609871*^9}, {3.662885568101264*^9, 3.6628856713364887`*^9}, {
   3.662885807245425*^9, 3.6628858104617968`*^9}, {3.6628860754978523`*^9, 
   3.6628860765678453`*^9}, {3.6629053488078337`*^9, 3.662905353639579*^9}, 
   3.662916984854537*^9, {3.662917036287458*^9, 3.662917040144978*^9}, {
   3.664804366723873*^9, 3.664804372116035*^9}}],

Cell[TextData[{
 "nextRound takes as input a list of many achieveable values of {\[Epsilon], \
C} for various magic states and then applies another round of distillation of \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox["MEK", "L"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " to obtain another such list.  nextRound is entirely brute force and \
searches through all possible combinations of different inputs.  This is a \
huge number of combinations so the function ends with BestOf to select just \
the most efficient elements of the list.\n"
}], "Text",
 CellChangeTimes->{{3.6623973664068813`*^9, 3.6623973671392508`*^9}, {
  3.662448926521435*^9, 3.66244903074893*^9}, {3.662449635971682*^9, 
  3.6624496782290173`*^9}, {3.664804378046235*^9, 3.664804508629861*^9}, {
  3.664804547000264*^9, 3.664804595016788*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"Filter", "[", "list_", "]"}], ":=", 
   RowBox[{"Select", "[", 
    RowBox[{"list", ",", " ", 
     RowBox[{
      RowBox[{
       SuperscriptBox["10", 
        RowBox[{"-", "20"}]], "<", 
       RowBox[{"#", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "<", 
       FractionBox["\[Epsilon]in", "2"]}], "&"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MakePlotList", "[", "TAB_", "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"temp", ",", " ", "sizeof", ",", "j", ",", " ", "temp2"}], "}"}],
     ",", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"temp2", "=", 
      RowBox[{"Filter", "[", "TAB", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"sizeof", "=", 
      RowBox[{
       RowBox[{"Dimensions", "[", "temp2", "]"}], "[", 
       RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"temp", "=", 
      RowBox[{"{", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{"-", 
          RowBox[{"Log", "[", 
           RowBox[{"10", ",", 
            RowBox[{"temp2", "[", 
             RowBox[{"[", 
              RowBox[{"1", ",", "1"}], "]"}], "]"}]}], "]"}]}], "    ", ",", 
         " ", 
         RowBox[{"temp2", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}]}], "}"}], "}"}]}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"For", "[", 
      RowBox[{
       RowBox[{"j", "=", "1"}], ",", 
       RowBox[{"j", "\[LessEqual]", " ", "sizeof"}], ",", 
       RowBox[{"j", "++"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"temp", "=", 
         RowBox[{"Append", "[", 
          RowBox[{"temp", ",", 
           RowBox[{"{", " ", 
            RowBox[{
             RowBox[{"-", 
              RowBox[{"Log", "[", 
               RowBox[{"10", ",", 
                RowBox[{"temp2", "[", 
                 RowBox[{"[", 
                  RowBox[{"j", ",", "1"}], "]"}], "]"}]}], "]"}]}], "    ", 
             ",", " ", 
             RowBox[{"temp2", "[", 
              RowBox[{"[", 
               RowBox[{"j", ",", "2"}], "]"}], "]"}]}], "}"}]}], " ", "]"}]}],
         ";"}]}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     "temp"}]}], "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{3.664804463621517*^9}],

Cell["\<\
The above functions are simply used to filter the data and convert the Cost \
into a Log( cost ) and is used before plotting.
\
\>", "Text",
 CellChangeTimes->{{3.664804465552087*^9, 3.664804469523738*^9}, {
  3.664804511461694*^9, 3.664804545848303*^9}, {3.6648046005369253`*^9, 
  3.664804657626993*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Many rounds\
\>", "Section",
 CellChangeTimes->{{3.662450706560916*^9, 3.6624507176537037`*^9}, 
   3.662884615702084*^9}],

Cell[CellGroupData[{

Cell["Construct COST menu for level=3 states", "Subsection",
 CellChangeTimes->{{3.661707500343193*^9, 3.661707531365097*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"nextRoundlev3", "[", "CostIn_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"Halfk", ",", "j", ",", "Level3Cost", ",", " ", "sizeof"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Level3Cost", "=", "CostIn"}], ";", "\[IndentingNewLine]", 
       RowBox[{"sizeof", "=", 
        RowBox[{
         RowBox[{"Dimensions", "[", "Level3Cost", "]"}], "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
       RowBox[{"For", "[", 
        RowBox[{
         RowBox[{"j", "=", "0"}], ",", 
         RowBox[{"j", "<", "sizeof"}], ",", 
         RowBox[{
          RowBox[{"j", "++"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Level3Cost", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"Level3Cost", ",", 
             RowBox[{"Map15", "[", 
              RowBox[{"Level3Cost", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"Level3Cost", "=", 
           RowBox[{"Append", "[", 
            RowBox[{"Level3Cost", ",", 
             RowBox[{"MapMEK", "[", 
              RowBox[{"Level3Cost", "[", 
               RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "]"}]}], ";", 
          "\[IndentingNewLine]", 
          RowBox[{"For", "[", 
           RowBox[{
            RowBox[{"Halfk", "=", "0"}], ",", 
            RowBox[{"Halfk", "<", " ", "100"}], ",", " ", 
            RowBox[{
             RowBox[{"Halfk", "++"}], ";", "\[IndentingNewLine]", 
             RowBox[{"Level3Cost", "=", 
              RowBox[{"Append", "[", 
               RowBox[{"Level3Cost", ",", " ", 
                RowBox[{"MapBH", "[", " ", 
                 RowBox[{
                  RowBox[{"Level3Cost", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], ",", 
                  RowBox[{"2", "*", "Halfk"}]}], "  ", "]"}]}], "]"}]}], 
             ";"}]}], "]"}], ";", "\[IndentingNewLine]", 
          RowBox[{"Level3Cost", "=", 
           RowBox[{"Delete", "[", 
            RowBox[{"Level3Cost", ",", "j"}], "]"}]}], ";"}]}], 
        "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
       RowBox[{"BestOf", "[", "Level3Cost", "]"}]}]}], "\[IndentingNewLine]", 
     "]"}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.662387305010552*^9, 3.662387468223053*^9}, {
  3.662397643186307*^9, 3.662397643274458*^9}, {3.662452379235581*^9, 
  3.662452386002131*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Level3Cost", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level3Cost", "=", 
   RowBox[{"nextRoundlev3", "[", "Level3Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level3Cost", "=", 
   RowBox[{"nextRoundlev3", "[", "Level3Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level3Cost", "=", 
   RowBox[{"nextRoundlev3", "[", "Level3Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level3Cost", "=", 
   RowBox[{"nextRoundlev3", "[", "Level3Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level3Cost", "=", 
   RowBox[{"nextRoundlev3", "[", "Level3Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"L3", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"Level3Cost", ",", 
    RowBox[{"Ticks", "\[Rule]", "Automatic"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"Min", "[", "Level3Cost", "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.662387476848092*^9, 3.662387529761168*^9}, {
   3.662397621481339*^9, 3.662397623528062*^9}, {3.6623976557447987`*^9, 
   3.6623976838035707`*^9}, {3.662397743898571*^9, 3.662397753091886*^9}, {
   3.662397783724814*^9, 3.662397783964698*^9}, {3.662400403691512*^9, 
   3.662400404194256*^9}, {3.662452471861372*^9, 3.662452472134359*^9}, 
   3.6628855092743473`*^9, {3.662904563769829*^9, 3.66290457724158*^9}, {
   3.66290516227244*^9, 3.662905177439207*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.662387508350244*^9, 3.662387549595599*^9}, 
   3.662397205388653*^9, 3.662397286655964*^9, 3.6623974019220953`*^9, 
   3.662397449329625*^9, {3.6623976126863403`*^9, 3.6623976643383512`*^9}, 
   3.662397699434321*^9, {3.662397734680503*^9, 3.662397753777904*^9}, 
   3.662397784510913*^9, 3.66239787632343*^9, 3.662397925510002*^9, 
   3.662398024817506*^9, 3.6623984226510572`*^9, {3.662400111091754*^9, 
   3.662400128396394*^9}, 3.662400405909412*^9, 3.662400747092042*^9, 
   3.662451127054558*^9, 3.662451629012904*^9, 3.662451979156413*^9, 
   3.662452190888983*^9, 3.662452388377079*^9, {3.6624524794112873`*^9, 
   3.662452490614787*^9}, 3.6624657791931257`*^9, 3.662467476123548*^9, 
   3.662468997087529*^9, 3.662473065682745*^9, 3.662483935427387*^9, 
   3.662484273581839*^9, 3.662883196365159*^9, 3.6628832436476*^9, 
   3.662883294535439*^9, 3.662884304978313*^9, 3.662884544227523*^9, 
   3.662885401328562*^9, {3.662885463001829*^9, 3.662885542348024*^9}, 
   3.662885683805665*^9, 3.6628857194801693`*^9, {3.662885813778078*^9, 
   3.662885829422771*^9}, 3.662885939357586*^9, 3.662886081058393*^9, {
   3.662904539087038*^9, 3.662904607124255*^9}, 3.66290478930972*^9, {
   3.662904896525672*^9, 3.662904925864975*^9}, {3.662905163611404*^9, 
   3.662905178612*^9}, 3.6629052726247597`*^9, 3.6629053178111963`*^9, 
   3.662905355533518*^9, {3.662905394188817*^9, 3.662905403073286*^9}, 
   3.662905485186356*^9, 3.662916910036695*^9, 3.6629174834126167`*^9, 
   3.6629177769666862`*^9, 3.666519486575034*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.012833333333333334`],
      AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBQQK+/SFib1JlAgAAACMAAAACAAAAFVW1u7FrEsAAAAAAAAAAAIqpwdQ0
hBfAfxSxrtIr+z+DVEAQm9EcwMluStXNrwBAqdcCv4h1JMAIPITJwd4GQDz0
RTELAyXAHuOM5bShCECwCRBfAIEnwLTuTc1pngpAKIQk/UptLcBq0kMGN9QQ
QOp/sRuh9S3AAKb58TzVEEDocF3Oxx4wwDXhM88B9hBA9/v93IlmMcAQwDhi
jYQRQIGQIBuH0DLArys5sjLBEkBrxHLEQIs3wLZw6gnTcRRAA1PCdWktOMAd
PDTXnH0UQG6XrkouXjnARJ61ARC2FEBqf1a28Ho6wNEyRUJ9vxRASKu6lL3m
PMDDaakmP5oVQCj8I5RV7z3Ahy7J7DXkFUC4e4BRByM/wF0XIfiyUBZA2U+H
u1O2QMBaGxVvVZsXQL8LTjLuAUPAOOkI7LjcGEDmR93RcNlDwGEVvbE27hhA
aUSWtMa8RsCcoqJnWCgZQD5zBGPTBkfAp2leoOAyGUAY/0cgbZtHwPAFV8pk
PhlAXhT33tVxSMBsUCqD6GMZQBSLaj/pwkjAzh3ElclvGUAS3YLmSltJwIba
MRJPqBlAoL3KHeGASsB5wSsoUEEaQEmmgJ5yDkvAKHSXfmIpG0DxguOBVKZL
wGdURHGcTxtAPZ0TEcgMTcAzPFoM9r0bQHLhhnHbXU3AosX4HtfJG0CwC58Y
PfZNwIc8aptcAhxAmKIyVUCITsBG+JbKdaIcQMjhvEtCfE/ATV+1+0QRHUBV
7/xf
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-65.28708092654735, -0.5274337291448792},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{-64.28266429690815, 0}, {-0.40371470625904327`, 
    7.266864712662778}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{-59.86721241784519, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "26"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-48.35428695287496, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "21"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-36.841361487904734`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "16"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-64.47238260383328, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-62.16979751083923, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-57.564627324851145`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55.262042231857095`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-52.95945713886305, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50.65687204586901, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-46.051701859880914`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-43.74911676688687, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-41.44653167389282, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-39.14394658089878, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34.538776394910684`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32.23619130191664, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-29.933606208922594`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20.72326583694641, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16.11809565095832, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-9.210340371976182, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.305650551780507, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.392661928770137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{
  3.662905178625457*^9, 3.66290527266017*^9, 3.662905317827814*^9, 
   3.662905355546762*^9, {3.662905394202033*^9, 3.662905403091675*^9}, 
   3.6629054853442574`*^9, 3.6629169100613623`*^9, 3.662917483448966*^9, 
   3.662917776981243*^9, 3.666519486611485*^9}],

Cell[BoxData["4.\
488907775454651604244394582624565596415934499169621245923646276342827527682512\
58483400206423669832736731473`71.91881743465045*^-28"], "Output",
 CellChangeTimes->{
  3.662905178625457*^9, 3.66290527266017*^9, 3.662905317827814*^9, 
   3.662905355546762*^9, {3.662905394202033*^9, 3.662905403091675*^9}, 
   3.6629054853442574`*^9, 3.6629169100613623`*^9, 3.662917483448966*^9, 
   3.662917776981243*^9, 3.666519486702744*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Construct COST menu for level=4 states
\
\>", "Subsection",
 CellChangeTimes->{{3.661711587191434*^9, 3.661711603872994*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MapMEKLbeyond", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]in", ",", "1"}], "}"}]}], "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.0034960419802693898901386291962889555608281325150131475987120141646725605\
71850938734711161965336656670925898856076635023816750193321863`99.\
77461202444809", ",", 
   "6.103090740022315908358937253144363155915976222557797400169641670231190368\
481789891671486740333537635218741141516439809683890631367490805`100.\
89879283950836"}], "}"}]], "Output",
 CellChangeTimes->{{3.66290538324613*^9, 3.662905403247047*^9}, 
   3.662905485797127*^9, 3.662916910198474*^9, 3.662917483660033*^9, 
   3.662917777099806*^9, 3.666519486913632*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Level4Cost", "=", 
     RowBox[{"{", 
      RowBox[{"MapMEKLbeyond", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"\[Epsilon]in", ",", "1"}], "}"}]}], "]"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Level4Cost", "=", 
     RowBox[{"nextRound", "[", 
      RowBox[{"Level3Cost", ",", " ", "Level4Cost", " ", ",", "Level3Cost"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Level4Cost", "=", 
     RowBox[{"nextRound", "[", 
      RowBox[{"Level3Cost", ",", " ", "Level4Cost", " ", ",", "Level3Cost"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Level4Cost", "=", 
     RowBox[{"nextRound", "[", 
      RowBox[{"Level3Cost", ",", " ", "Level4Cost", " ", ",", "Level3Cost"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Level4Cost", "=", 
     RowBox[{"nextRound", "[", 
      RowBox[{"Level3Cost", ",", " ", "Level4Cost", " ", ",", "Level3Cost"}], 
      "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"L4", "=", 
    RowBox[{"ListLogLogPlot", "[", 
     RowBox[{"Level4Cost", ",", " ", 
      RowBox[{"PlotStyle", " ", "\[Rule]", " ", "Red"}]}], "]"}]}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.662397217398282*^9, 3.6623972995306587`*^9}, {
   3.662397332720151*^9, 3.662397333209662*^9}, {3.662397466240543*^9, 
   3.662397468703415*^9}, {3.662397807452282*^9, 3.662397831381997*^9}, {
   3.662398083748941*^9, 3.662398084030004*^9}, 3.6629053003089123`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["round complete with output of size =>", 6],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.662397876487073*^9, 3.662397925682466*^9, {3.662398077483645*^9, 
   3.662398084518381*^9}, 3.6623984228012037`*^9, {3.66240011129639*^9, 
   3.662400128726076*^9}, 3.662400406254058*^9, 3.662400747261682*^9, 
   3.6624511272070923`*^9, 3.662451629159545*^9, 3.662451979491778*^9, 
   3.662452191042004*^9, 3.66245238872331*^9, 3.662452490977766*^9, 
   3.662465779389846*^9, 3.662467476343588*^9, 3.6624689972772207`*^9, 
   3.662473066368937*^9, 3.662483935731765*^9, 3.662484273924054*^9, 
   3.662883196598034*^9, 3.6628832438492126`*^9, 3.662883294853993*^9, 
   3.662884305341589*^9, 3.662884544534809*^9, 3.662885401386598*^9, {
   3.662885463315645*^9, 3.6628854929959707`*^9}, 3.662885542659252*^9, 
   3.662885684047463*^9, 3.662885719792223*^9, {3.662885814000238*^9, 
   3.66288582964555*^9}, 3.662885939538961*^9, 3.662886081368602*^9, 
   3.6629045394494333`*^9, 3.662904607344851*^9, 3.662904789675318*^9, {
   3.6629048968732357`*^9, 3.66290492608707*^9}, 3.6629052730693274`*^9, {
   3.662905318073224*^9, 3.662905403436615*^9}, 3.6629054859861383`*^9, 
   3.662916910378536*^9, 3.662917483838587*^9, 3.662917777286645*^9, 
   3.666519487098188*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "15"}],
  SequenceForm["round complete with output of size =>", 15],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.662397876487073*^9, 3.662397925682466*^9, {3.662398077483645*^9, 
   3.662398084518381*^9}, 3.6623984228012037`*^9, {3.66240011129639*^9, 
   3.662400128726076*^9}, 3.662400406254058*^9, 3.662400747261682*^9, 
   3.6624511272070923`*^9, 3.662451629159545*^9, 3.662451979491778*^9, 
   3.662452191042004*^9, 3.66245238872331*^9, 3.662452490977766*^9, 
   3.662465779389846*^9, 3.662467476343588*^9, 3.6624689972772207`*^9, 
   3.662473066368937*^9, 3.662483935731765*^9, 3.662484273924054*^9, 
   3.662883196598034*^9, 3.6628832438492126`*^9, 3.662883294853993*^9, 
   3.662884305341589*^9, 3.662884544534809*^9, 3.662885401386598*^9, {
   3.662885463315645*^9, 3.6628854929959707`*^9}, 3.662885542659252*^9, 
   3.662885684047463*^9, 3.662885719792223*^9, {3.662885814000238*^9, 
   3.66288582964555*^9}, 3.662885939538961*^9, 3.662886081368602*^9, 
   3.6629045394494333`*^9, 3.662904607344851*^9, 3.662904789675318*^9, {
   3.6629048968732357`*^9, 3.66290492608707*^9}, 3.6629052730693274`*^9, {
   3.662905318073224*^9, 3.662905403436615*^9}, 3.6629054859861383`*^9, 
   3.662916910378536*^9, 3.662917483838587*^9, 3.662917777286645*^9, 
   3.666519488367374*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "31"}],
  SequenceForm["round complete with output of size =>", 31],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.662397876487073*^9, 3.662397925682466*^9, {3.662398077483645*^9, 
   3.662398084518381*^9}, 3.6623984228012037`*^9, {3.66240011129639*^9, 
   3.662400128726076*^9}, 3.662400406254058*^9, 3.662400747261682*^9, 
   3.6624511272070923`*^9, 3.662451629159545*^9, 3.662451979491778*^9, 
   3.662452191042004*^9, 3.66245238872331*^9, 3.662452490977766*^9, 
   3.662465779389846*^9, 3.662467476343588*^9, 3.6624689972772207`*^9, 
   3.662473066368937*^9, 3.662483935731765*^9, 3.662484273924054*^9, 
   3.662883196598034*^9, 3.6628832438492126`*^9, 3.662883294853993*^9, 
   3.662884305341589*^9, 3.662884544534809*^9, 3.662885401386598*^9, {
   3.662885463315645*^9, 3.6628854929959707`*^9}, 3.662885542659252*^9, 
   3.662885684047463*^9, 3.662885719792223*^9, {3.662885814000238*^9, 
   3.66288582964555*^9}, 3.662885939538961*^9, 3.662886081368602*^9, 
   3.6629045394494333`*^9, 3.662904607344851*^9, 3.662904789675318*^9, {
   3.6629048968732357`*^9, 3.66290492608707*^9}, 3.6629052730693274`*^9, {
   3.662905318073224*^9, 3.662905403436615*^9}, 3.6629054859861383`*^9, 
   3.662916910378536*^9, 3.662917483838587*^9, 3.662917777286645*^9, 
   3.666519493153659*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "48"}],
  SequenceForm["round complete with output of size =>", 48],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.662397876487073*^9, 3.662397925682466*^9, {3.662398077483645*^9, 
   3.662398084518381*^9}, 3.6623984228012037`*^9, {3.66240011129639*^9, 
   3.662400128726076*^9}, 3.662400406254058*^9, 3.662400747261682*^9, 
   3.6624511272070923`*^9, 3.662451629159545*^9, 3.662451979491778*^9, 
   3.662452191042004*^9, 3.66245238872331*^9, 3.662452490977766*^9, 
   3.662465779389846*^9, 3.662467476343588*^9, 3.6624689972772207`*^9, 
   3.662473066368937*^9, 3.662483935731765*^9, 3.662484273924054*^9, 
   3.662883196598034*^9, 3.6628832438492126`*^9, 3.662883294853993*^9, 
   3.662884305341589*^9, 3.662884544534809*^9, 3.662885401386598*^9, {
   3.662885463315645*^9, 3.6628854929959707`*^9}, 3.662885542659252*^9, 
   3.662885684047463*^9, 3.662885719792223*^9, {3.662885814000238*^9, 
   3.66288582964555*^9}, 3.662885939538961*^9, 3.662886081368602*^9, 
   3.6629045394494333`*^9, 3.662904607344851*^9, 3.662904789675318*^9, {
   3.6629048968732357`*^9, 3.66290492608707*^9}, 3.6629052730693274`*^9, {
   3.662905318073224*^9, 3.662905403436615*^9}, 3.6629054859861383`*^9, 
   3.662916910378536*^9, 3.662917483838587*^9, 3.662917777286645*^9, 
   3.666519510422209*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.662397910187883*^9, 3.662397954415024*^9, {3.662398078342661*^9, 
   3.662398087912904*^9}, 3.662398435998835*^9, 3.662400113836334*^9, 
   3.662400146241377*^9, 3.6624004208954268`*^9, 3.662400750850192*^9, 
   3.6624511404873667`*^9, 3.662451641911355*^9, 3.662451993845223*^9, 
   3.662452197461055*^9, 3.662452410596936*^9, 3.6624525183685007`*^9, 
   3.66246581136357*^9, 3.662467485307063*^9, 3.662469006273143*^9, 
   3.662473076320805*^9, 3.6624839449882727`*^9, 3.662484283703525*^9, 
   3.662883196761009*^9, 3.6628832452946997`*^9, 3.662883314986451*^9, 
   3.662884307405293*^9, 3.662884567432396*^9, 3.662885403485387*^9, {
   3.662885465394333*^9, 3.66288549523107*^9}, 3.6628855447497587`*^9, {
   3.662885700301159*^9, 3.662885721859799*^9}, {3.662885824455331*^9, 
   3.662885852893127*^9}, 3.662885941549037*^9, 3.662886105440984*^9, 
   3.66290456407577*^9, 3.6629046309280024`*^9, 3.662904814035028*^9, {
   3.6629049206307707`*^9, 3.662904950076811*^9}, 3.662905273250407*^9, {
   3.662905318321506*^9, 3.6629054288034*^9}, 3.6629055105020742`*^9, 
   3.662916933224161*^9, 3.662917512547117*^9, 3.662917801138349*^9, 
   3.666519510482194*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.012833333333333334`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJwBEQPu/CFib1JlAgAAADAAAAACAAAAFVW1u7FrEsAAAAAAAAAAAKUHZ8cH
ohnAwnre9MYqAUD1y45mvd0bwJ40lA+AvgVA13R5bu1LIcANS9vFOfULQEjg
/uc9wCLAmhfT82UNDUAcOfUBZSAlwEvODGve6A5AjMrMVMI0J8A5YAjjIQsQ
QO3TniwhhSnAkh3z/QBiEkCH2qTBNawrwEmxrPX9GxNA2QmDaP+EL8ARV+fi
X6kTQJQcc+T4hzDAQPOhU86xE0B1l2cL1IUxwIRJM0am+RNAybuQs+CZMsB/
Y4SXfvcUQFW8x6UCrTPAMbDqHEJ0FUAh2ld5Uz41wHwBzzFaFBZA5kWfwVAH
N8AcA5d6kQgYQJjwqefvbjjAhrC/v2hxGEBCmzPKkVg5wJ6b0yzAgBhAInha
UsuBOsAmeWcnaKsYQGTvZG5JvzvAIbY/K/viGEBFbfgermY9wMApfq1rDRlA
rdm0yKAFPsBVNGar1jgZQDM6L9h1pT/AF+avvJqDGUCoyKJavUJAwEO7Ckih
5xlA46kDV+/+QMCctUijcY8aQLLlwaVTSEHAsM4hTublGkCBfC26XoxCwBg4
Zv2fBRxAnXTHrjNXQ8BNhJTuHRwcQL2sZTXOl0PACUg8pQYgHEC6B/suO21E
wMLn4P4ERRxAVA9tDXI1RcBeAyWr6lEcQCZlmLNDUEbAhPd+Yi/RHEAu/Xcv
laZGwNg8yB4E1xxAC951HoMPR8BhbQfo3/scQFK3NtgZ0EfA/d1C4UYXHUB6
3a/1/DNIwAaGU96KIB1AVQVnXI7BSMAjDw/XwCcdQCHCSb5kYUnAUnFk5u9j
HUAN155vIwVKwB0drEfovR1Av/2f46n1SsDjM2udNNsdQNuQqDXhEkvAWQQ9
k6PnHUDW9s4FWq5LwKX7GhPvIx5A+d51staoTMDIVn0E+GIeQEH08vdhzEzA
WVQpLYBzHkAzdvxMql1NwJWLJJcbpR5AFGslgtTzTcBDyyGmneMeQHPRBs3y
ik7AdnzaT/F1H0DLFA46PiVPwDEjzn8srx9AB8lhOw==
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-64.58226315464476, -0.5749162394970442},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{-63.58868987534254, 0}, {-0.4400593438125522, 
    7.921068188625939}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{-59.86721241784519, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "26"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-48.35428695287496, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "21"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-36.841361487904734`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "16"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-64.47238260383328, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-62.16979751083923, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-57.564627324851145`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55.262042231857095`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-52.95945713886305, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50.65687204586901, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-46.051701859880914`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-43.74911676688687, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-41.44653167389282, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-39.14394658089878, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34.538776394910684`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32.23619130191664, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-29.933606208922594`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20.72326583694641, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16.11809565095832, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-9.210340371976182, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox["500", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.903487552536127, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.308952660644293`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.596634733096073`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.819778284410283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{{3.66239782643371*^9, 3.6623978561663322`*^9}, 
   3.6623979099668827`*^9, 3.6623979541976967`*^9, {3.6623980784718227`*^9, 
   3.6623980880450487`*^9}, 3.662398436123259*^9, 3.662400113850987*^9, 
   3.662400146331078*^9, 3.6624004209219847`*^9, 3.662400750869151*^9, 
   3.662451140502393*^9, 3.662451641925243*^9, 3.662451993873966*^9, 
   3.662452197582479*^9, 3.662452410613428*^9, 3.6624525183895617`*^9, 
   3.662465811378907*^9, 3.662467485324683*^9, 3.662469006289208*^9, 
   3.6624730763431807`*^9, 3.6624839450061607`*^9, 3.6624842837209253`*^9, 
   3.662883196774786*^9, 3.662883245309402*^9, 3.6628833151112127`*^9, 
   3.662884307418562*^9, 3.662884567446616*^9, 3.662885403497447*^9, {
   3.66288546541356*^9, 3.662885495234861*^9}, 3.662885544764758*^9, {
   3.662885700244618*^9, 3.662885721887251*^9}, {3.662885824403949*^9, 
   3.662885852907195*^9}, 3.662885941583346*^9, 3.662886105577456*^9, 
   3.662904564089974*^9, 3.662904630943283*^9, 3.662904814049159*^9, {
   3.662904920646041*^9, 3.662904950091329*^9}, 3.662905273278091*^9, {
   3.662905318335557*^9, 3.6629054288187447`*^9}, 3.662905510637841*^9, 
   3.662916933239923*^9, 3.662917512573299*^9, 3.662917801157011*^9, 
   3.666519510616696*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.662885705272997*^9, 3.662885705284906*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.6621443471229277`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Construct COST for level=5 states", "Subsection",
 CellChangeTimes->{{3.661711587191434*^9, 3.661711603872994*^9}, {
   3.6617562169407597`*^9, 3.661756217116431*^9}, 3.661756430533242*^9, {
   3.662905438551469*^9, 3.662905439415553*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Level5PIV", "=", 
   RowBox[{"nextPIV", "[", 
    RowBox[{"Level3Cost", ",", "Level4Cost"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.662399108068822*^9, {3.662400314201562*^9, 3.6624003445916643`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Pivotal compile complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "48"}],
  SequenceForm["Pivotal compile complete with output of size =>", 48],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6623987364950333`*^9, 3.662398787238428*^9, 3.662398928363042*^9, 
   3.662399029320973*^9, {3.662399105479185*^9, 3.662399123110938*^9}, 
   3.662400114157095*^9, 3.662400148115735*^9, 3.662400421257852*^9, 
   3.6624007510608063`*^9, 3.6624511406588583`*^9, 3.6624516420743237`*^9, 
   3.662451994037242*^9, 3.662452197757688*^9, 3.662452410767535*^9, 
   3.662452518542458*^9, 3.662465811552243*^9, 3.662467485506879*^9, 
   3.662469006465041*^9, 3.662473076891716*^9, 3.662483945326017*^9, 
   3.6624842840195723`*^9, 3.6628831970664463`*^9, 3.662883245674656*^9, 
   3.6628833153068037`*^9, 3.6628843076983147`*^9, 3.662884567673324*^9, 
   3.662885403682294*^9, {3.662885465571932*^9, 3.662885495429439*^9}, 
   3.6628855449226503`*^9, 3.662885853243375*^9, 3.662885941800199*^9, 
   3.6628861058178663`*^9, 3.6629045643393993`*^9, 3.6629046310629396`*^9, 
   3.662904814176593*^9, {3.662904920779004*^9, 3.662904950219256*^9}, 
   3.6629052734044743`*^9, 3.6629053184598637`*^9, 3.662905356368555*^9, 
   3.6629054290262213`*^9, 3.6629055109634132`*^9, 3.6629169334956837`*^9, 
   3.662917512740905*^9, 3.662917801400037*^9, 3.666519510952353*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Level5Cost", "=", 
   RowBox[{"{", 
    RowBox[{"MapMEKLbeyond", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}]}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level5Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level5Cost", " ", ",", "Level5PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level5Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level5Cost", " ", ",", "Level5PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level5Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level5Cost", " ", ",", "Level5PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level5Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level5Cost", " ", ",", "Level5PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"L5", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"Level5Cost", ",", " ", 
    RowBox[{"PlotStyle", "\[Rule]", "Purple"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6623981336000853`*^9, 3.662398300176219*^9}, 
   3.6623983535481167`*^9, {3.662398392412941*^9, 3.662398396723207*^9}, 
   3.662398480152388*^9, {3.6623986842178802`*^9, 3.662398684376505*^9}, 
   3.662905306599724*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["round complete with output of size =>", 6],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, 3.662400152094133*^9, 
   3.662400421407154*^9, 3.6624007511263447`*^9, 3.6624511407391443`*^9, 
   3.662451642151309*^9, 3.662451994118535*^9, 3.6624521978141727`*^9, 
   3.662452410848428*^9, 3.6624525186272497`*^9, 3.6624658116551723`*^9, 
   3.662467485592319*^9, 3.662469006552741*^9, 3.6624730770181227`*^9, 
   3.662483945418129*^9, 3.6624842841096783`*^9, 3.662883197091028*^9, 
   3.66288324569842*^9, 3.662883315556038*^9, 3.662884307777479*^9, 
   3.662884567869019*^9, 3.662885403757049*^9, {3.662885465641315*^9, 
   3.662885495498415*^9}, 3.662885544990987*^9, 3.662885853492854*^9, 
   3.662885941867416*^9, 3.662886106081102*^9, 3.66290456459832*^9, 
   3.6629046313292522`*^9, 3.6629048145074472`*^9, {3.66290492107194*^9, 
   3.6629049504732857`*^9}, 3.662905273424262*^9, 3.6629053184790497`*^9, 
   3.6629053563892803`*^9, 3.6629054292741737`*^9, 3.662905511225603*^9, 
   3.6629169337540207`*^9, 3.6629175127746563`*^9, 3.662917801660016*^9, 
   3.66651951120026*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "15"}],
  SequenceForm["round complete with output of size =>", 15],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, 3.662400152094133*^9, 
   3.662400421407154*^9, 3.6624007511263447`*^9, 3.6624511407391443`*^9, 
   3.662451642151309*^9, 3.662451994118535*^9, 3.6624521978141727`*^9, 
   3.662452410848428*^9, 3.6624525186272497`*^9, 3.6624658116551723`*^9, 
   3.662467485592319*^9, 3.662469006552741*^9, 3.6624730770181227`*^9, 
   3.662483945418129*^9, 3.6624842841096783`*^9, 3.662883197091028*^9, 
   3.66288324569842*^9, 3.662883315556038*^9, 3.662884307777479*^9, 
   3.662884567869019*^9, 3.662885403757049*^9, {3.662885465641315*^9, 
   3.662885495498415*^9}, 3.662885544990987*^9, 3.662885853492854*^9, 
   3.662885941867416*^9, 3.662886106081102*^9, 3.66290456459832*^9, 
   3.6629046313292522`*^9, 3.6629048145074472`*^9, {3.66290492107194*^9, 
   3.6629049504732857`*^9}, 3.662905273424262*^9, 3.6629053184790497`*^9, 
   3.6629053563892803`*^9, 3.6629054292741737`*^9, 3.662905511225603*^9, 
   3.6629169337540207`*^9, 3.6629175127746563`*^9, 3.662917801660016*^9, 
   3.666519513067967*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "33"}],
  SequenceForm["round complete with output of size =>", 33],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, 3.662400152094133*^9, 
   3.662400421407154*^9, 3.6624007511263447`*^9, 3.6624511407391443`*^9, 
   3.662451642151309*^9, 3.662451994118535*^9, 3.6624521978141727`*^9, 
   3.662452410848428*^9, 3.6624525186272497`*^9, 3.6624658116551723`*^9, 
   3.662467485592319*^9, 3.662469006552741*^9, 3.6624730770181227`*^9, 
   3.662483945418129*^9, 3.6624842841096783`*^9, 3.662883197091028*^9, 
   3.66288324569842*^9, 3.662883315556038*^9, 3.662884307777479*^9, 
   3.662884567869019*^9, 3.662885403757049*^9, {3.662885465641315*^9, 
   3.662885495498415*^9}, 3.662885544990987*^9, 3.662885853492854*^9, 
   3.662885941867416*^9, 3.662886106081102*^9, 3.66290456459832*^9, 
   3.6629046313292522`*^9, 3.6629048145074472`*^9, {3.66290492107194*^9, 
   3.6629049504732857`*^9}, 3.662905273424262*^9, 3.6629053184790497`*^9, 
   3.6629053563892803`*^9, 3.6629054292741737`*^9, 3.662905511225603*^9, 
   3.6629169337540207`*^9, 3.6629175127746563`*^9, 3.662917801660016*^9, 
   3.666519520826276*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "51"}],
  SequenceForm["round complete with output of size =>", 51],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, 3.662400152094133*^9, 
   3.662400421407154*^9, 3.6624007511263447`*^9, 3.6624511407391443`*^9, 
   3.662451642151309*^9, 3.662451994118535*^9, 3.6624521978141727`*^9, 
   3.662452410848428*^9, 3.6624525186272497`*^9, 3.6624658116551723`*^9, 
   3.662467485592319*^9, 3.662469006552741*^9, 3.6624730770181227`*^9, 
   3.662483945418129*^9, 3.6624842841096783`*^9, 3.662883197091028*^9, 
   3.66288324569842*^9, 3.662883315556038*^9, 3.662884307777479*^9, 
   3.662884567869019*^9, 3.662885403757049*^9, {3.662885465641315*^9, 
   3.662885495498415*^9}, 3.662885544990987*^9, 3.662885853492854*^9, 
   3.662885941867416*^9, 3.662886106081102*^9, 3.66290456459832*^9, 
   3.6629046313292522`*^9, 3.6629048145074472`*^9, {3.66290492107194*^9, 
   3.6629049504732857`*^9}, 3.662905273424262*^9, 3.6629053184790497`*^9, 
   3.6629053563892803`*^9, 3.6629054292741737`*^9, 3.662905511225603*^9, 
   3.6629169337540207`*^9, 3.6629175127746563`*^9, 3.662917801660016*^9, 
   3.6665195605334*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6624843033318663`*^9, 3.66288319718941*^9, 
  3.662883245785565*^9, 3.662883352041506*^9, 3.6628843155748463`*^9, 
  3.662884596587152*^9, 3.662885408376499*^9, 3.662885471192094*^9, 
  3.662885501218482*^9, 3.662885550583144*^9, 3.66288586259509*^9, 
  3.662885947436*^9, 3.6628861572638693`*^9, 3.662904566706752*^9, 
  3.6629046805841217`*^9, 3.662904864867754*^9, 3.662904922019286*^9, 
  3.662905002249321*^9, 3.662905273494939*^9, 3.662905318560199*^9, 
  3.6629053564597816`*^9, 3.662905470444829*^9, 3.662905559820528*^9, 
  3.662916980959958*^9, 3.6629175129569407`*^9, 3.662917849282435*^9, 
  3.666519560589381*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.5, 0, 0.5], PointSize[0.011000000000000001`], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAFVW1u7FrEsAAAAAAAAAAALHGAhDf
exnA5US9KgC5A0AENI/mDrMbwJncgsN0zgpADU2SOXHiIMBTcs4xQo4OQABE
MMsfnSLA4wR7Y0tXEECS5D3G1EAlwBJT2vFl/hBAza4GKD0VJ8DJFTWLmfYR
QOczqMVnWSnAyqgx6Fv+E0DYpEexGAMswCD6fGC8zxRA5qdK8/UALsCUkPwn
nhYVQJ/UkO1iYTDAaDbsZbBGFUAmdTrH6UkxwJtgE+AJuhVAkb9ShMWiMsD6
RhHYzJIWQA5iIsCZwDPAQtTvAfMDF0DRKD+T/wM1wEJ/GWjznhdABqz0py4a
NsDudVJqEwwZQN082LHZEDfAJChcXUnNGUAOdaZdY7c4wNn72tRnIBpAtdCh
78plOcCLGIXDWlEaQFK7YWYXoDrAIybzGV5wGkC0L5O7td07wKORrO6alBpA
6Kk42dwDPcDZptFvl7AaQKg7FtUy8j3AQmF+07XvGkCN7d87Uys/wOhyeX6j
GxtA2Zun0ncmQMAc9BFe3HsbQHCMNl9TxkDAWrk2gcYhHEAakRG+jFdBwLmu
J5dNcRxA/Kr71N7ZQcAY8bKWADgdQPnruqShe0LAPHVoswGRHUBtEoRm0ARD
wJbWvLqfpR1AGiGY7lqaQ8Do/ROLW7QdQLemsNqfLUTAlqS/8YjWHUD8WQ/9
AuxEwArdJS8P5x1AoFobU/6QRcCLwDbccz4eQK5jsuZU5UXArAx1+HdpHkCM
BA5vqXpGwKY1i/fXnh5Ax6XKM/AZR8DF/82xGMweQBeCEWtmqEfA3Vg8uDne
HkA8xB0E5nRIwFjsfU4g7B5A9UgZxaDkSMCeugnS7gYfQEGNdYI2W0nAa1nz
B6ZGH0Bg9HrPuudJwF1Ql96ubh9AWMJzMRJ7SsDRpsrg9JMfQG3dKYIyHEvA
xqcUayKmH0BlzC5XeaxLwJlwVVHC2h9ATJ7/jP+BTMBKKlWSUAMgQCUQyLLv
EU3AQEStOaEcIED7fsNjrIRNwIV3CgXdLSBAcN2jGhXyTcCYuKfpo1MgQGsV
WvEpmk7AAEW4MV6LIEBtO7m+pzhPwL1Lkp1TpiBAvn172g==
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-64.73949936895897, -0.6042234691264201},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{-63.74350707097498, 0}, {-0.46249203809676603`, 
    8.324856685741787}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{-59.86721241784519, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "26"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-48.35428695287496, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "21"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-36.841361487904734`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "16"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-64.47238260383328, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-62.16979751083923, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-57.564627324851145`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55.262042231857095`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-52.95945713886305, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50.65687204586901, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-46.051701859880914`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-43.74911676688687, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-41.44653167389282, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-39.14394658089878, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34.538776394910684`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32.23619130191664, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-29.933606208922594`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20.72326583694641, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16.11809565095832, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-9.210340371976182, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.903487552536127, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.308952660644293`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{3.66248430334956*^9, 3.662883197201543*^9, 
  3.6628832458006687`*^9, 3.662883352055347*^9, 3.6628843155878773`*^9, 
  3.662884596600469*^9, 3.662885408389957*^9, 3.662885471214019*^9, 
  3.662885501230872*^9, 3.662885550595645*^9, 3.6628858623751287`*^9, 
  3.662885947449086*^9, 3.662886157289958*^9, 3.662904566384149*^9, 
  3.6629046806230164`*^9, 3.662904864880806*^9, 3.662904921676722*^9, 
  3.662905002281643*^9, 3.662905273507512*^9, 3.66290531868994*^9, 
  3.6629053564727077`*^9, 3.662905470392845*^9, 3.662905559833584*^9, 
  3.662916980976439*^9, 3.6629175129927177`*^9, 3.662917849418288*^9, 
  3.666519560714905*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Construct COST for level=6 states", "Subsection",
 CellChangeTimes->{{3.661711587191434*^9, 3.661711603872994*^9}, {
   3.6617562169407597`*^9, 3.661756217116431*^9}, 3.661756430533242*^9, {
   3.6624001669992*^9, 3.66240016725849*^9}, {3.662905435928308*^9, 
   3.662905436679637*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Level6PIV", "=", 
   RowBox[{"nextPIV", "[", " ", 
    RowBox[{"Level5PIV", ",", "Level5Cost"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.662399108068822*^9, {3.662400169883463*^9, 3.662400180901896*^9}, {
   3.662400358544779*^9, 3.662400365144368*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Pivotal compile complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "50"}],
  SequenceForm["Pivotal compile complete with output of size =>", 50],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6623987364950333`*^9, 3.662398787238428*^9, 3.662398928363042*^9, 
   3.662399029320973*^9, {3.662399105479185*^9, 3.662399123110938*^9}, 
   3.662400114157095*^9, 3.662400219467546*^9, 3.662400473874671*^9, 
   3.662400760777849*^9, 3.662451191749796*^9, 3.662451676852049*^9, 
   3.662452034918557*^9, 3.66245221951527*^9, 3.662452461778056*^9, 
   3.66245258943685*^9, 3.662465884899666*^9, 3.662467504443974*^9, 
   3.662469026539421*^9, 3.6624730980448227`*^9, 3.662484303690796*^9, 
   3.662883197299917*^9, 3.662883245895656*^9, 3.662883352230134*^9, 
   3.662884315933392*^9, 3.6628845968290358`*^9, 3.662885408608511*^9, 
   3.662885471403324*^9, 3.6628855014242992`*^9, 3.6628855507827787`*^9, 
   3.66288594768124*^9, 3.6628861575342903`*^9, 3.662904680790246*^9, 
   3.662904865039571*^9, 3.662905002580419*^9, 3.662905273603332*^9, 
   3.6629053188250303`*^9, 3.662905356574236*^9, 3.662905560136422*^9, 
   3.66291698122799*^9, 3.6629175131712418`*^9, 3.6629178497011633`*^9, 
   3.6665195610527067`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Level6Cost", "=", 
   RowBox[{"{", 
    RowBox[{"MapMEKLbeyond", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}]}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level6Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level6Cost", " ", ",", "Level6PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level6Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level6Cost", " ", ",", "Level6PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level6Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level6Cost", " ", ",", "Level6PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level6Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level6Cost", " ", ",", "Level6PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"L6", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"Level6Cost", ",", " ", 
    RowBox[{"PlotStyle", "\[Rule]", "Green"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6623981336000853`*^9, 3.662398300176219*^9}, 
   3.6623983535481167`*^9, {3.662398392412941*^9, 3.662398396723207*^9}, 
   3.662398480152388*^9, {3.6623986842178802`*^9, 3.662398684376505*^9}, {
   3.662400183189086*^9, 3.662400205628029*^9}, 3.662905308568336*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["round complete with output of size =>", 6],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400474035129*^9, 3.662400760852441*^9, 
   3.662451191828823*^9, 3.6624516769326773`*^9, 3.662452035001472*^9, 
   3.662452219588162*^9, 3.6624524618691587`*^9, 3.6624525895315647`*^9, 
   3.662465884998214*^9, 3.66246750452923*^9, 3.6624690266289597`*^9, 
   3.662473098136833*^9, 3.662484303789394*^9, 3.662883197322262*^9, 
   3.66288324591431*^9, 3.662883352495716*^9, 3.662884316018606*^9, 
   3.6628845970290956`*^9, 3.66288540868683*^9, 3.6628854714808197`*^9, 
   3.662885501505548*^9, 3.662885550857904*^9, 3.66288594775918*^9, 
   3.662886157806489*^9, 3.662904681080598*^9, 3.66290486530639*^9, 
   3.6629050029825478`*^9, 3.662905273622707*^9, 3.662905318857504*^9, 
   3.66290535660741*^9, 3.6629055604170437`*^9, 3.662916981510346*^9, 
   3.66291751320728*^9, 3.66291784995223*^9, 3.666519561313921*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "15"}],
  SequenceForm["round complete with output of size =>", 15],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400474035129*^9, 3.662400760852441*^9, 
   3.662451191828823*^9, 3.6624516769326773`*^9, 3.662452035001472*^9, 
   3.662452219588162*^9, 3.6624524618691587`*^9, 3.6624525895315647`*^9, 
   3.662465884998214*^9, 3.66246750452923*^9, 3.6624690266289597`*^9, 
   3.662473098136833*^9, 3.662484303789394*^9, 3.662883197322262*^9, 
   3.66288324591431*^9, 3.662883352495716*^9, 3.662884316018606*^9, 
   3.6628845970290956`*^9, 3.66288540868683*^9, 3.6628854714808197`*^9, 
   3.662885501505548*^9, 3.662885550857904*^9, 3.66288594775918*^9, 
   3.662886157806489*^9, 3.662904681080598*^9, 3.66290486530639*^9, 
   3.6629050029825478`*^9, 3.662905273622707*^9, 3.662905318857504*^9, 
   3.66290535660741*^9, 3.6629055604170437`*^9, 3.662916981510346*^9, 
   3.66291751320728*^9, 3.66291784995223*^9, 3.66651956336126*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "33"}],
  SequenceForm["round complete with output of size =>", 33],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400474035129*^9, 3.662400760852441*^9, 
   3.662451191828823*^9, 3.6624516769326773`*^9, 3.662452035001472*^9, 
   3.662452219588162*^9, 3.6624524618691587`*^9, 3.6624525895315647`*^9, 
   3.662465884998214*^9, 3.66246750452923*^9, 3.6624690266289597`*^9, 
   3.662473098136833*^9, 3.662484303789394*^9, 3.662883197322262*^9, 
   3.66288324591431*^9, 3.662883352495716*^9, 3.662884316018606*^9, 
   3.6628845970290956`*^9, 3.66288540868683*^9, 3.6628854714808197`*^9, 
   3.662885501505548*^9, 3.662885550857904*^9, 3.66288594775918*^9, 
   3.662886157806489*^9, 3.662904681080598*^9, 3.66290486530639*^9, 
   3.6629050029825478`*^9, 3.662905273622707*^9, 3.662905318857504*^9, 
   3.66290535660741*^9, 3.6629055604170437`*^9, 3.662916981510346*^9, 
   3.66291751320728*^9, 3.66291784995223*^9, 3.666519573077474*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "51"}],
  SequenceForm["round complete with output of size =>", 51],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400474035129*^9, 3.662400760852441*^9, 
   3.662451191828823*^9, 3.6624516769326773`*^9, 3.662452035001472*^9, 
   3.662452219588162*^9, 3.6624524618691587`*^9, 3.6624525895315647`*^9, 
   3.662465884998214*^9, 3.66246750452923*^9, 3.6624690266289597`*^9, 
   3.662473098136833*^9, 3.662484303789394*^9, 3.662883197322262*^9, 
   3.66288324591431*^9, 3.662883352495716*^9, 3.662884316018606*^9, 
   3.6628845970290956`*^9, 3.66288540868683*^9, 3.6628854714808197`*^9, 
   3.662885501505548*^9, 3.662885550857904*^9, 3.66288594775918*^9, 
   3.662886157806489*^9, 3.662904681080598*^9, 3.66290486530639*^9, 
   3.6629050029825478`*^9, 3.662905273622707*^9, 3.662905318857504*^9, 
   3.66290535660741*^9, 3.6629055604170437`*^9, 3.662916981510346*^9, 
   3.66291751320728*^9, 3.66291784995223*^9, 3.66651961852555*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.662400117758751*^9, 3.662400212033543*^9, 3.662400269194549*^9, 
   3.662400522566966*^9, 3.662400771494088*^9, 3.662451232122109*^9, 
   3.6624517180741587`*^9, 3.662452075178135*^9, 3.662452257623581*^9, 
   3.662452469329549*^9, 3.662452679998783*^9, 3.662465958339058*^9, 
   3.6624675245908117`*^9, 3.6624690485568123`*^9, 3.662473118329412*^9, 
   3.6624843290095263`*^9, 3.662883197392425*^9, 3.662883245985738*^9, 
   3.662883387072864*^9, 3.662884325215128*^9, 3.662884626074492*^9, 
   3.66288541518058*^9, {3.662885479560483*^9, 3.662885506420884*^9}, 
   3.662885559019876*^9, 3.662885955891492*^9, 3.6628862088989697`*^9, 
   3.662904732766074*^9, 3.6629048936887293`*^9, 3.662905059959507*^9, 
   3.662905273692663*^9, 3.662905318936283*^9, 3.662905356682103*^9, 
   3.662905622247115*^9, 3.662917029370006*^9, 3.662917513416772*^9, 
   3.662917898007616*^9, 3.666519618586093*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0, 1, 0], PointSize[0.011000000000000001`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAFVW1u7FrEsAAAAAAAAAAAE6Tn+Zz
BxrApVcKaKplB0AJJ+bltuocwNgq7YwGuQxA3g/8+KqUIMBKyO1qWUUQQNon
q8rkgyLAS6opBMUhEUC6ftDNYUUlwKTNEtHRSRJAX6nks1M0J8C+hq5/H74T
QOR0tHrDbSnAwNGaw1IPFUDKx87MRaMrwHdN05+S1xVAkCmKsta1L8B3xSDq
EHAWQHekZvBHKDDAaDcq94iNFkCOetXo1oAxwFMYW+y9PhdAzXP34xuIMsD2
PmbW9fQXQDDSgkLrIDTA/a4dwsttGEBykHGs8/c0wOWRe12JSRlA6LrrMQH4
NcDoE6reQ0gaQDQz1SnILTfAOdX0nHX/GkAqc4+QP9w4wEdqY6iNaRtAt1Sr
It6POcAoR8S5xJUbQACz1IpVnzrADx0yQ0m7G0CA32CltNQ7wJQnzaYM8RtA
Sfx256BqPcAsiDsgOhgcQNhqidhF/j3AKj3IZF49HED5QqK/fRk/wKGBCJCz
aRxAXXgIeDsoQMBJxBvJXP4cQO+MYyQovEDA0gNPBDJ6HUDX+fJGmFVBwFsB
Hv8OwR1AR9mdkLnbQcCI3IbHFW4eQGv24kSkhULAaCt4mbXQHkCvskH9QxVD
wEsILNbC6h5AiD805OaXQ8DpvRCW5fQeQCNEHrpAK0TAmcDpxXkuH0ANI2it
M85EwDaGTeRIQB9AHByaA4ZRRcA4GucUZ4IfQPuH6dnv5UXAJNtBCdLbH0A+
5/aGfHNGwK1ZNo2SBCBAxSnGDMgJR8Co1s0uiRUgQD9mcmaWq0fAmt10+Kck
IEDXrin5wH5IwGy/jIAnKyBAo2T+xdDESMByrojtsDYgQJ+p50EVcUnA31ty
s3ZaIEANYrAzZwBKwJ2vc59/cyBAq5+57LB7SsCphUjEgHwgQAwPu3leEUvA
AYEx8+SDIEAt/HUldLhLwPGqDhgSnyBAnrmi17aDTMDeseNNx68gQGoeu7yC
ykzA+HCptZa8IEDOjKGeRGNNwFgVW3cT1CBAAHsue1ULTsD0SqigHg4hQARk
l7j5i07AGjfb1jEuIUAM+pDB8UxPwDexlQ0PUyFAUDp/nA==
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-64.90383856730826, -0.6287098224755783},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{-63.90531797396505, 0}, {-0.481234678931924, 8.66222422077463}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{-59.86721241784519, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "26"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-48.35428695287496, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "21"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-36.841361487904734`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "16"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-64.47238260383328, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-62.16979751083923, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-57.564627324851145`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55.262042231857095`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-52.95945713886305, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50.65687204586901, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-46.051701859880914`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-43.74911676688687, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-41.44653167389282, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-39.14394658089878, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34.538776394910684`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32.23619130191664, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-29.933606208922594`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20.72326583694641, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16.11809565095832, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-9.210340371976182, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.615805480084347, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.903487552536127, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.126631103850338`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{
  3.662400117776836*^9, 3.662400212298478*^9, 3.662400269325694*^9, 
   3.662400522585546*^9, 3.662400771513884*^9, 3.662451232155116*^9, 
   3.6624517180875807`*^9, 3.66245207519383*^9, 3.6624522576387377`*^9, 
   3.662452469136859*^9, 3.6624526800198727`*^9, 3.662465958359543*^9, 
   3.6624675246060762`*^9, 3.662469048570726*^9, 3.662473118349828*^9, 
   3.6624843290271473`*^9, 3.6628831974051456`*^9, 3.6628832459979467`*^9, 
   3.662883387092958*^9, 3.6628843252415867`*^9, 3.6628846260897303`*^9, 
   3.662885415193342*^9, {3.662885479575295*^9, 3.6628855063633757`*^9}, 
   3.662885559032382*^9, 3.66288595591488*^9, 3.662886208913419*^9, 
   3.662904732779889*^9, 3.662904893633717*^9, 3.662905059972713*^9, 
   3.662905273705337*^9, 3.6629053190702972`*^9, 3.662905356695932*^9, 
   3.662905622380706*^9, 3.662917029386043*^9, 3.662917513462722*^9, 
   3.6629178980364313`*^9, 3.6665196187256002`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Construct COST for level=7 states", "Subsection",
 CellChangeTimes->{{3.661711587191434*^9, 3.661711603872994*^9}, {
   3.6617562169407597`*^9, 3.661756217116431*^9}, 3.661756430533242*^9, {
   3.6624001669992*^9, 3.66240016725849*^9}, {3.6624002277445717`*^9, 
   3.662400227916829*^9}, {3.662905433324033*^9, 3.6629054341037207`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Level7PIV", "=", 
   RowBox[{"nextPIV", "[", 
    RowBox[{"Level6PIV", ",", "Level6Cost"}], " ", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.662399108068822*^9, {3.662400169883463*^9, 3.662400180901896*^9}, {
   3.662400239486629*^9, 3.662400263806128*^9}, {3.662400373929418*^9, 
   3.662400380536907*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Pivotal compile complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "50"}],
  SequenceForm["Pivotal compile complete with output of size =>", 50],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.6623987364950333`*^9, 3.662398787238428*^9, 3.662398928363042*^9, 
   3.662399029320973*^9, {3.662399105479185*^9, 3.662399123110938*^9}, 
   3.662400114157095*^9, 3.662400219467546*^9, 3.662400522819016*^9, 
   3.662400771735909*^9, 3.662451232364759*^9, 3.662451718291144*^9, 
   3.662452075406034*^9, 3.6624522578326893`*^9, 3.662452680223091*^9, 
   3.6624659585776978`*^9, 3.662467524825385*^9, 3.6624690487874393`*^9, 
   3.6624731186857357`*^9, 3.6624843293365*^9, 3.662883197499938*^9, 
   3.662883246091629*^9, 3.6628833873546677`*^9, 3.662884325597752*^9, 
   3.662884626345941*^9, 3.66288541542775*^9, 3.662885479799308*^9, 
   3.662885559252658*^9, 3.6628859561735086`*^9, 3.662886209159418*^9, 
   3.662904733057764*^9, 3.662905060144434*^9, 3.6629052738954363`*^9, 
   3.6629053192240477`*^9, 3.662905356803585*^9, 3.6629056227644053`*^9, 
   3.6629170296350203`*^9, 3.662917513647196*^9, 3.66291789831126*^9, 
   3.666519619090905*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"Level7Cost", "=", 
   RowBox[{"{", 
    RowBox[{"MapMEKLbeyond", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Epsilon]in", ",", "1"}], "}"}]}], "]"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level7Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level7Cost", " ", ",", "Level7PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level7Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level7Cost", " ", ",", "Level7PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level7Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level7Cost", " ", ",", "Level7PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Level7Cost", "=", 
   RowBox[{"nextRound", "[", 
    RowBox[{"Level3Cost", ",", " ", "Level7Cost", " ", ",", "Level7PIV"}], 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"L7", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{"Level7Cost", ",", " ", 
    RowBox[{"PlotStyle", "\[Rule]", "Orange"}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.6623981336000853`*^9, 3.662398300176219*^9}, 
   3.6623983535481167`*^9, {3.662398392412941*^9, 3.662398396723207*^9}, 
   3.662398480152388*^9, {3.6623986842178802`*^9, 3.662398684376505*^9}, {
   3.662400183189086*^9, 3.662400257182205*^9}, 3.6629053120071783`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "6"}],
  SequenceForm["round complete with output of size =>", 6],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400522901052*^9, 3.6624007719149714`*^9, 
   3.662451232444326*^9, 3.6624517183687067`*^9, 3.662452075491335*^9, 
   3.662452257899755*^9, 3.66245268031715*^9, 3.662465958680859*^9, 
   3.6624675249126453`*^9, 3.6624690488744087`*^9, 3.662473118823154*^9, 
   3.6624843294290447`*^9, 3.6628831975283823`*^9, 3.662883246109247*^9, 
   3.6628833876302767`*^9, 3.662884325682095*^9, 3.6628846265793247`*^9, 
   3.6628854154938374`*^9, 3.66288547988126*^9, 3.662885559332143*^9, 
   3.662885956255843*^9, 3.662886209435437*^9, 3.6629047333314953`*^9, 
   3.6629050604132566`*^9, 3.662905273921228*^9, 3.662905319241623*^9, 
   3.662905356830388*^9, 3.662905623028057*^9, 3.662917029890944*^9, 
   3.662917513675379*^9, 3.662917898572543*^9, 3.666519619358961*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "15"}],
  SequenceForm["round complete with output of size =>", 15],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400522901052*^9, 3.6624007719149714`*^9, 
   3.662451232444326*^9, 3.6624517183687067`*^9, 3.662452075491335*^9, 
   3.662452257899755*^9, 3.66245268031715*^9, 3.662465958680859*^9, 
   3.6624675249126453`*^9, 3.6624690488744087`*^9, 3.662473118823154*^9, 
   3.6624843294290447`*^9, 3.6628831975283823`*^9, 3.662883246109247*^9, 
   3.6628833876302767`*^9, 3.662884325682095*^9, 3.6628846265793247`*^9, 
   3.6628854154938374`*^9, 3.66288547988126*^9, 3.662885559332143*^9, 
   3.662885956255843*^9, 3.662886209435437*^9, 3.6629047333314953`*^9, 
   3.6629050604132566`*^9, 3.662905273921228*^9, 3.662905319241623*^9, 
   3.662905356830388*^9, 3.662905623028057*^9, 3.662917029890944*^9, 
   3.662917513675379*^9, 3.662917898572543*^9, 3.666519621624978*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "33"}],
  SequenceForm["round complete with output of size =>", 33],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400522901052*^9, 3.6624007719149714`*^9, 
   3.662451232444326*^9, 3.6624517183687067`*^9, 3.662452075491335*^9, 
   3.662452257899755*^9, 3.66245268031715*^9, 3.662465958680859*^9, 
   3.6624675249126453`*^9, 3.6624690488744087`*^9, 3.662473118823154*^9, 
   3.6624843294290447`*^9, 3.6628831975283823`*^9, 3.662883246109247*^9, 
   3.6628833876302767`*^9, 3.662884325682095*^9, 3.6628846265793247`*^9, 
   3.6628854154938374`*^9, 3.66288547988126*^9, 3.662885559332143*^9, 
   3.662885956255843*^9, 3.662886209435437*^9, 3.6629047333314953`*^9, 
   3.6629050604132566`*^9, 3.662905273921228*^9, 3.662905319241623*^9, 
   3.662905356830388*^9, 3.662905623028057*^9, 3.662917029890944*^9, 
   3.662917513675379*^9, 3.662917898572543*^9, 3.666519630822359*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"round complete with output of size =>\"\>", 
   "\[InvisibleSpace]", "51"}],
  SequenceForm["round complete with output of size =>", 51],
  Editable->False]], "Print",
 CellChangeTimes->{{3.66239829102137*^9, 3.662398354072654*^9}, 
   3.662398393005905*^9, 3.662398436319621*^9, 3.6623987246354*^9, 
   3.662399125587756*^9, 3.662400114204664*^9, {3.662400212042563*^9, 
   3.662400220967101*^9}, 3.662400522901052*^9, 3.6624007719149714`*^9, 
   3.662451232444326*^9, 3.6624517183687067`*^9, 3.662452075491335*^9, 
   3.662452257899755*^9, 3.66245268031715*^9, 3.662465958680859*^9, 
   3.6624675249126453`*^9, 3.6624690488744087`*^9, 3.662473118823154*^9, 
   3.6624843294290447`*^9, 3.6628831975283823`*^9, 3.662883246109247*^9, 
   3.6628833876302767`*^9, 3.662884325682095*^9, 3.6628846265793247`*^9, 
   3.6628854154938374`*^9, 3.66288547988126*^9, 3.662885559332143*^9, 
   3.662885956255843*^9, 3.662886209435437*^9, 3.6629047333314953`*^9, 
   3.6629050604132566`*^9, 3.662905273921228*^9, 3.662905319241623*^9, 
   3.662905356830388*^9, 3.662905623028057*^9, 3.662917029890944*^9, 
   3.662917513675379*^9, 3.662917898572543*^9, 3.666519671984376*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.662885565667577*^9, 3.662885964584194*^9, 
  3.662886259262595*^9, 3.662904786300084*^9, 3.6629051183625317`*^9, 
  3.662905274053178*^9, 3.662905319313442*^9, 3.6629053569263678`*^9, 
  3.6629056795049753`*^9, 3.662917079041898*^9, 3.662917513772098*^9, 
  3.66291794671834*^9, 3.666519672091736*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[1, 0.5, 0], PointSize[0.011000000000000001`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJwBQQO+/CFib1JlAgAAADMAAAACAAAAFVW1u7FrEsAAAAAAAAAAAAX/si5/
xBnAW8JjSETdCEBTxoSzWWUcwA99ORwueA1AF0HoVls9IMCstCC25qsQQBM7
0+BGpiLAfxyJMKAZEkBODitVkW0lwNp4E2wQZhNAhIjR9Z0PJ8A302TG/d8U
QB39v7k7XSnAf/kJrcEGFkBZ2py8KuMrwB7kyHz23BZA5aAfJ+VfLsC+HBJP
SEoXQJ+pVLDcWTDAdpdAH0GqF0A3XcMCX0UxwMhpUMXNLxhAF2GDBz+XMsAA
3z2az/cYQGEIo0R2wTPAFhz35XhkGUCDYP4cIOo0wPKnlyQ9lhpA3DmqNe8h
NsDBTmMRQJYbQOk1B/wMLjfATroK3EsQHEDdmDq58MA4wGNuwV0idhxANmg1
niNyOcDlsOGfvKQcQO1Lo9zjlzrACO1HscLkHEAe4Z5WqcY7wByA4KSJBB1A
+JuCnmwjPcBkMRuHNicdQIQglTEvCj7A9x2qAi9aHUCEyYJG8zM/wJcCuTiq
hh1ASKySlS9eQMB+8KcbrjEeQL3WFgL91EDAEfIpmzmkHkCgqTYaVVZBwHzA
P8qm2R5AiT7aN3bdQcAijm2p2XgfQDoTLNCbf0LA5TO/zSzRH0A5PaB/zQFD
wFwXPtOn8R9AaY1CFdyaQ8AWfHsZsQwgQGFvQhwaPETAblphMSEtIEDVzJ2m
U8FEwD2w4A/cPCBA2aOpMOJQRcC9jP0ONF4gQL7PXsL06UXAcEtgrWyGIEA/
FgvguXNGwDNv/2JfnSBAmFsJl64IR8De9eR1IK8gQH4WOyaQo0fATeBItCW9
IEB3AB1BvjxIwF21MybZwSBAlbDsB0bySMDr2yWuqt4gQFEY6/yRjEnApU04
LBz6IEAcnPf9gwhKwL8zZF5nCSFAmZEOKoeLSsDL+C7NQhQhQB5hQn0oE0vA
asG6jk8aIUB76t//1c5LwKhEvOh0NCFAV5jnBqBtTMCTuQ3a/EAhQFfG51aC
1kzAFvRw9ldRIUBVkOHXc3NNwN7KmMFoaSFAPN2ivPICTsCvC3z7uKQhQKHk
YKllhE7AiO+iLcW4IUAFxvjH0mlPwJ4PQeJR5iFAayRwnQ==
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-65.13775485684522, -0.6495854134250316},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{-64.13563555135529, 0}, {-0.4972135263253328, 
    8.949843473855989}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{-59.86721241784519, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "26"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-48.35428695287496, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "21"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-36.841361487904734`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "16"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-64.47238260383328, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-62.16979751083923, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-57.564627324851145`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55.262042231857095`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-52.95945713886305, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50.65687204586901, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-46.051701859880914`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-43.74911676688687, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-41.44653167389282, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-39.14394658089878, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34.538776394910684`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32.23619130191664, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-29.933606208922594`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20.72326583694641, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16.11809565095832, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-9.210340371976182, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.903487552536127, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.308952660644293`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.596634733096073`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.819778284410283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.002099841204238`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.156250521031495`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.289781913656018`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.407564949312402`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{3.662885565614346*^9, 3.66288596473123*^9, 
  3.662886259401963*^9, 3.662904786312785*^9, 3.6629051183759823`*^9, 
  3.6629052740670033`*^9, 3.662905319327017*^9, 3.662905356945465*^9, 
  3.66290567952026*^9, 3.662917079064616*^9, 3.662917513791604*^9, 
  3.66291794674631*^9, 3.6665196721089373`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\

Build combined plots from data\
\>", "Subsection",
 CellChangeTimes->{{3.6629182178019238`*^9, 3.662918234942346*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"mek3", "=", 
   RowBox[{"MakePlotList", "[", "Level3Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mek4", "=", 
   RowBox[{"MakePlotList", "[", "Level4Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mek5", "=", 
   RowBox[{"MakePlotList", "[", "Level5Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mek6", "=", 
   RowBox[{"MakePlotList", "[", "Level6Cost", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mek7", "=", 
    RowBox[{"MakePlotList", "[", "Level7Cost", "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"mekALL", "=", 
  RowBox[{"ListLogLogPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"mek3", ",", "mek4", ",", "mek5", ",", "mek6", ",", "mek7"}], 
     "}"}], ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", " ", 
       SuperscriptBox["10", "5"]}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.662402703803215*^9, 3.662402715969163*^9}, {
   3.662402781875449*^9, 3.662402813484396*^9}, {3.662448544309986*^9, 
   3.6624485605090637`*^9}, {3.6624488590982723`*^9, 3.662448896520987*^9}, {
   3.6624490413006563`*^9, 3.662449078062503*^9}, {3.662449125537704*^9, 
   3.662449130624495*^9}, {3.662449169123337*^9, 3.662449222579863*^9}, {
   3.662449319303331*^9, 3.662449321991075*^9}, {3.662449387339226*^9, 
   3.662449396826222*^9}, 3.662449610771461*^9, {3.662449731347261*^9, 
   3.6624497424503202`*^9}, {3.6624657903598967`*^9, 3.662465790647402*^9}, {
   3.662906070063837*^9, 3.662906070272544*^9}, 3.66291951241476*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.6629060768363247`*^9, 3.662917079339974*^9, 
  3.662917514049281*^9, 3.6629179470514193`*^9, 3.662919513420466*^9, 
  3.6665196723182907`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7W6fcPDLv7f29SIb113S/m2Pzi9+UnTNz+GT/ck8
r6tn1zM4NP199Fb9znd7DpuWkwfvsTn42DoeivL8YS/3uOfploUcDh/eLm/M
Ffllv+Wd79nMeVwORt05N3+u+WufdcmZzfyKgEPX3+Uqhd/+2jMs+/nR5qqA
g0Lz+Xd/lf7bmz40Ps/4TcAheqOPOoseg4PAAYuk3hZBB03JVWvZzjE4rNe2
3GR0UMjh9C07RpeZTA7bCl5xXi4UcdA03aS/+DyTg6yNyfU5tSIOm7uargsb
MTu4zNvKKLBNxOHyv0z3753MDheNXJ1q94s4GK7136Ziy+JwOHOlmv0sUYe3
waGXpFpZHNr1Tr4xfSLqsLFpodKuqywOseKKPzYFiDmwmJx49jqN1SFKWjQ/
dLa4gxNz/ZzaPDYHi5ccb3bckXA4PevPHLvjbA6Jons3mr2TcNjaUORceJfd
Yc6iRekRGpIOAPpyoEM=
      "]]}, 
    {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAA6LN5HHdg8D/Cet70xioBQOizeRx3
YPA/wnre9MYqAUBr6Bd9oLbxP540lA+AvgVAzL/O6Vss9T8NS9vFOfULQITA
llcMd/Y/mhfT82UNDUAgTBLHpF/4P0vODGve6A5AllB58THg+T85YAjjIQsQ
QBAo6DiEZfs/kh3z/QBiEkDZ95JJOLH8P0mxrPX9GxNAgzn45FvG/j8RV+fi
X6kTQGa//TAXiv8/QPOhU86xE0BhLMwBWjwAQIRJM0am+RNA27Ki6qe2AEB/
Y4SXfvcUQJxDK4OxKQFAMbDqHEJ0FUBMJWWwsMYBQHwBzzFaFBZAO+Arx+9r
AkAcA5d6kQgYQKn753c05QJAhrC/v2hxGEBNFsGhTjADQJ6b0yzAgBhAgWaV
GQmMA0AmeWcnaKsYQEtentWu6QNAIbY/K/viGEAx+as/QWAEQMApfq1rDRlA
37iq1g2LBEBVNGar1jgZQNw6jb739gRAF+avvJqDGUA6TKFe1C4FQEO7Ckih
5xlAR/ZM+mKJBUCctUijcY8aQPS1TvCkqwVAsM4hTublGkCZqJZWZzwGQBg4
Zv2fBRxAGUePwBGSBkBNhJTuHRwcQINyinOerAZACUg8pQYgHEA9IWOo9QEH
QMLn4P4ERRxAVZA1mehOB0BeAyWr6lEcQHurSSnntgdAhPd+Yi/RHEAopW5w
ntUHQNg8yB4E1xxASrTnrA==
      "]]}, 
    {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAb06HtZNI8D/lRL0qALkDQG9Oh7WT
SPA/5US9KgC5A0B7RwfyC57xP5ncgsN0zgpAG2SmpZnJ9D9Tcs4xQo4OQL5o
yPf4WPY/4wR7Y0tXEEBxPmrHInj4PxJT2vFl/hBAGy/UpGfK+T/JFTWLmfYR
QCmGFtYCSvs/yqgx6Fv+E0Ad1HmkJuP8PyD6fGC8zxRA0LMqNX38/T+UkPwn
nhYVQIcfaMCSZP8/aDbsZbBGFUABK+om0CAAQJtgE+AJuhVAPbW5OHq6AED6
RhHYzJIWQIwxZ6akMQFAQtTvAfMDF0D1u2cqm7ABQEJ/GWjznhdAVl3a8doX
AkDudVJqEwwZQPr5vg8/bwJAJChcXUnNGUAXu81myvwCQNn72tRnIBpA6Q9H
AXo0A0CLGIXDWlEaQGOSbboolQNAIybzGV5wGkBZDH2Kb/IDQKORrO6alBpA
D9LtTjBFBEDZptFvl7AaQAFAm77ehQRAQmF+07XvGkCh4dCM29cEQOhyeX6j
GxtA4hPOed8gBUAc9BFe3HsbQFgFOMuQbgVAWrk2gcYhHEBylwrKrbIFQLmu
J5dNcRxAUUjYbe7tBUAY8bKWADgdQBwOIOQrNQZAPHVoswGRHUCGGfw3tG8G
QJbWvLqfpR1AYUWL5aitBkDo/ROLW7QdQAU/+Ubl6AZAlqS/8YjWHUAy3tMn
BTMHQArdJS8P5x1A5OiDHSdxB0CLwDbccz4eQFXPz4gzkAdArAx1+HdpHkBK
rjElDMYHQKY1i/fXnh5A3TT79w==
      "]]}, 
    {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAA5IzC3kmf8D+lVwpoqmUHQOSMwt5J
n/A/pVcKaKplB0BIycF4OU7yP9gq7YwGuQxAhjvtozp/9D9KyO1qWUUQQJVb
HTI6Q/Y/S6opBMUhEUD2qiN6j3v4P6TNEtHRSRJAINE6quXf+T++hq5/H74T
QGEy7TnXVvs/wNGaw1IPFUClDsKVDKz8P3dN05+S1xVALB3RtBPf/j93xSDq
EHAWQBLEmCZpLP8/aDcq94iNFkCWjqKbEjoAQFMYW+y9PhdAuhbI5P+uAED2
PmbW9fQXQFivpGRJWAFA/a4dwsttGEBtPSDnA6wBQOWRe12JSRlA438McXIL
AkDoE6reQ0gaQGEzt5lBeQJAOdX0nHX/GkBlBorGrwgDQEdqY6iNaRtA3wcP
5a9BA0AoR8S5xJUbQAsqPHrulANADx0yQ0m7G0D7GW5c2e8DQJQnzaYM8RtA
JNSbNVRhBEAsiDsgOhgcQDvJYdkXiQRAKj3IZF49HEA7HzByRtMEQKGBCJCz
aRxAq9RkJr8hBUBJxBvJXP4cQP8wxdG1aQVA0gNPBDJ6HUBTIKXexrEFQFsB
Hv8OwR1A6WSII8PuBUCI3IbHFW4eQDD6r+d/OQZAaCt4mbXQHkDHdJXHnHYG
QEsILNbC6h5AnCmLh6isBkDpvRCW5fQeQHRMGYT05wZAmcDpxXkuH0D3gUv9
licHQDaGTeRIQB9AoZKr7XhZB0A4GucUZ4IfQNwdGSVskAdAJNtBCdLbH0CE
O1oCfsMHQK1ZNo2SBCBAFuL3Og==
      "]]}, 
    {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.009166666666666668], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAiEJ9Pex18D9bwmNIRN0IQIhCfT3s
dfA/W8JjSETdCEDzCG6NwgPyPw99ORwueA1AETfK8Rgq9D+stCC25qsQQC5n
HRrVYPY/fxyJMKAZEkDBSs5PrZn4P9p4E2wQZhNA1RNploHG+T8302TG/d8U
QHJe/S5tTPs/f/kJrcEGFkB9Hwtn39D8Px7kyHz23BZAyjxc280u/j++HBJP
SEoXQAUGlY43Xf8/dpdAH0GqF0C21D/UtR4AQMhpUMXNLxhAGtwXGoa1AEAA
3z2az/cYQKeMk/T9MQFAFhz35XhkGUAv6y28u6YBQPKnlyQ9lhpA704Fxaga
AkDBTmMRQJYbQKZsXVpZeQJATroK3EsQHEBLr5dM4f8CQGNuwV0idhxAjgbv
pFw4A0DlsOGfvKQcQKwDf4KxkgNACO1HscLkHEB6ekXezusDQByA4KSJBB1A
2Qf4VN9NBEBkMRuHNicdQH57ro9EjARA9x2qAi9aHUA08Jz3EdoEQJcCuTiq
hh1AGIJ10Ek8BUB+8KcbrjEeQPKYoeKLdQVAEfIpmzmkHkAy++cBHrIFQHzA
P8qm2R5A++DvSorvBUAijm2p2XgfQOd18GbkNgZA5TO/zSzRH0BHDlrZb24G
QFwXPtOn8R9AD/XMmd2tBkAWfHsZsQwgQAseZqGg7gZAblphMSEtIECsmhcW
oiIHQD2w4A/cPCBAR4+qcjtZB0C9jP0ONF4gQHLJ6eXjkQdAcEtgrWyGIEDI
6Gvek8MHQDNv/2JfnSBA+pr4pQ==
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.8621218649643083, 0.057564627324851146`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->NCache[{{0.8947527007212709, 2.9831261891668768`}, {0, 
      Log[100000]}}, {{0.8947527007212709, 2.9831261891668768`}, {
     0, 11.512925464970229`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox["20", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.70805020110221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.903487552536127, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.308952660644293`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.596634733096073`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.819778284410283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.002099841204238`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.156250521031495`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.289781913656018`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.407564949312402`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.206072645530174`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.611537753638338`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.89921982609012, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.122363377404328`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.304684934198283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.458835614025542`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.592367006650065`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.710150042306449`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.815510557964274`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{3.6629060769225483`*^9, 3.662917079356461*^9, 
  3.6629175140744267`*^9, 3.662917947073579*^9, 3.662919513552024*^9, 
  3.6665196723392467`*^9}]
}, Open  ]],

Cell[TextData[{
 "Construct a plot on a Log vs LogLog scale showing all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["W", "L"], "distillation", " ", "costs"}], TraditionalForm]],
  
  FormatType->"TraditionalForm"],
 "\n"
}], "Text",
 CellChangeTimes->{{3.662906079645811*^9, 3.66290611472252*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compare with DP protocol
\
\>", "Subsection",
 CellChangeTimes->{{3.662906126014176*^9, 3.6629061406569*^9}, 
   3.664804681181984*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"CP4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.46", ",", " ", "49.3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.83", ",", "233"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13.6", ",", "1110"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CP5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.50", ",", " ", "73.2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.78", ",", "351"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13.5", ",", "1700"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CP6", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.53", ",", " ", "97.4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.76", ",", "482"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"13.4", ",", "2360"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"CP7", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.55", ",", "122"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"6.75", ",", "626"}], "}"}], " ", ",", 
     RowBox[{"{", 
      RowBox[{"13.3", ",", "3100"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6629183029045267`*^9, 3.662918314751316*^9}, {
  3.666519743375555*^9, 3.666519746637602*^9}, {3.6665198265649757`*^9, 
  3.666519867153908*^9}}],

Cell["\<\
Above data taken from published DP paper in  table 1.
\
\>", "Text",
 CellChangeTimes->{{3.662918316345295*^9, 3.6629183396237507`*^9}, {
  3.66480468249228*^9, 3.664804691036311*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Plotter", "[", 
    RowBox[{"CPin_", ",", " ", "mekin_", ",", " ", "ymax_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
      "\[Alpha]", ",", " ", "\[Beta]", ",", " ", "\[Gamma]", ",", "p1", ",", 
       "p2", ",", "p3", ",", "p4", ",", "CPfitted", ",", "mekfitted", ",", 
       "CPsol", ",", "meksol"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"CPsol", "=", 
       RowBox[{"FindFit", "[", 
        RowBox[{"CPin", ",", 
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", "*", 
           SuperscriptBox["x", "\[Gamma]"]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}], ",", 
         "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"meksol", "=", 
       RowBox[{"FindFit", "[", 
        RowBox[{"mekin", ",", 
         RowBox[{"\[Alpha]", "+", 
          RowBox[{"\[Beta]", "*", 
           SuperscriptBox["x", "\[Gamma]"]}]}], ",", 
         RowBox[{"{", 
          RowBox[{"\[Alpha]", ",", "\[Beta]", ",", "\[Gamma]"}], "}"}], ",", 
         "x"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"CPfitted", "[", "x_", "]"}], "=", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", 
         RowBox[{"\[Beta]", "*", 
          SuperscriptBox["x", "\[Gamma]"]}]}], "/.", "CPsol"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"mekfitted", "[", "x_", "]"}], "=", 
       RowBox[{
        RowBox[{"\[Alpha]", "+", 
         RowBox[{"\[Beta]", "*", 
          SuperscriptBox["x", "\[Gamma]"]}]}], "/.", "meksol"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p1", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"CPfitted", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2", ",", "20"}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p2", "=", 
       RowBox[{"ListPlot", "[", 
        RowBox[{"mekin", ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", " ", "Purple"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"p3", "=", 
       RowBox[{"ListPlot", "[", "CPin", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"p4", "=", 
       RowBox[{"Plot", "[", 
        RowBox[{
         RowBox[{"mekfitted", "[", "x", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"x", ",", "2", ",", "20"}], "}"}], ",", " ", 
         RowBox[{"AxesOrigin", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"2", ",", "0"}], "}"}]}], ",", " ", 
         RowBox[{"PlotStyle", "\[Rule]", " ", "Purple"}], ",", " ", 
         RowBox[{"PlotRange", "\[Rule]", " ", 
          RowBox[{"{", 
           RowBox[{"0", ",", "ymax"}], "}"}]}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"Show", "[", 
       RowBox[{"p4", ",", "p2", ",", "p3", ",", "p1"}], "]"}]}]}], 
    "\[IndentingNewLine]", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.662918360909025*^9, 3.6629185120569468`*^9}, {
  3.662918555226388*^9, 3.662918579049492*^9}, {3.662918673270679*^9, 
  3.662918679829072*^9}}],

Cell[TextData[{
 "\nAbove module finds fits to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubscriptBox["MEK", 
      RowBox[{"L", " "}]], "data", " ", "and", " ", 
     SubscriptBox["CP", "L"], "data"}], ",", " ", 
    RowBox[{
    "and", " ", "combines", " ", "fits", " ", "with", " ", "actual", " ", 
     "data", " ", "into", " ", "a", " ", "plot"}]}], TraditionalForm]]]
}], "Text",
 CellChangeTimes->{{3.6629187166497593`*^9, 3.66291876104631*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Plotter", "[", 
         RowBox[{"CP4", ",", " ", "mek4", ",", "2000"}], "]"}], ",", 
        RowBox[{"Plotter", "[", 
         RowBox[{"CP5", ",", " ", "mek5", ",", "3000"}], "]"}]}], "}"}], ",", 
      
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Plotter", "[", 
         RowBox[{"CP6", ",", " ", "mek6", ",", "4000"}], "]"}], ",", " ", 
        RowBox[{"Plotter", "[", 
         RowBox[{"CP7", ",", " ", "mek7", ",", "5000"}], "]"}]}], "}"}]}], 
     "}"}], "]"}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.662918524788465*^9, 3.662918551353876*^9}, {
  3.662918584618169*^9, 3.662918652075602*^9}, {3.6629186822691727`*^9, 
  3.662918714527215*^9}, {3.6629187653069353`*^9, 3.6629187655076*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.662918531495405*^9, 3.662918602486496*^9}, {
   3.662918637235876*^9, 3.6629186524892807`*^9}, 3.662918694852891*^9, 
   3.666519672565465*^9, {3.666519846476717*^9, 3.666519875947991*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.662918531495405*^9, 3.662918602486496*^9}, {
   3.662918637235876*^9, 3.6629186524892807`*^9}, 3.662918694852891*^9, 
   3.666519672565465*^9, {3.666519846476717*^9, 3.6665198760071077`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.662918531495405*^9, 3.662918602486496*^9}, {
   3.662918637235876*^9, 3.6629186524892807`*^9}, 3.662918694852891*^9, 
   3.666519672565465*^9, {3.666519846476717*^9, 3.666519876131639*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[RowBox[{\\\"N\\\", \\\"::\\\", \\\"precsm\\\"}], \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.662918531495405*^9, 3.662918602486496*^9}, {
   3.662918637235876*^9, 3.6629186524892807`*^9}, 3.662918694852891*^9, 
   3.666519672565465*^9, {3.666519846476717*^9, 3.666519876168796*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{InsetBox[
      GraphicsBox[{{{}, {}, 
         {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtjnk41HkAh6fkWqTM49bhGMbVGD/TrGX1YSPKyqYDDU8JmVxtzSp2FHPQ
yn18idDuesrjeDp0bXkoV7SRsB6LRUSrHGEfjSjbPs9+nud93j/efz6GQdH7
QtbSaDTXz/znjnuzYWe1FUH7fzW7FVQlj5SwMj1yKNtMA6PKBpYl6SogKv7z
PW4WeE7PupR3aT1i+9+/yBdx0ewrTHC/vwEmnGKLq5rOWNM+PGDnogFZiVvp
WPAueO6P1Z5voiPJcGT74lYvxDNS99601sRLrxMdB0/tg9plL9bwbS00zY0m
FB05CAkvRUXdSAfbeZqjbnv8oWyz8kT9gi4KaiVh0oBAzJRvsjqvqg+tbFlb
kPQofgu/n/ouxgC5o9msLd3HMNa9Nq9zdRNimVVKPEEoDPaK4xMTt8D7gOmJ
aks+Nqc4sQsFWxF0PF25ryscgTty3ldwDaGYnpa71BOFrEsmtbXThthozoy5
8vIkBC1pPfI1RuA3dUy4/HQKQysbA+4JjHGrW+l68lcCOPR1jfHNTfBqvJ3Y
D/0A96TwOp9pExTvkT41v3sG7n8i36mMgZkpK07luVh0ctgjWYdM0Uukptrf
/gjFkCWhgZ4ZCjqvf833iQfb/pN2+XMz7KiS49a7nYfKSL9CeC4TCJ3eee5B
AiIyu0LIAXNk7uYxGX8k4vG4QmODsgUWdm3eL3wlQrMaXWDaboH5iKxfGXQJ
avsPG18UW8I1/MVkFkcKh5v1Lr7brdCbb/Sk0i8JfP/lOzyZFTwLHcLelCTj
Yvlps6Bqa6hGeOWY9l4Ar61xquT7bbi73K2maJMCwwzvG4NMFpwaPCsX4y4i
MlA2JhpkgfZYzudlSyrsaLWcG3ttIBZFqbty01FpXHi2tMIGG8zE/HckA3E2
wSEWamx4f+Bu3JOeCdUGh5TJSDZmi66ojX+XBZ2r7G3mrWw4lFXk26tmQ3ia
LlxnYYvZO4WyuP5s+OXQPY5IbTFl6alAK83BB66h17shW4R2c08FHsvFQrPe
R31QcD4/djLHMQ+hV20tWwspmA9984GpQtBjF/lFwGUK8iGrS7+vJ3BuvDY5
V0xBQu/bGa1BYDBiUK7/MwXW5MjDu7oEXbqKjOhrFBhib5YHk8ApbWCz1m0K
/BfXLIWuBFoCiUZw++feYx+nl0AgWVs/J+ugUGVc9FeLmGAuc6kzrZNCfLlu
6ulkgmfVURn3uik88Il62p5OIHrtq6rSTyHSMeaZtJhgxt9a4dYEhZI7tAm5
hwS8yePjbn9TeJTKWb5dR9B25pemgUkK86XJh0MbCMpytcXy0xQgFH9sayPw
71hD81ug4KrT35LbR9DKcxye/ofC0wGZnfsgAedtTJ1okULdkN3M8jDBBqUp
YdUSheqydS7BrwniiSnPefnz37CCQZ23BG9Mjjr0rlCIivRoaJ8h8K0p0gv/
RGG2RntBNE/Q7Ny7tLpKIdRRLvrLRYJ/AWc58Fo=
           "]]}}, {{}, {{}, 
          {RGBColor[0.5, 0, 0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAAf0dXCbVDBkA6EUhNaBkhQH9HVwm1
QwZAOhFITWgZIUA9e8amSTQIQAxZS+HuTC5A/o5lDRkMDkBT77pfiXhAQPms
yeNvSRBAn5YKwLDiQkBTg+b8q1kSQJKoIJ8e0kdASYh46hMoFECvZWkb9JhL
QGv4rrCaKhZAA6Kof7jDWEBZzKBARAkYQMeq4vplsl1Ad+B4cKRgG0Bw/C35
+wthQC63eFKwtxxAWphzlBAwYUCW2IeRrnAeQCoMnPXbb2JAI4a4TB0oIEDt
mNSurZ9nQDnTr3IXFyFA4RoLMkuvakCgeIeFq3MiQECtJEJTM29AH+ABH5sA
JEDkKAYbGW15QJWj7Sf4OCVA0DvddNUqfEDekadc5gMmQBeeB++tl3xAHq25
4xAGJ0DxPH/oB899QJT8kijWGShAsQfJ7p94f0DZedJgl4kpQCX2e+HFZoBA
fgXM1qYTKkCUc+tnoRyBQAFI48rWfCtAZznOIHFogkCDbO9haz8sQEF8H8v9
S4RAAQW+HVmGLUApWzTuQumHQO062r/XBS5ACF8EOYUEikDZNtK9YRwwQBaf
c9ixOpFAaG9ML4/MMEBvv7aFpZyRQNWTpF2sBDFAiPdID+StkUBW1nFwDb4x
QE9N9YViVJJAg25M2vRrMkAlZc3P24+SQOLpRyCcYTNAm/vzOrcElUAdp7jB
lawzQKxbQ1dxI5VAUa3mCw==
            "]]}, {}}, {}}, {{}, {{}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           PointBox[{{3.46, 49.3}, {6.83, 233.}, {13.6, 
            1110.}}]}, {}}, {}}, {{}, {}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVx3k4lAkAx/ExjtIMYco5Ck3OwfC6esj+6FG6TNEhJsWyWKSwhWesHEnk
KkchYl6RIzlKWikibInwCPWgUGnxkNZRNNv+8X0+z1fdI9DRi0qhUJx+9r8D
c/uNfoLtIb9n5BJ6aD5QnORAo2A6Oi1e30MP5ZWUz7nyFLD+oi1+TNXD+YCa
wm36FNw3TPYcnNGDzqTihmAXCqSXV49UlrMRPjq2MFFLgVjTCTMDjgFUusIa
nvuKIKyuX3i4jAO38qJdWb1U3JTjx+bJmiA43kppcISKF0/edeRwTBDv2ftZ
eYqKGgPJyGquCaqZIsl5YqLwLp3YzU42gUQSr6/IVBQVxbyhg3RTVAYw3Guz
RHFZdEDgI2UGimFU+CtXMYibr3N7r2GBwipeBW1cHKOjOaencqxQs0eCHvtk
LTqOsM8ESe7Ae0mmXl4yDYxHjPVCL3t0MdKuZ1yXxi953iKTNC5anfnn7R/I
oIl7I7JFwgkinSNvTGzlcCvygO4hu6PYdyhM4UsLA90yf4jXf3BFxNbL3Cr9
jeDcDqVwHU9CKtfBcKRWHrbSih4Zar8ilpdAW6+hCCFt8GrGkhckOStt6+OV
cIYt+FO45IOZElV2JF0FCg6t/kuh/qj3e3B59iwTglMGrjZLgRjrpWZ0C1XB
5s5S1KhBYHJjIqKiNiNG207XRi0EmxKsjbJD1KDP38axsjgLt1+uLpaaqyOV
392mmh+KtOushoZpdTgzvQrGV8IR8iypT7xGA8yiwHe+dyMwvCJ7vC5kC07G
HFQp2H4elgM9Y746LJQpS0/vzImCfZxfo9M0C7ym2iFz7RjYDyLLmtyKK/bN
FY/LYtFtajSadlQTxKWu1HLzOKzxWuYzlbWgJaBtslu8CKNtPxRKurQw/LWO
wyi9BNrokIRfujausfYuqKcnwj+1xyvzsA6Ul6RjTsUnoWlC4mmzpC4sqay9
R/1T0CrFCNHs1IVFesZz+rNUNAy5bkmM0cOea5+ie16kwbLqsa2zGRsz/95z
H++/Al+X7/d4S2xs1lQRaIukI7EkWMujQh90jTjJMLUM8DqeTuWdMUBKvUX9
gHsm1FMO3H2rbQjhakzZ/qwsBLgtjUW/NUTqFf/qi13XYEJpML3L5UD2g4ed
FjsbZVuyQ/NLOYibvHBxKjwH4RxPL10pIxwpHFClzuaC3myZMBnw83et+9Lm
kwfFW0YGOu1GmL+jYl32Kh/8YAZfTNcY+8xSNpRU3cSxq4zdJy8Yw/9Oubt4
UAG+mas7zA4bQ+VbPIsgCjHfqryqAgLhi9/lFiQF+O2WsV57NgGR9tW87a8F
6DMJWHc8l8AXT+vlt0MC2Dwtnpy7QUBaZ7yKPywAc5RZolJAYLeat/WjCQF6
lNZsDSwmEJQZ3WL7VQDrpDeb5GsJVOd0xp2QJSEfEivn2Umg/vaNuZG9JGKp
j+eWXhJYbjvOTOSSmEtd7k7qJlCQ31xk5kTiRcWplLpeAvle0X3JLiSiPzrT
aUMEHt6RLdzhS2LGRV+i+gMB7Y86wsY4ErxJ74mdnwjIvtbYeDqBRMe5wpY3
kwQymaOX1JNJkOkKMeLTBPiJlSkXMki4vBShHJsnoKU1SHckSbTzrEamvxLY
P6+nJFFCwvSfs43RCwToA46xD8tIyKyd4pcvEyj+m3WOVUMiIlOTZ/OdwEhb
74/B+yQ+s9wt+1cI+DW4TaQ8JOFck6Ps94NATX6b7s5GEq02/ctCIYFvPjJd
K00k/gMnW0tb
           "]]}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{2., 0.},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None},
       PlotRange->{{0., 19.99999963265306}, {0, 2000}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {192., -118.66252583997979`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{{}, {}, 
         {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtxQ841HcAx/EjLuYuFZ1/F/lz1CHOV6xpfLSM/oyl5l+nYcwkTF3IKM7V
isuf4eQy7heV1WxEUROWFM+m5MwTepwnEnL5k2dRZNvz7P08r+dtGhbnG6FK
o9E8/vXfWXU3Mm860kH7v9pddIaoRQM0vY5LkgELPNNkW5dma6F/TPmV2M8Z
j3TyiguLV6HQ+Jr4u8RP0BaQkubVsBpvtOVjrBO7odKpGHDcvhbhcwcPzKX5
Ys/+43qz93SQ23hkRYXEH6kcsU+N7TqETDH7y2r5YJZ42ynqWAiByn6PfaEQ
8TO1tM30IXoc6d2xKxya9osPtM8YgOXLjFMNjcSryvU2JxlGsPQ04OcrD+FW
dIN4OoGNb27NVB+KicWwXLWwa3k9qkfUWElO8WD7ZKSmp5vAS0p/Fed5FMaZ
rjypYAMe0qY6T+w5hoNu+W+uOpvivcLwtnNRIvKKLRoblaZ4vENQS+THIbh/
rke91gy0VL0KcWAKBhfXBNcLzKHhXl6lPnUCLk+6h6M2WcBvPy1dpyENXqej
m/YpLZDt1/lTywYhvPpQ5FrBQdJtqX9Paga6tvCG8vwt8VHrKUWJQoSVEQsp
bEMryJ0Dl4IPnwZv63u9ykdW2Gvbot4+8T20hvrp0QUb4Sa0MRZJzuJwbneE
5ItNSGAkcYY8s/D7c3rrXU0uStdMvNAdE6ONqSOw7OSioNzkyNmGbDT2HzDP
yrBG+R2zQeKSC5ea5u0BTjbIiWOoiYzyEBX07gZ/3gY1+h0Toet+QFblUauw
KluoXBhZKlDLB7+jdbI0fjMYLTeThKsKYJrzefXTjXYQRz5xYzALEXNwflj4
1A7dvzRLYhkSONIat1T72GPwQHXYO6siXDOXJpVdtceHZ+bc7jqdR7J9eASX
yUPg6z71Z2HFYNx1yRyP4WFUzv3DJ1cK/cu8zZvaeVCLurNP/OsFpBzVSVHj
OuCxvqJAqixBYL7OzpBTDnDL+C25iV2Kt86m3tODDthBv89p2l2G122GS0Yg
mOxVrTj5mQxfX3awbpcSvIw//GBhUoYex5gPgksIpiYqJO1TMri3Xhmf+ZGg
z+O+rGhWBvYQu9KIIhBNtUY4zcvQbbCSE3eFoMWx6nrCCgqu5waMWXUEXhKv
AFVDCiyBaG14J8G3Q1y5hycFkWrzzPxDArL30rLRLgozuQtd57oI5tZoRc7u
ofBnVWxOvZygp+v8aJkvBeGLAIZWP8HHoc2VS8EUXgXZ0q+PEvjV7Nx6T0CB
Px75/NMxgr/shLqliRQ6Ei/eGxgn0CVXuEnJFCoK9DLUlQQDuvUrbdMoBD1U
oQW+JtAOmRYVZ1Fo529TKOcI3E1ynI9lU9jyMqFJ+DeB+pIhZ28ehdUakyk/
LxAYhL6t1iyikCqx5Lu/I2hnevuMFlOYsAh16V0k6OLkbGwtoRBQe8Ew+j3B
l413tsnKKLS59y4sLxOUjfRlpV6k8A892uyG
           "]]}}, {{}, {{}, 
          {RGBColor[0.5, 0, 0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAspKJCZAiBkCSlM+n54gnQLKSiQmQ
IgZAkpTPp+eIJ0A6458DNw8IQGdzUUeahjxA7PzJ8NlUDUA/Wxg9M8pGQECl
YS3vKhBAEiXWi3W6TUA8DEyM2HUSQERhfMm7f1FAUJ6gHrMMFEB3kFC9c0xW
QEsqfDmgBBZA/9tAzp2FYkBkD6Q4vFQYQFp6wdBduWZAutcMBZkPGkArI3AD
UFpoQEKqWoqodBxAT1mmR/WFaUDRkFJFmQgeQK00TvwJkWxAfuud6tYvIEAv
AL/tjqZxQF4+1YIbKCFAdGKjy3m2c0D9683WAUEiQOOuueUy73ZAyErveKIy
I0CxIsQ0Q2GAQK6CEkvjCCRAZlrgKQbIg0CZ3ppG5nclQCp7/Qo4dIVAjGee
qWIPJkBts0voIYGGQJ1Px7thICdARDgwv0gyh0D2BMD9QjQoQK64z0sxCIhA
+X5QcsIzKUDgw5U/p7KIQMBBAYXGAipAxUCKs6NEikBNBKv1wBIrQC7mBUxl
a4tAxmjOgE4OLEB3ZvSB+B6OQJ8RQv0BJC1ADOT3NKG1kUDRKWCySSAuQC6L
NhHDI5NAV0gRla0CL0DVeTOqCD2XQEKj18PXDTBAyLDCSEBZmUAKFp2H/4Qw
QEWGq/s63ZlAYpVsUOMGMUBf59IAMD2aQGhFTevNhjFArIEBdiohm0D+GXox
LCwyQGdtR1YmkptA4zYRV3m7MkAyKyfD+gaeQEhzNa26BDNA8X7nhsVQn0Bj
aeOOb4YzQGWpZCncfqBAhpP1wQ==
            "]]}, {}}, {}}, {{}, {{}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           PointBox[{{3.5, 73.2}, {6.78, 351.}, {13.5, 
            1700.}}]}, {}}, {}}, {{}, {}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVjGk8lAkAh2cmkUWOKTkmJbdJZrwkR/zVFms3urYckxrHFpoUQwqtq3Lm
Sm4KuWLnlSstHY7UlghbQiipdUybDhFl7Yfn93x5fo+qq89uDxqFQtmzyP/u
ndrBXhTKTvhr76jXR9PO4ng7CQraTGX5uRQWygWU8Wx5CsJ83BJq1VkI5VXl
m+hRUNo8mWjNY0FnTGGFn9NiL031Ei6wcHp4ZHq0mgJP7+jGHUwDKHecanjo
SUXWkFh6TKYhXMqvWqd107Bp++BWkwET+EWZKz4fosFh9HGTlqQpoty7x5Um
aRDtrv97s7kprjOoF3JFlqAhXbt7ONsUovGcnqtGS2B+0FFIO2QGAY/OrU5b
ghbtr1mNQnNQ9MNOP3EWQaJ8m1wuHciv5FRIvF4Ka4sN695Gb0WVrahk5J1l
GFxLj2gctMUrcQYz94IE+pk/K5xM24UOelJGasZytDhr+H6+vQ+tDsGhNjdk
kFvHoOayOKC2D/UbbpFDX0Fh8Hl3Ln7Ze2rVhxY6tJIMd6l8d0eIRpx9pd5K
7CnZ9sbtjyOQyrbTH6qWR6jlF5qvJA+RnBgJ6XUK4AfZTyg0Hoc4a75NOkoR
tb5BltV0P7wrWb3+d0llHCigK821+6Pe+0bc+wAGciysa6hRgRjppqV2LqwG
pyf1vRQZBIZ9REhY2BrETPj2y34/A5UYC3Ymfy3OdWi8dFMNg4tlypcyY1Vk
V154EEKNQFKGekODUBUuzJln+X2R4N+L71latQ61pKLjxPQ5DM7LHqjjq8FH
xvVbukY0zHq7Rjx11HEl6k8ta5tY2JzzvrVHqI7OirRMuZp42DxHmkWhBm5G
tz8pFk9EpxF7OGm/JiY2fnzkZZkEMY/ZYIaSFsJte9rJnGSwTb6vKunQQkL+
Z23xDymQGO4T9b6oDQxZWd04kYqjiV0el37VAV+C8I6YvYS7o6LNTeK6OCv1
qTOen45WKTpfs10XY+NkSKJKJhr6nNViI5jorRh44XYzC2aVt7c4bFyPVGWz
ngDnHHg6zdVwZtZDjHt+m6J+HmJL/LRcK/Swr3CipyvwMjgPmidzT2xAnEFN
5nP+Fagm7CQHtPUxQc/dnXI4HzyXmZHwAX3UxZV+iOAUwJDSYETas5BcO2ey
/FghrqllBuaVsVA6k3eolX8Vp1nuHrpSbIRt7dmSmVEEySazmDEeG1pn3opw
7xZDoYi9Qec+G+HjzFc3B0oQ7EcPFtE1wNH5UqgqlMExhf7TobMGsKVd/2a7
/Rq+GqvavR80wF99Rnvb/MvxsVXpmzIIGKqU797UVoHfigyY9zMJODCTdTrE
Begx5P1wIJtAsZdnYqi0AFbNxWNTOQRuBQTHGawUgDHMKFG+QuCU0PXH9LUC
dCmKafgUE2inx1V5GQtgEd+vIl9NYE2GejLTQwB5fqScezsBq03Sh1ffFSCS
dntq5jGBLrIw6OU9AaYSZzvjOwmIOr/QKHokwKOKYwl13QQc1beZsXsFCH/r
ICnRR6A3z8bL7l8B3jnpiV5/s/gr+MLrWk6CM3Z4dPs/BAL7GJr1siQenMxv
6R8jkHhQT+fyChKFF1dFLBUSONIoL+OjRMLpMZXi+JFAcIkxV0aTxH2O+ZDw
E4GNrNfHZ7VJGE0E3AqfJuDxLOrhKyYJmWWTweWzBAwm7nBr2SRCLmlyrOYI
rIzdn3PZkMS4Otfs6TwBauWkWqwxCYeqLCXv7wQOTod99jcl0Wr1dHZhgUDI
JwU57mYS/wFgtE32
           "]]}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{2., 0.},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None},
       PlotRange->{{0., 19.99999963265306}, {0, 3000}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {576., -118.66252583997979`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}, {InsetBox[
      GraphicsBox[{{{}, {}, 
         {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtkH0w1HkAh6WIdqnsWcqm04q8xfrtnhGtz+oqOZPmOlpa1Wn3ZIjUnuLW
yVsvEknk/aQ9+80xoTdm9nrxkpeINtfVMnK9SaGWO+9x3cx9Zp55/nxmPhbB
kd9KtLW0tLZ85j+v0ty9euPmImj9v9JqUSXtlQ66xAN901xjXPPWpSff1YP/
VGB/tjsXL/RZdsXpNCi6C03UBzzRycjMy84zBM8oY4R+3AdNQtlxr9plSHUo
K/SP3YkFHc97uJ5GSK+vFt25GQCf72JMRhsZWMOtuS/l7UPc2jTfagdj1Npt
Nm/P3Q+Dwu2Oz68zUSUoON2YHoJkUSpt6RpT8Ddkjv5+Igz6TrPNS0+tgNS9
18WsIhIjZJV9PN0Moc+Cpko3HEZdWG3ax2gW6Kw/rgzlSvHysXZ21/wqHBL4
P1q94yhYvklxCQmr8cBDqbPRIhbmqXxOvvRLeP4UZbj/lQx7PLImyl0s0BPm
Z1q26Dgy8yyVymELjKn/Wm+bngDp/bPdOtfW4FHzhU/mPknom10edEvKhuxt
c0+ncQrcnqpehtpYQu13sjtHdQJeJ8Ju7xy2hJ508ox3yyl4PcNFvnwtqvee
Hze4moouHqc/c5cVtJVyw4SiNCyWTMlYK62xNdfh8ubWdHBc50xIpzXahSUd
y6POgdav1g27sA6SEZ8/x4syEX5OJcnxswHvgHhjTOd53Hut21Cvbwu5OSM+
9p8sNBkwpFYdtnhreaiCx8+GUr2bfSbJDvHMubn9sTlwq77jKfzKHj8G1IpN
6y4iNHDmhmjSHg37NhXfZuXhDDliHVzpAK/lziGdUfkQtTYMFUetR+Uts63y
4QJYZOyo6l3niL0pfWJVQBEO7pl8mdjrCEfP8sS25mJwtZS8Kl8n1JC2pmDH
EvzGzj/2S7kTbP096xeOliDWSSyxNeAgWHHM1ajtEuj1bqmDBzk44D2gCLlc
CtMyznqbFg5cHQqfPjx8GbIjDNkiW2eUy+OOPhDKEZDF2LYvxRm02YiT27m/
YtrFYvvHPmdsihZOLFhWhrGmlZ/MQGEh0yMxfKECP5Q527XkU/DgMid83yvQ
zT24JKiQglz4SSX5oICgQTGoKaLAropZIhtTgNXPImaXKEzHc9OuzCigWrF4
baSCgqlfo1qPTsA/22POvE7hZ75a/tSegClNNhJ3UOh9t1WjjCBI1r6jmXxI
QeBiKOg7TKA5N9V1touCX2/c0Hw0QXtlRMatxxQca3b7fx1PkDggpNPUFMTG
7OhHGQQjgQ66NW8ohDwLfzNbRSAaDHm95S0Fs1aGhn2DoPVoaWPPIAViFLHr
mzoC+QWTJJ1hCgbOHi4F9wgCHy7QChj73GNKNnmoCFpE7s+H/6aQt63WLvQJ
Ae999O3EcQpjqobILDXBMr0hWcUUBWuJLm3wBUFcjpVIMEPhZAU/+IsBgneW
37s9mf38ZzPHGO8JhNcKVobNUWjc2c8O/0DQJHgyNT9PoV/jnZ47RvAv+xj5
Ug==
           "]]}}, {{}, {{}, 
          {RGBColor[0.5, 0, 0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAR66vL82bBkBWKNjTpqAyQEeury/N
mwZAVijY06agMkBhzoiD6h0JQLsx5VSPH0JAvSEuSr7NDEBeWNMsQDZNQLOR
mvUEFRBAxTX1fC0dUkB/39h6zHkSQD5wXjK/L1hAG2g+07MnFEB1EClhT2Vh
QLH7UA5PFhZAPrbHXA8uaEAXwXL1gAEYQOxZQVkIZ21AnE2IqBCLG0A2EyTq
2w9xQEp5bMF0ERxA2ICSeGKPcUDfFyr1A2geQH5H22Gy4HRAUACyQK4YIECv
ZhEZpfF4QHSoYsDEeyFAw1asTm8RfECTlToyizYiQLbFT0umZIFAiqF9yfIU
I0AzxGl8OE6GQB/cYHgEIiRAAozMOd2sikALLDl06pclQPfi/QtWlo1ANs9P
aO4zJkBUnr/xjOSOQOHl1Vm5HydAUx6EItcFkEAkoX7RcCwoQB1+0Sj04pBA
JvRUVQWNKUDRq4hUjYuRQK5k+VZDDSpA1uZv23QxkkDadfJtQwMrQMXYCfOF
/5JAPXa2F18RLEBjzDZba/eVQMHnSbdXEi1AAqSwbUrKmEAYTatM5BwuQG/9
mI4FkZpAKYYjR+YFL0BFGOym/nSfQJMfIqKJFjBAJ3ndDJdRoUB1g1irSZMw
QJiYsyXVw6FAXr4WzsEEMUAZoBtIEvGhQBjrO5O+hDFA2D7cZLz6okBuKHu4
RxIyQKNHPPr5T6NAjWijPFiEMkBSXaFdu5mkQP/ctkNBBTNAtwPkI/N6pkC9
O5YKNIAzQF/L/91lf6dAsEH57A==
            "]]}, {}}, {}}, {{}, {{}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           PointBox[{{3.53, 97.4}, {6.76, 482.}, {13.4, 
            2360.}}]}, {}}, {}}, {{}, {}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVz3k4lAkAx/HJMRKihnGNSgaRjPEK5fqlVbaEats0DcmaJFe7VEi7OZJk
wuOWIxQesTmmd7QrpJR2Ma6nYoSSzTg693FEbPvH9/n8/dX1CTnAk6JQKAe/
9b8vPu5jfwNFEw3n1siy0OJexndVoMCJOhuaeJKFyjuUiTw6BcLnRQLPdhYu
BtUVb9tCgful8VtX9pjBSKKhGsqhINC2jOelxkbkyOjMmICCqLaiY0l15tAW
RTT87b8CJs0ibeu1lvCqvLU7q1cKea9qTKs5dghNsNXsH5ZCsZnpgF6+HRJ8
eye0pqRAvpSji4btUMtYca1ARhpM2rxfO88eVD6379ZWaSQ96077KcwBd4Jo
xwVZ0ngssxxB7QQorOjI7qMysIjQpT9dtRPFNdwqhTeyoN3rj2rt3426PVTF
uOaV6J8tC+FS9+O1PGNzwTUFJOSr1/t0/wgRLTUnI2c19Exsz4/IeKHVI+qi
c70K3uRbOqzu8sGKjmGxheNavHqTLNkQ7AeXHyLUPz2iIX0l19MxMhAX9JPc
araogWx5sfNV72ko5bmyhgV0SOrVd0eMhSKOm6igvFEDidnOS1NS5yBvtvhE
OUETVc6imM59kXhXrmPym6I2OuJ9nk/r/4p7AfVJH84yMC4R39+1fBGjvVIZ
Xcs6MP1kV1i+LRYMt9gL0dHr0fb+ROrB5EtYl2jPzg3bgJlAaod46DK8HNJm
K6x0cddiXsU0PhGpOcyGhmldWNa7SK9j8hH2mN8nW7cR5l1zL0QqKRhaXOMp
DNODK4epKs5Lhc2LnlF/Iyb2nRLcvbEhDc7xAY0Hp5kQURc52/vT4dyPLPub
+mj4cL7k/uVMdG1lj6QeNsCULFd+0iEbcrz5KIaWIVpTT/On2Llgb1tSLxcZ
4pHryWRleh4URgaoAembsN/aU3eddQECU3p4mYeMsLDeX2vZ/AYejFEftsgb
w1tgV/oFRWhVooUZdBiDbFZ6xT9djIaBo3pXYzdD83B2hkFmCWxqmhw9LE3g
UjJ3Kq/pJvw5C3e5cyaINi6c/k6pFFfLQw19qrbg7aTm65euZeA+fThV8LMp
+PdCvNrJcugmu1cPbmLhJT1hNn1NBYK85kZjBllwO6NjWB5yGxaUhq3VbmYg
1Pb80jxTidt6ueGFFWZISBk4Ex38OyLNfHnGSmy4Xx5vv7+yGootNomSIDbs
t7tn+w9WQ6OUbWrUxobH89pAx7IaRIXSomSMzdGtlTi0/kotjqTRvve+ZI64
ysma9ON1+GKl6/phyBzvTa/TlWwE+Nyq9VUbBCK8lTKmTe7iRKn55rZcAqc/
qT/ZrkqizyJolWcegZIDwRI3DRI7HpZJPuYT+JOlF85jkGCMMMq1iwjMcWoH
UpkkejTl9EPKCHx1qhS8tyBhzxevowsI3Au3bWw6RIIeFrfWt4NAC9NqW00W
iTippo9znQQ41ayp3uskPqbMd/G7CIidninMFpJorwpOFvYS+OOsVap9OYmY
tx6KCgMEmpAs6Kkn8Y6zhVr7DwGX+MZjygMkuBK/sV3jBNbkNA9ZD5F4eq74
kVhCoNcp+y+f1yRupqvHyk5/+3XpGRdOkOB0rqAc+UxAfwPp4LdAoo1rOzz9
L4E+tQr99GUSWyfPNsbMEFDzvhz+QFoIlZVTUZXzBGba5Xg6ikJcyDTg7lgg
kDR4Z2mvihATzOM2zxYJlGrtlT2vKoRH3XWtgCUC/l/F4RUaQrTueDa/vEyg
84vvkQGGEP8BT7NZgQ==
           "]]}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{2., 0.},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None},
       PlotRange->{{0., 19.99999963265306}, {0, 4000}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {192., -355.98757751993935`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}], InsetBox[
      GraphicsBox[{{{}, {}, 
         {RGBColor[0.5, 0, 0.5], AbsoluteThickness[1.6], Opacity[1.], 
          LineBox[CompressedData["
1:eJwtjH041AcAxy8vJyHlqut0rMtbpDi/Lqtr7ktPqCktXUNHtFhImIsSNyTV
eT15yZVaKC85/byUDNXSDVt1F7JCeCaZRkVWbiyz59n3eT7P5/n882UdCNsd
oEahUHbM8Z/9BQ2vPCrUQPl/vhVXXfI65tonMKp+/zAv8sxmxvP+ubY49EWM
2lvemYMdrw1H1RBfr8k/xn/Pq2bOS7+koY74uDF+PHWaR00TdF7lqCP8SjI7
bKsmboTS/Gvz1KE0q53dctoAFJuEmCf7NNBoFHHaLJSFwiqBTOelJto9sp68
CWajZjtVN+nefHQuKpv8oHTE79rMNZfSdZA9Ke1soLhBQZPk5+QvhLeBT7C2
wx7IPWPjXW8vQrBsv3PDXW/Me9Tfs97JAK2yvp0qZ3+47TlOn3hAA9vImPJQ
FIA4s1T3qrVLcctP6S1sCYLexZ02/bXLkMc/DXvFESQJxDr6q5bDl74l/ejb
CGjbzrTon2GgizwR9zBXiDelRtbf667AhrGKdT1l0agPuZ36LoqJO3GHX52t
i8Fgh1qOctYIscO2M083icB0PxmXkPAZOAt+zfQcj4ex2IEtFa5EkcxvKKsp
Eb68cx/L7VkQb9y0d/SXJEjyTRsbx1iIXlKjUH+cDOHPaZ2aNaswrR/Y9iX9
LPpmFvvUCU3wwqk6MS0iBdxn7YNBlqbYNdpZv6kxDa7JIXc8xkxRqSeyl1tm
wvU58hyKzWDsGqhyOSyBksMekHxtDl59VHBWbRa0AlSxTEMLhEyVu3mZZ4O9
8RO9VGGBiUGRyCU1BzoD3dSQ7NVIJzsU243zcDizPSCXbwmThN5trnXn8dMQ
tfm+thW06iY4+Y5SyPVoQvNHVmAUha/eNn0Bjd37TFJOrsH+LnZkb3EBuFV3
nTw3WIN6SqEl3n0ZQd7TNwVT1uAEW48fyv8BKaWRFgdkayGRupbS4q9A0NY8
eiliHT4c2TLom1AIVsYusne1DX57wC/57lgRQn2nBhN7bcA3OfSaEVGM9ZRG
Dului881O1qoyVdx3UR67HK5LQKDFOedM64hxvZggJUeG3XcvwrNbpVA9z5X
PBLKRmCU35BNfymWX2Ovs2xl46bbU5b2dBliI2mxGlZ2SB/mneJsuA6vc7Rt
fqfs4FomLw75pgJ/27N2vuuzQ1su/aKTRIb3csN/VoCAV9+OnOUDlQi8Zrem
VUpgYWuCqEGfROf60AU+FwkYe+isTDUg4dhcMjJeQGAiJUjDZykJ5gCzdMUV
AhzHkpxZQxLtDC2zsBICuu4O3S7mJBzSeoyX1RIYDM8YfbmZxDJhksHBRwRS
q3y5XwWTSFK7Oz71mECkud5Gq1AS45kqZZqSwDlK+XH1cBIPZUcy6joItNCr
m28dJZE47Kmr003gOcfgxMoEEm+811KrXxHQWiWPppwnIRj5dsj5DwIqRX3x
CymJtujCBz0jBMbLypY0FJAozqaf1Byb+1ssaooqIuH9eB7F6z2Bphl9YryS
RKtgc//YJIGPeyejlVUkOH9G3Un8QCCC2z17o5bEovmjsRUqAlufyJ6F/Ugi
Ltdc4DhNIJlRYLmricRrU39u1wyBXoakyfYeCc+aC4YhnwhcKBBnL24mIXfs
Us3OEtAMF1dOyEn8C+JyKPg=
           "]]}}, {{}, {{}, 
          {RGBColor[0.5, 0, 0.5], PointSize[0.012833333333333334`], 
           AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAbWeI8qRhBkAReGz4jGA2QG1niPKk
YQZAEXhs+IxgNkAgqtjYE6oIQF28Xt905UNAwr6shhE2DEARk7RZ/CRQQHiv
yFriMhBAjNsWdhYTV0BwLyEdtJwSQCJecju07F9AjqS9DNEHFEADwUFzcxZn
QO/svWbzBxZAiKcfOPrJbkCsGdxpADkYQJ+kSFv0+XJAdYhfgw5iGkDzSjzQ
RR11QBdN+lGWZxxAR4mjMV4wd0DuKTxWtQAeQMXetwJXa3pAR6LSJ9QlIEA2
o7MHGA+AQOSJ2gzbKCFAZL+26FPbgUBjD+3FiCoiQO4APOkDEohAq7LUO145
I0BZE8bDReiOQBcxWT9AIiRAlzo3aOZokUD1eFpJMoAlQJ+1Wu3uOpNA5m/7
/hsaJkBNJN1rJyCUQE9MERlCGSdAR/e4+pBslUCklEr5PSAoQGWvfw9vGZZA
WOs3cixPKUAwBS45StyWQCL2OPibFypA5ttuIfcGmEBtwxTXPhorQNXsCzkL
GJlA823SMRlvLECRu2rHsaedQBeDKrl6PS1A3MEGWByVoEA7gpJSLB4uQMmz
AOl5eKFAwtA/uOoIL0DhQwSzw2ikQC/qziJMETBA9ZsmfG4/pkDK/87uYYIw
QDSsFHf79qZA4mtKflMHMUCA9QIFjd+nQGW53yFhkzFAs2ioMkdvqUBXvw/U
GAcyQJSUXAxtOqpAhD7w8MmDMkC9MQqXQP6rQCn/cfa+CDNAzvhLAupHrkBj
UthTaYAzQOZsmTVDq69AMgX3sg==
            "]]}, {}}, {}}, {{}, {{}, 
          {RGBColor[0.368417, 0.506779, 0.709798], PointSize[
           0.012833333333333334`], AbsoluteThickness[1.6], 
           PointBox[{{3.55, 122.}, {6.75, 626.}, {13.3, 
            3100.}}]}, {}}, {}}, {{}, {}, 
         {RGBColor[0.368417, 0.506779, 0.709798], AbsoluteThickness[1.6], 
          Opacity[1.], LineBox[CompressedData["
1:eJwVx3k41AkAh/EZxyDpMC2qsZIrjJj5GSrWfFmlco7qCU2estQWU4lcSxHb
tqGa3MdY90jkzNWY2WLCVob0lGjliYQoqkeOjm3/eJ/P8+r6nfQMkCORSN7f
+9/+WVfGd8C1UtpyyNcUdz2EyW6qJLhEfA46PWSKiirSZK4GCU3GVxyXfOmI
5dUVbjUjwXKs8+fgw2YwntBaE+JDgiNCvWcDzRE1PDL3qp6EIGX6lor7DKyX
RYruHyNj7miuwTZ9K/hWlDhl9Mmh7H3WjdIkNkIu2q599uL7y0aPpL5k46J/
3+S6KTkkXlsUBdCAWhr5cp6CPD4RAbPLQgBKMvdxCUsenZNdN1dstEcVj3q4
PkMe1Kc+k+Q/HEAyj4vqPaAADDUx/wnajsIabqXqqCLOvtmReeK6MyheTy/H
vFPE8fqZbPcBZxz/yjn1blERjkb5Op6qLiCcnYi+1RR0cobab/Nc0D7KaM5m
U/BctEJzo6UrxjSVpMY5FGh1C9PYHW4wOVvz3MlTCZEkSkuwPAd1uynLE/5W
RhGb4RgVthcvVWimeZdVwW8L0FZR5EJG5WelZa1AtFjU69bkB6lXdOzOplWg
e5y8tvXWUZAfvhi0dFBHLP1ZCaODB5e9kZrv26kwU2/Q6rU6jRiDJPcasx8w
Sjk931pwBmq5buYv6jWwQ62/9k51JBK4l1RXbtRCwjPH2F29MVCx+Nyx8uJa
HIpUUx7WjMPbMm36ueXrQfsY0y4riUdzYFPSTBgNMUyZrRLrAkb65NJ6vmlj
X6PhPabZn6C5x8fExelgKYUdItudhB8v2TGyQzfAWWgF1uEr8GWnfCq31sVI
yxnm1zA++Fn6ItG0LsK7Oa8F1ikIvZf8WLFuI7oW/KQPt6Rh6PPqg42hesi8
3lr0i0sGbPofjRwz1odJs82g/74s7LwQKN4zrY+p/KWtH0tysPMZMuyKDcCf
GIw8OyFAD4sxzN9viDnHRJmTdj6UAhaiaeuM4OmrvWcVrwCMrV81y2RGaLDf
1i2tK4Tq8AAlMHUT5pvZp6/pFyPo6qOA9H3GIHPmtpQLSnDnFaXtrooJWgWj
KW+XCSFVo4YaPjRBQ//22o8lZRANHNBLjDdFKst87C5RDpsaiYOXFR05twvG
qB03cMxn6RZ3ng61Ur58V2IlEstCjPwqzeA54+wWhCpwu9qm8oI3g0zLtW5M
rYbuFY/q55vM8cTnxJdTsTXg+c6PnH9ujnR70W9JJ2phSRKxqt0tEL57x4am
iDrc0MuO+KvcAmHBKT7ZEfWIsvAPMFFjICjdaYVm+i0sv2tzaYLHgDv7OJob
GqBVyths3MmAsDm/Jep+I6JDqNEKJkyEuWpzZN+a4J1C3XXodyaebu+fDTVq
waK1rtvMEBNHvGJkRR638UG67st6EBCMWwq8ckQ4Uso07cwmEKI8o3znaSse
W/KWHcwlUEzPVN//byvs24QTswICdtdz6qZftoI2TCtbX0CgdrztNu1tKx6t
VTI4KSRwRkfhVZyCGHbJgz9q1BMor83I+5UhhkZogrr/QwK07MJOYaIYCXKS
2fluAvneVKkHX4zZqws9yT0EGt97eS+mi/Gg8sSVxj4C3X3Bu9wLxTj/2mu5
6gABRZbjTlKzGG99zCi1YwRuDje3nR0Tgztx9NWOcQJaD35iM6bE6AovbB+c
IFBE7vMcnRWjOFUzXnGaAPUQHFy+iOHTTSZ5fyCgEXzVQW+NBJ1c2xfTHwmM
s5TPDayVgPUmTHx+jgDnWNWeazoSrFKeiq5YIOBqkiOVN5UgJt2Qa79EIMHu
tV+rhQST+odtnnwmUNIdnBluJYFXXc66wK8E4gV2R5i2Ekjtnyx8+0agnsd5
MG0vwX+7qX27
           "]]}}},
       AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
       Axes->{True, True},
       AxesLabel->{None, None},
       AxesOrigin->{2., 0.},
       DisplayFunction->Identity,
       Frame->{{False, False}, {False, False}},
       FrameLabel->{{None, None}, {None, None}},
       FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
       GridLines->{None, None},
       GridLinesStyle->Directive[
         GrayLevel[0.5, 0.4]],
       Method->{
        "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
         AbsolutePointSize[6], "ScalingFunctions" -> None},
       PlotRange->{{0., 19.99999963265306}, {0, 5000}},
       PlotRangeClipping->True,
       PlotRangePadding->{{
          Scaled[0.02], 
          Scaled[0.02]}, {0, 0}},
       Ticks->{Automatic, Automatic}], {576., -355.98757751993935`}, 
      ImageScaled[{0.5, 0.5}], {360., 222.4922359499621}]}}, {}},
  ContentSelectable->True,
  ImageSize->{552.98828125, Automatic},
  PlotRangePadding->{6, 5}]], "Output",
 CellChangeTimes->{{3.662918557277005*^9, 3.662918602587237*^9}, {
   3.6629186377205877`*^9, 3.66291865295722*^9}, 3.662918695307794*^9, 
   3.666519673393433*^9, {3.666519847439867*^9, 3.6665198764024878`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"Comparison", " ", "of", " ", 
   SubscriptBox["DP", "L"], " ", "and", " ", 
   SubscriptBox["MEK", "L"], " ", "for", " ", "various", " ", 
   RowBox[{"L", " ", ".", "\[IndentingNewLine]", "Plots"}], " ", "above", " ",
    "used", " ", "as", " ", "basis", " ", "for", " ", "Fig", " ", "4.", 
   RowBox[{"(", "b", ")"}], "of", " ", 
   RowBox[{"paper", "."}]}]}]], "Text",
 CellChangeTimes->{{3.664804741759705*^9, 3.6648047918248053`*^9}, {
  3.664872630524991*^9, 3.664872648123705*^9}, {3.664872679108858*^9, 
  3.664872680741078*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gate Synthesis Cost", "Chapter",
 CellChangeTimes->{{3.662905663855093*^9, 3.66290567623997*^9}, 
   3.662918772899728*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.662399790159073*^9, 3.6623997934915648`*^9}, 
   3.662905699002474*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TcountL4", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9055148479", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "7"}]]}], ",", "69"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.6305279058", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], ",", "80"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5935029593", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}], ",", "90"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5016660126", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]]}], ",", "98"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5278333483", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "11"}]]}], ",", "108"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9296883821", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "12"}]]}], ",", "123"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8343636825", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "13"}]]}], ",", "133"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9073705356", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "14"}]]}], ",", "141"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9678233489", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "15"}]]}], ",", "150"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8776342523", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "16"}]]}], ",", "162"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9148794574", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "17"}]]}], ",", "172"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8757424725", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "18"}]]}], ",", "178"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8862784650", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "19"}]]}], ",", "192"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9833541157", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "20"}]]}], ",", "201"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9585408890", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "21"}]]}], ",", "210"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{".9688570192", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "22"}]]}], ",", "221"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.7129015342", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "23"}]]}], ",", "234"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5825948984", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "24"}]]}], ",", "240"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9829428419", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "25"}]]}], ",", "251"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.662188911880019*^9, 3.662189066964666*^9}, {
   3.6621891017183*^9, 3.662189105477541*^9}, {3.662189497862492*^9, 
   3.662189745105258*^9}, 3.662189879892157*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"TcountL5", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9390160772", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "7"}]]}], ",", "68"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9724375287", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], ",", "82"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5361961299", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}], ",", "87"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8184752265", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]]}], ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.7631573977", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "11"}]]}], ",", "111"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8313466878", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "12"}]]}], ",", "120"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8161247655", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "13"}]]}], ",", "124"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{".9907581214", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "14"}]]}], ",", "141"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.6245508132", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "15"}]]}], ",", "146"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.6913371799", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "16"}]]}], ",", "163"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.2670556363", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "17"}]]}], ",", "170"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.2230139643", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "18"}]]}], ",", "180"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9639145159", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "19"}]]}], ",", "191"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.7129943030", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "20"}]]}], ",", "198"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.3603379807", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "21"}]]}], ",", "207"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.4265692348", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "22"}]]}], ",", "221"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.2860398854", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "23"}]]}], ",", "230"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8594566961", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "24"}]]}], ",", "241"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8386713473", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "25"}]]}], ",", "251"}], "}"}]}], "}"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.662190613986549*^9, 3.662190975257866*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"TcountL6", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9496919476", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "4"}]]}], ",", "32"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9918673418", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "5"}]]}], ",", "49"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5387958206", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "6"}]]}], ",", "57"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9907633061", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "7"}]]}], ",", "69"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.6784972558", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "8"}]]}], ",", "78"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5432027921", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "9"}]]}], ",", "89"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.4861310976", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "10"}]]}], ",", "100"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.1969712049", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "11"}]]}], ",", "110"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9394335481", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "12"}]]}], ",", "120"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.3596223551", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "13"}]]}], ",", "129"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.4527272103", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "14"}]]}], ",", "140"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.6870568191", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "15"}]]}], ",", "151"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.7115712909", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "16"}]]}], ",", "161"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8868826632", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "17"}]]}], ",", "170"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9538034702", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "18"}]]}], ",", "180"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.7217678523", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "19"}]]}], ",", "192"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.4643213199", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "20"}]]}], ",", "201"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.9559370225", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "21"}]]}], ",", "211"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.5313943784", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "22"}]]}], ",", "221"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.6004551666", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "23"}]]}], ",", "232"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.8932720183", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "24"}]]}], ",", "242"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"0.6824269773", "*", 
        SuperscriptBox["10", 
         RowBox[{"-", "25"}]]}], ",", "247"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLogLogPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"TcountL4", ",", "TcountL5", ",", "TcountL6"}], "}"}], ",", " ", 
   RowBox[{"PlotStyle", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"Red", ",", "Purple", ",", "Green"}], "}"}]}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.662191352164186*^9, 3.662191377814335*^9}, {
  3.6621914100880823`*^9, 3.662191772107967*^9}, {3.662918962783235*^9, 
  3.6629189631904707`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.662918964084248*^9, 3.6629189936151037`*^9}, 
   3.666519673574656*^9, {3.6665198476584883`*^9, 3.6665198766020823`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {{}, 
    {RGBColor[1, 0, 0], PointSize[0.011000000000000001`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAAKFrZEaQ3MMC7GpSdue8QQDp558vC
4TLARIB4/TGHEUB3LC/wtj41wBAsMRvO/xFAyZhsQTa3N8BqdPi2AVcSQAMz
Njqo9znAxFDAm4C6EkDMJ0mONLQ7wOmWckGtPxNATYFPdlwdPsAs8I6ut48T
QMHHtrWsKkDAHrlztofLE0DmJkRTJklBwJpOgfrjChRAOlyhyWZ8QsBISoza
slkUQMLW3PrPnUPAhATJygiXFEAID6G2I8pEwDTSjXcluhRAt97p8VbvRcA2
7ObdrAcVQHSrrDXECEfA8FHTj5U2FUB2wK7FxDJIwOOBEihwYxVAAFHVGiFY
ScDlBZb2t5cVQKH2LZMgpkrA7I7Osj/SFUBugrDxseZLwAfBI5ws7BVAxIp7
dXnKTMDiodRVEBoWQKBNkc8=
      "]]}, 
    {RGBColor[0.5, 0, 0.5], PointSize[0.011000000000000001`], 
     AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBQQG+/iFib1JlAgAAABMAAAACAAAA+yWcN1cuMMA5zrugxuAQQBimjm3Z
cjLAZZ2mAnugEUDfWnmbtVg1wNI/kgQX3RFAMBvW0uU5N8AWVbW7sWsSQDdC
RSxGmTnAoaTIFY/WEkDwMuml09A7wMl5RDxkJhNAiLKb8gQjPsApJAfk90cT
QJKdNcNrH0DAHrlztofLE0ACSDtDN4FBwCR3AZM27xNAdVeSTvGaQsB71XkN
AGAUQIC+CmBsO0TASOrXvg6LFECNQrUEOXlFwE5zEHuWxRRAc+qZXpfkRcC6
cCz3UwIVQBdXdfzqMUfAaWT1eC8nFUAhcV7+/69IwH1bPzy0VBVAv61QFSLB
ScDlBZb2t5cVQHi4FbUEG0vAg4TD3JfAFUCfNtR47bRLwH4septu8BVAX22G
ysreTMDiodRVEBoWQLRfimQ=
      "]]}, 
    {RGBColor[0, 1, 0], PointSize[0.011000000000000001`], AbsoluteThickness[
     1.6], PointBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAActphWx+GIsBryLi+07kLQN74D33M
CifAV1oyrnIiD0DeHCL2K94swFmaraEVLBBAw8lgqpsgMMC7GpSdue8QQKc4
wH/9zjLAKU4jFEVtEUCyP8bFYlU1wPaKrhdd9BFAUYm1xUO/N8AWVbW7sWsS
QJ8M1ZIA9DrAMUaauUrNEkBT7bYribE7wMl5RDxkJhNAmrFyidD0PsDLtrWp
cnATQKy51warg0DAXohG6T3EE0Dqf7W1AXVBwFMAOM6xERRAhQ11BECXQsCO
cHWqW1MUQLesrGXKoUPASOrXvg6LFEDKZX3MNb9EwE5zEHuWxRRAblMFH58J
RsA27ObdrAcVQK7eDhLRaEfA8FHTj5U2FUD37UHoHTNIwPtxoH9NaBVAuIJs
+gGlScDlBZb2t5cVQJuUd2AZvErAydSEhXXJFUCdfIfu/K9LwIp+Xhes9BVA
Q65RWi75TMC/H5sYnQkWQCCzp0o=
      "]]}, {}}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{-60.07823103364491, 3.3162403114530457`},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{-59.15395055620422, 0}, {3.3513071785590567`, 
    5.5254529391317835`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.05]}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{-59.86721241784519, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "26"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-48.35428695287496, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "21"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-36.841361487904734`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "16"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-25.328436022934504`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "11"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-13.815510557964274`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "6"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        TemplateBox[{"10", 
          RowBox[{"-", "1"}]}, "Superscript", SyntaxForm -> SuperscriptBox], 
        TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-57.564627324851145`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-55.262042231857095`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-52.95945713886305, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-50.65687204586901, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-46.051701859880914`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-43.74911676688687, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-41.44653167389282, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-39.14394658089878, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-34.538776394910684`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-32.23619130191664, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-29.933606208922594`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-27.631021115928547`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-23.025850929940457`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-20.72326583694641, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-18.420680743952367`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-16.11809565095832, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-11.512925464970229`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-9.210340371976182, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-4.605170185988091, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0., 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{3.912023005428146, 
       FormBox["50", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox["200", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.0106352940962555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{{3.662918964153792*^9, 3.662918993708606*^9}, 
   3.666519673589913*^9, {3.6665198477459183`*^9, 3.66651987662204*^9}}]
}, Open  ]],

Cell["\<\
Above lists give the error rate and T-count of performing gates in the \
L=4,5,6 levels of the Clifford hierarchy.  All obtained from gridsynth \
http://www.mathstat.dal.ca/~selinger/newsynth/
We also plot this data
\
\>", "Text",
 CellChangeTimes->{{3.66290568854219*^9, 3.6629057911724033`*^9}, {
  3.662918966438562*^9, 3.662918970445558*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SizeOfLevel3Cost", "=", 
     RowBox[{
      RowBox[{"Dimensions", "[", "Level3Cost", "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"FindCombinedCost", "[", "Tcount_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"SizeOfTcount", ",", "a", ",", "b", ",", " ", "output"}], 
        "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"SizeOfTcount", "=", 
         RowBox[{
          RowBox[{"Dimensions", "[", "Tcount", "]"}], "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"output", "=", 
         RowBox[{"{", 
          RowBox[{"{", " ", 
           RowBox[{"\[Epsilon]in", ",", "1"}], "}"}], "}"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"For", "[", 
         RowBox[{
          RowBox[{"a", "=", "0"}], ",", " ", 
          RowBox[{"a", "<", " ", "SizeOfLevel3Cost"}], ",", " ", 
          RowBox[{
           RowBox[{"a", "++"}], ";", "\[IndentingNewLine]", 
           RowBox[{"For", "[", 
            RowBox[{
             RowBox[{"b", "=", "0"}], ",", 
             RowBox[{"b", "<", "  ", "SizeOfTcount"}], ",", " ", 
             RowBox[{
              RowBox[{"b", "++"}], ";", "\[IndentingNewLine]", 
              RowBox[{"\[Epsilon]total", "=", 
               RowBox[{
                RowBox[{"Tcount", "[", 
                 RowBox[{"[", 
                  RowBox[{"b", ",", "1"}], "]"}], "]"}], "+", 
                RowBox[{
                 RowBox[{"Tcount", "[", 
                  RowBox[{"[", 
                   RowBox[{"b", ",", "2"}], "]"}], "]"}], "*", 
                 RowBox[{"Level3Cost", "[", 
                  RowBox[{"[", 
                   RowBox[{"a", ",", "1"}], "]"}], "]"}]}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"Cost", "=", 
               RowBox[{
                RowBox[{"Tcount", "[", 
                 RowBox[{"[", 
                  RowBox[{"b", ",", "2"}], "]"}], "]"}], "*", 
                RowBox[{"Level3Cost", "[", 
                 RowBox[{"[", 
                  RowBox[{"a", ",", "2"}], "]"}], "]"}]}]}], ";", 
              "\[IndentingNewLine]", 
              RowBox[{"output", "=", 
               RowBox[{"Append", "[", 
                RowBox[{"output", ",", " ", 
                 RowBox[{"{", 
                  RowBox[{"\[Epsilon]total", ",", "Cost"}], "}"}]}], "]"}]}], 
              ";"}]}], "\[IndentingNewLine]", "]"}], ";"}]}], 
         "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
        RowBox[{"BestOf", "[", "output", "]"}]}]}], "\[IndentingNewLine]", 
      "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.662917214112908*^9, 3.662917403373022*^9}, {
  3.662919020538783*^9, 3.662919025722423*^9}, {3.66291906877391*^9, 
  3.662919078420467*^9}, {3.662919118967834*^9, 3.662919134639267*^9}, {
  3.6629191712893457`*^9, 3.662919219187366*^9}, {3.6629192848331623`*^9, 
  3.662919296883088*^9}, {3.66291936865845*^9, 3.662919413843528*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"TotalCost4", "=", 
   RowBox[{"FindCombinedCost", "[", "TcountL4", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TotalCost5", "=", 
   RowBox[{"FindCombinedCost", "[", "TcountL5", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"TotalCost6", "=", 
   RowBox[{"FindCombinedCost", "[", "TcountL6", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{3.662919370554721*^9, 3.66291940636318*^9}],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.6629195677962303`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"G4", "=", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"MakePlotList", "[", "TotalCost4", "]"}], ",", " ", 
       RowBox[{"PlotStyle", "\[Rule]", " ", "Red"}], ",", " ", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", "\"\<+\>\"", "}"}]}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", "500000"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"G5", "=", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"MakePlotList", "[", "TotalCost5", "]"}], ",", " ", 
       RowBox[{"PlotStyle", "\[Rule]", " ", "Purple"}], ",", " ", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", "\"\<+\>\"", "}"}]}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", "500000"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"G6", "=", 
     RowBox[{"ListLogLogPlot", "[", 
      RowBox[{
       RowBox[{"MakePlotList", "[", "TotalCost6", "]"}], ",", " ", 
       RowBox[{"PlotStyle", "\[Rule]", " ", "Green"}], ",", " ", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", "\"\<+\>\"", "}"}]}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{"1", ",", "500000"}], "}"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Gall", "=", 
    RowBox[{"Show", "[", 
     RowBox[{"G4", ",", "G5", ",", " ", "G6"}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.662189939534234*^9, 3.6621903388451014`*^9}, {
   3.6621904129767714`*^9, 3.662190414430883*^9}, {3.6621904928816853`*^9, 
   3.662190516179243*^9}, {3.6621905613789997`*^9, 3.662190575553833*^9}, {
   3.6621910222048597`*^9, 3.662191022652594*^9}, {3.662905826154046*^9, 
   3.6629058731601353`*^9}, 3.662917190374839*^9, {3.662917410621122*^9, 
   3.662917476863078*^9}, {3.662918897671115*^9, 3.6629189052674627`*^9}, {
   3.66291931775636*^9, 3.6629193201466*^9}, {3.662919458526052*^9, 
   3.662919471291853*^9}, {3.662919533372649*^9, 3.662919691945211*^9}, {
   3.662919787869947*^9, 3.662919810833654*^9}, {3.662919881695397*^9, 
   3.662919881975651*^9}, {3.662919934170815*^9, 3.662919960544066*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.662919960993338*^9, 3.666519673797443*^9, {3.666519847985626*^9, 
   3.666519876967719*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.662919960993338*^9, 3.666519673797443*^9, {3.666519847985626*^9, 
   3.66651987703304*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"N", "::", "precsm"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Requested precision \
\[NoBreak]\\!\\(\\*RowBox[{\\\"16\\\"}]\\)\[NoBreak] is smaller than \
$MinPrecision. Using $MinPrecision instead. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precsm\\\", ButtonNote -> \
\\\"N::precsm\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.662919960993338*^9, 3.666519673797443*^9, {3.666519847985626*^9, 
   3.666519877096843*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[
       TagBox[InsetBox["+", {0., 0.}],
        "InsetString"], CompressedData["
1:eJxTTMoPSmVmYGCQA2JGIGYC4ja/k0EF89/Z77cIa5KKl3FA5ytuy71X++6T
vaiQdcs7OzmHXfdnntlu+8N+0rfXgT8eKjgYCG1Uy7H7Zf/jb/K2u58UHJjX
TGTuvP7bPi33Wb2ylaKD3Cze3rbQv/ami5+pl91QdLhZZHIm1uC//Q7X/cHH
Nig5eKhNPBk9ncGhtmJjc9MfJYcvx2a1525gcDCMC8tKZ1J2eHj43H+nPEYH
rdRivvdRyg4PbK1e7lnA6FCgv3vd0nhlh+cPVtdxNjE5iL2/kLfgh7KDYJD0
fiMOZodl+11cov1VHPQOz7p3yprZQWDLh5MzW1UcwmbdeeZ5ltlB6aZzRGOu
qsPnO/8sK0VZHA6zXuprm6rqkL6Ng12ij8Vh0xtvXwszNQeh2752nzlZHbQD
7QIVQtQcop8e/t4hy+pgny5hcj9GzWHbGcHg762sDv8M5cN6a9Qc9j9rXHFn
NavD7B+ChvNmqjlc2zm/eJsxm0NRmfhC1oNqDidlzYw/zmdzmHDZdOaG+0D1
UWt5xdawOVixTji17ZWaw55p96U2vWNzeCf7jbv5m5qDcG708yoFdocAwZi/
bPzqDsYMy27b57I7BM7r2HDKVN2h7V1Ucshcdof7209P0g9WdxCUCPWZd5zd
wXoaU2BRvroDAOdJ0AY=
       "]]}, {}}, {}}, {{}, {
     {RGBColor[0.5, 0, 0.5], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[
       TagBox[InsetBox["+", {0., 0.}],
        "InsetString"], CompressedData["
1:eJxTTMoPSmVmYGCQA2JGIGYC4rIOB8aYze/sbd/UtqoHyDig8z9qM33M+/bJ
fvLRpPbf+nIOK5Yn2UQ7/7APvFB/ue6WgoPpVpnbFs6/7Ldf/26e8lrBYYFm
ycOo27/tVd2rGFcZKTocznsd5hL+1/5LTdXKPxcUHQ4ds/yzWf2/fbl88FWf
lUoOp2cvOyhbweDA2+7Bps6p7JBuOM375X0GB5cIO/ZSdWWHH/XvvBNLGB24
3ys3T/ZUdqg6dTe5bgWjQ+DObGUvP2WHdcla7s7JTA458fqFP5hUHHpC7Dc4
FjM5nHO0v/JZXcVB5G/Tzgm/mRymvPRoTIpVcfg183Tz3Hxmh8knjGZ171Zx
uG28Ytu2y8wOk06tuXonQdXhl9nu3LeSLA4H5ftWLitUdVgsybh6fz+LwwY2
jowIITWHbJbrJ0XZWB20A+0CFULUHM57fny6zI3VQc+gdf/3VDWHw6///kif
zOrg7Ba/aFseUF5fxWDiUVaHBzxBtce71RziP17SznJgc+Cx6bPSOaLm8Gqy
gPHS42wORW62kzffVHMQupRV1fiGzSFKlnFh9Xc1h2srr3yL0mZ3mL9n86K/
jOoOIWvO/pgTy+7Q55HFsUFK3eHc+cT9O+ezO0gfjGmv8VZ3iBNb6Dj9DLtD
xfzJrvvT1R0AcJrP5A==
       "]]}, {}}, {}}, {{}, {
     {RGBColor[0, 1, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[
       TagBox[InsetBox["+", {0., 0.}],
        "InsetString"], CompressedData["
1:eJwBFQLq/SFib1JlAwAAACAAAAABAAAAAgAAACjJjQeHDfE/OoIexEpMGUAo
yY0Hhw3xPzqCHsRKTBlAGsA6xWGl8T/F1SJSxC0aQMC8mt7dC/Y/nzag5SCx
HkAeKkt0gDb2P2tFkK7r0h5AKoo+wwcn+D/Lf64uuDIgQHpK8GluZfo/x71w
uAuRIEBjNLABBcb7PzUt84FR2CBAPQdDlqnC/D8EY/MppHYhQLnKgCh4Gv8/
uEW/U8awIkB0MDRFHCP/P3/cpM/k0iJANGyNscWTAEBv3wYPjO8iQJZer55V
qwBAI8Wr9XD1IkAzad2oenIBQJ0Usow2VSNA1ZY6DOamAUDj3vks7VkjQNiS
mOMqgwJAbF8vcfgCJECjUtVJ2BkDQFy6MVPAWCRAfBgnrgFiA0DHrt3Y/o4k
QNRu13w9ogNAxbBXFFA0JUANrSGm2x4EQBNpZQzkhSVA7PT+FNnCBEACUN/K
lSYmQD1xfMd9JAVAy7inantQJkDsIQS/xo8FQNqK+j/0fyZAD5GnW/6/BUB4
Ue0aBZ0mQAfTbBLqPgZAlQkMCdq9JkDkvm+SUaEGQHJGPZOz2SZAOplGTaet
BkAceJfEueQmQNsuztLb7AZAem63jTv8JkDbHH+q/TIHQBP5HtQIIydAknZ3
XU5xB0BRnoiwyjUnQPUGO6jJoAdA37fLki9TJ0DraBz3odAHQDuWAlFybydA
0MngJw==
       "]]}, {}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.8828246182458286, 0.06561181688702164},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{571.61328125, Automatic},
  Method->{},
  PlotRange->NCache[{{0.9149730071736568, 2.9724698985546714`}, {0, 
      Log[500000]}}, {{0.9149730071736568, 2.9724698985546714`}, {
     0, 13.122363377404328`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox["20", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.70805020110221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.903487552536127, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.308952660644293`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.596634733096073`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.819778284410283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.002099841204238`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.156250521031495`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.289781913656018`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.407564949312402`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.206072645530174`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.611537753638338`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.89921982609012, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.122363377404328`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.304684934198283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.458835614025542`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.592367006650065`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.710150042306449`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.815510557964274`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {14.508657738524219`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {14.914122846632385`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.201804919084164`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.424948470398375`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.60727002719233, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.761420707019587`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.89495209964411, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {16.012735135300492`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{
  3.6629199612460413`*^9, 3.6665196739233217`*^9, {3.6665198481650867`*^9, 
   3.6665198772380533`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.662920708116263*^9, 3.6629207082538033`*^9}}],

Cell["\<\
Combined Tcount and magic state cost for L=4,5,6.
\
\>", "Text",
 CellChangeTimes->{{3.66291947740007*^9, 3.66291949609264*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"Gall", ",", "mekALL"}], "]"}]], "Input",
 CellChangeTimes->{{3.662919517659671*^9, 3.662919523941493*^9}, {
  3.66291967708224*^9, 3.662919679112289*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, {
      {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[
        TagBox[InsetBox["+", {0., 0.}],
         "InsetString"], CompressedData["
1:eJxTTMoPSmVmYGCQA2JGIGYC4ja/k0EF89/Z77cIa5KKl3FA5ytuy71X++6T
vaiQdcs7OzmHXfdnntlu+8N+0rfXgT8eKjgYCG1Uy7H7Zf/jb/K2u58UHJjX
TGTuvP7bPi33Wb2ylaKD3Cze3rbQv/ami5+pl91QdLhZZHIm1uC//Q7X/cHH
Nig5eKhNPBk9ncGhtmJjc9MfJYcvx2a1525gcDCMC8tKZ1J2eHj43H+nPEYH
rdRivvdRyg4PbK1e7lnA6FCgv3vd0nhlh+cPVtdxNjE5iL2/kLfgh7KDYJD0
fiMOZodl+11cov1VHPQOz7p3yprZQWDLh5MzW1UcwmbdeeZ5ltlB6aZzRGOu
qsPnO/8sK0VZHA6zXuprm6rqkL6Ng12ij8Vh0xtvXwszNQeh2752nzlZHbQD
7QIVQtQcop8e/t4hy+pgny5hcj9GzWHbGcHg762sDv8M5cN6a9Qc9j9rXHFn
NavD7B+ChvNmqjlc2zm/eJsxm0NRmfhC1oNqDidlzYw/zmdzmHDZdOaG+0D1
UWt5xdawOVixTji17ZWaw55p96U2vWNzeCf7jbv5m5qDcG708yoFdocAwZi/
bPzqDsYMy27b57I7BM7r2HDKVN2h7V1Ucshcdof7209P0g9WdxCUCPWZd5zd
wXoaU2BRvroDAOdJ0AY=
        "]]}, {}}, {}}, {{}, {
      {RGBColor[0.5, 0, 0.5], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[
        TagBox[InsetBox["+", {0., 0.}],
         "InsetString"], CompressedData["
1:eJxTTMoPSmVmYGCQA2JGIGYC4rIOB8aYze/sbd/UtqoHyDig8z9qM33M+/bJ
fvLRpPbf+nIOK5Yn2UQ7/7APvFB/ue6WgoPpVpnbFs6/7Ldf/26e8lrBYYFm
ycOo27/tVd2rGFcZKTocznsd5hL+1/5LTdXKPxcUHQ4ds/yzWf2/fbl88FWf
lUoOp2cvOyhbweDA2+7Bps6p7JBuOM375X0GB5cIO/ZSdWWHH/XvvBNLGB24
3ys3T/ZUdqg6dTe5bgWjQ+DObGUvP2WHdcla7s7JTA458fqFP5hUHHpC7Dc4
FjM5nHO0v/JZXcVB5G/Tzgm/mRymvPRoTIpVcfg183Tz3Hxmh8knjGZ171Zx
uG28Ytu2y8wOk06tuXonQdXhl9nu3LeSLA4H5ftWLitUdVgsybh6fz+LwwY2
jowIITWHbJbrJ0XZWB20A+0CFULUHM57fny6zI3VQc+gdf/3VDWHw6///kif
zOrg7Ba/aFseUF5fxWDiUVaHBzxBtce71RziP17SznJgc+Cx6bPSOaLm8Gqy
gPHS42wORW62kzffVHMQupRV1fiGzSFKlnFh9Xc1h2srr3yL0mZ3mL9n86K/
jOoOIWvO/pgTy+7Q55HFsUFK3eHc+cT9O+ezO0gfjGmv8VZ3iBNb6Dj9DLtD
xfzJrvvT1R0AcJrP5A==
        "]]}, {}}, {}}, {{}, {
      {RGBColor[0, 1, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
       GeometricTransformationBox[
        TagBox[InsetBox["+", {0., 0.}],
         "InsetString"], CompressedData["
1:eJwBFQLq/SFib1JlAwAAACAAAAABAAAAAgAAACjJjQeHDfE/OoIexEpMGUAo
yY0Hhw3xPzqCHsRKTBlAGsA6xWGl8T/F1SJSxC0aQMC8mt7dC/Y/nzag5SCx
HkAeKkt0gDb2P2tFkK7r0h5AKoo+wwcn+D/Lf64uuDIgQHpK8GluZfo/x71w
uAuRIEBjNLABBcb7PzUt84FR2CBAPQdDlqnC/D8EY/MppHYhQLnKgCh4Gv8/
uEW/U8awIkB0MDRFHCP/P3/cpM/k0iJANGyNscWTAEBv3wYPjO8iQJZer55V
qwBAI8Wr9XD1IkAzad2oenIBQJ0Usow2VSNA1ZY6DOamAUDj3vks7VkjQNiS
mOMqgwJAbF8vcfgCJECjUtVJ2BkDQFy6MVPAWCRAfBgnrgFiA0DHrt3Y/o4k
QNRu13w9ogNAxbBXFFA0JUANrSGm2x4EQBNpZQzkhSVA7PT+FNnCBEACUN/K
lSYmQD1xfMd9JAVAy7inantQJkDsIQS/xo8FQNqK+j/0fyZAD5GnW/6/BUB4
Ue0aBZ0mQAfTbBLqPgZAlQkMCdq9JkDkvm+SUaEGQHJGPZOz2SZAOplGTaet
BkAceJfEueQmQNsuztLb7AZAem63jTv8JkDbHH+q/TIHQBP5HtQIIydAknZ3
XU5xB0BRnoiwyjUnQPUGO6jJoAdA37fLki9TJ0DraBz3odAHQDuWAlFybydA
0MngJw==
        "]]}, {}}, {}}}, {{}, {{}, 
     {RGBColor[0.368417, 0.506779, 0.709798], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJxTTMoPSmViYGAQA2IQ7W6fcPDLv7f29SIb113S/m2Pzi9+UnTNz+GT/ck8
r6tn1zM4NP199Fb9znd7DpuWkwfvsTn42DoeivL8YS/3uOfploUcDh/eLm/M
Ffllv+Wd79nMeVwORt05N3+u+WufdcmZzfyKgEPX3+Uqhd/+2jMs+/nR5qqA
g0Lz+Xd/lf7bmz40Ps/4TcAheqOPOoseg4PAAYuk3hZBB03JVWvZzjE4rNe2
3GR0UMjh9C07RpeZTA7bCl5xXi4UcdA03aS/+DyTg6yNyfU5tSIOm7uargsb
MTu4zNvKKLBNxOHyv0z3753MDheNXJ1q94s4GK7136Ziy+JwOHOlmv0sUYe3
waGXpFpZHNr1Tr4xfSLqsLFpodKuqywOseKKPzYFiDmwmJx49jqN1SFKWjQ/
dLa4gxNz/ZzaPDYHi5ccb3bckXA4PevPHLvjbA6Jons3mr2TcNjaUORceJfd
Yc6iRekRGpIOAPpyoEM=
       "]]}, 
     {RGBColor[0.880722, 0.611041, 0.142051], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBIQLe/SFib1JlAgAAACEAAAACAAAA6LN5HHdg8D/Cet70xioBQOizeRx3
YPA/wnre9MYqAUBr6Bd9oLbxP540lA+AvgVAzL/O6Vss9T8NS9vFOfULQITA
llcMd/Y/mhfT82UNDUAgTBLHpF/4P0vODGve6A5AllB58THg+T85YAjjIQsQ
QBAo6DiEZfs/kh3z/QBiEkDZ95JJOLH8P0mxrPX9GxNAgzn45FvG/j8RV+fi
X6kTQGa//TAXiv8/QPOhU86xE0BhLMwBWjwAQIRJM0am+RNA27Ki6qe2AEB/
Y4SXfvcUQJxDK4OxKQFAMbDqHEJ0FUBMJWWwsMYBQHwBzzFaFBZAO+Arx+9r
AkAcA5d6kQgYQKn753c05QJAhrC/v2hxGEBNFsGhTjADQJ6b0yzAgBhAgWaV
GQmMA0AmeWcnaKsYQEtentWu6QNAIbY/K/viGEAx+as/QWAEQMApfq1rDRlA
37iq1g2LBEBVNGar1jgZQNw6jb739gRAF+avvJqDGUA6TKFe1C4FQEO7Ckih
5xlAR/ZM+mKJBUCctUijcY8aQPS1TvCkqwVAsM4hTublGkCZqJZWZzwGQBg4
Zv2fBRxAGUePwBGSBkBNhJTuHRwcQINyinOerAZACUg8pQYgHEA9IWOo9QEH
QMLn4P4ERRxAVZA1mehOB0BeAyWr6lEcQHurSSnntgdAhPd+Yi/RHEAopW5w
ntUHQNg8yB4E1xxASrTnrA==
       "]]}, 
     {RGBColor[0.560181, 0.691569, 0.194885], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAb06HtZNI8D/lRL0qALkDQG9Oh7WT
SPA/5US9KgC5A0B7RwfyC57xP5ncgsN0zgpAG2SmpZnJ9D9Tcs4xQo4OQL5o
yPf4WPY/4wR7Y0tXEEBxPmrHInj4PxJT2vFl/hBAGy/UpGfK+T/JFTWLmfYR
QCmGFtYCSvs/yqgx6Fv+E0Ad1HmkJuP8PyD6fGC8zxRA0LMqNX38/T+UkPwn
nhYVQIcfaMCSZP8/aDbsZbBGFUABK+om0CAAQJtgE+AJuhVAPbW5OHq6AED6
RhHYzJIWQIwxZ6akMQFAQtTvAfMDF0D1u2cqm7ABQEJ/GWjznhdAVl3a8doX
AkDudVJqEwwZQPr5vg8/bwJAJChcXUnNGUAXu81myvwCQNn72tRnIBpA6Q9H
AXo0A0CLGIXDWlEaQGOSbboolQNAIybzGV5wGkBZDH2Kb/IDQKORrO6alBpA
D9LtTjBFBEDZptFvl7AaQAFAm77ehQRAQmF+07XvGkCh4dCM29cEQOhyeX6j
GxtA4hPOed8gBUAc9BFe3HsbQFgFOMuQbgVAWrk2gcYhHEBylwrKrbIFQLmu
J5dNcRxAUUjYbe7tBUAY8bKWADgdQBwOIOQrNQZAPHVoswGRHUCGGfw3tG8G
QJbWvLqfpR1AYUWL5aitBkDo/ROLW7QdQAU/+Ubl6AZAlqS/8YjWHUAy3tMn
BTMHQArdJS8P5x1A5OiDHSdxB0CLwDbccz4eQFXPz4gzkAdArAx1+HdpHkBK
rjElDMYHQKY1i/fXnh5A3TT79w==
       "]]}, 
     {RGBColor[0.922526, 0.385626, 0.209179], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAA5IzC3kmf8D+lVwpoqmUHQOSMwt5J
n/A/pVcKaKplB0BIycF4OU7yP9gq7YwGuQxAhjvtozp/9D9KyO1qWUUQQJVb
HTI6Q/Y/S6opBMUhEUD2qiN6j3v4P6TNEtHRSRJAINE6quXf+T++hq5/H74T
QGEy7TnXVvs/wNGaw1IPFUClDsKVDKz8P3dN05+S1xVALB3RtBPf/j93xSDq
EHAWQBLEmCZpLP8/aDcq94iNFkCWjqKbEjoAQFMYW+y9PhdAuhbI5P+uAED2
PmbW9fQXQFivpGRJWAFA/a4dwsttGEBtPSDnA6wBQOWRe12JSRlA438McXIL
AkDoE6reQ0gaQGEzt5lBeQJAOdX0nHX/GkBlBorGrwgDQEdqY6iNaRtA3wcP
5a9BA0AoR8S5xJUbQAsqPHrulANADx0yQ0m7G0D7GW5c2e8DQJQnzaYM8RtA
JNSbNVRhBEAsiDsgOhgcQDvJYdkXiQRAKj3IZF49HEA7HzByRtMEQKGBCJCz
aRxAq9RkJr8hBUBJxBvJXP4cQP8wxdG1aQVA0gNPBDJ6HUBTIKXexrEFQFsB
Hv8OwR1A6WSII8PuBUCI3IbHFW4eQDD6r+d/OQZAaCt4mbXQHkDHdJXHnHYG
QEsILNbC6h5AnCmLh6isBkDpvRCW5fQeQHRMGYT05wZAmcDpxXkuH0D3gUv9
licHQDaGTeRIQB9AoZKr7XhZB0A4GucUZ4IfQNwdGSVskAdAJNtBCdLbH0CE
O1oCfsMHQK1ZNo2SBCBAFuL3Og==
       "]]}, 
     {RGBColor[0.528488, 0.470624, 0.701351], PointSize[0.009166666666666668],
       AbsoluteThickness[1.6], PointBox[CompressedData["
1:eJwBUQKu/SFib1JlAgAAACQAAAACAAAAiEJ9Pex18D9bwmNIRN0IQIhCfT3s
dfA/W8JjSETdCEDzCG6NwgPyPw99ORwueA1AETfK8Rgq9D+stCC25qsQQC5n
HRrVYPY/fxyJMKAZEkDBSs5PrZn4P9p4E2wQZhNA1RNploHG+T8302TG/d8U
QHJe/S5tTPs/f/kJrcEGFkB9Hwtn39D8Px7kyHz23BZAyjxc280u/j++HBJP
SEoXQAUGlY43Xf8/dpdAH0GqF0C21D/UtR4AQMhpUMXNLxhAGtwXGoa1AEAA
3z2az/cYQKeMk/T9MQFAFhz35XhkGUAv6y28u6YBQPKnlyQ9lhpA704Fxaga
AkDBTmMRQJYbQKZsXVpZeQJATroK3EsQHEBLr5dM4f8CQGNuwV0idhxAjgbv
pFw4A0DlsOGfvKQcQKwDf4KxkgNACO1HscLkHEB6ekXezusDQByA4KSJBB1A
2Qf4VN9NBEBkMRuHNicdQH57ro9EjARA9x2qAi9aHUA08Jz3EdoEQJcCuTiq
hh1AGIJ10Ek8BUB+8KcbrjEeQPKYoeKLdQVAEfIpmzmkHkAy++cBHrIFQHzA
P8qm2R5A++DvSorvBUAijm2p2XgfQOd18GbkNgZA5TO/zSzRH0BHDlrZb24G
QFwXPtOn8R9AD/XMmd2tBkAWfHsZsQwgQAseZqGg7gZAblphMSEtIECsmhcW
oiIHQD2w4A/cPCBAR4+qcjtZB0C9jP0ONF4gQHLJ6eXjkQdAcEtgrWyGIEDI
6Gvek8MHQDNv/2JfnSBA+pr4pQ==
       "]]}, {}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0.8828246182458286, 0.06561181688702164},
  CoordinatesToolOptions:>{"DisplayFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& ), "CopiedValueFunction" -> ({
      Exp[
       Part[#, 1]], 
      Exp[
       Part[#, 2]]}& )},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}, {
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledFrameTicks[{Log, Exp}]}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImageSize->{559.51171875, Automatic},
  Method->{},
  PlotRange->NCache[{{0.9149730071736568, 2.9724698985546714`}, {0, 
      Log[500000]}}, {{0.9149730071736568, 2.9724698985546714`}, {
     0, 13.122363377404328`}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->FrontEndValueCache[{
     Charting`ScaledTicks[{Log, Exp}], 
     Charting`ScaledTicks[{Log, Exp}]}, {{{1.6094379124341003`, 
       FormBox["5", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox["20", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.70805020110221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}, {{0., 
       FormBox["1", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {2.302585092994046, 
       FormBox["10", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {4.605170185988092, 
       FormBox["100", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {6.907755278982137, 
       FormBox["1000", TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {9.210340371976184, 
       FormBox[
        TemplateBox[{"10", "4"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {11.512925464970229`, 
       FormBox[
        TemplateBox[{"10", "5"}, "Superscript", SyntaxForm -> SuperscriptBox],
         TraditionalForm], {0.01, 0.}, {
        AbsoluteThickness[0.1]}}, {-2.3025850929940455`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-1.2039728043259361`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.916290731874155, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.5108256237659907, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.35667494393873245`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.2231435513142097, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {-0.10536051565782628`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {0.6931471805599453, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.0986122886681098`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.3862943611198906`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.6094379124341003`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.791759469228055, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {1.9459101490553132`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.0794415416798357`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.1972245773362196`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {2.995732273553991, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.4011973816621555`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.6888794541139363`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {3.912023005428146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.0943445622221, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.248495242049359, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.382026634673881, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {4.499809670330265, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.298317366548036, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.703782474656201, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {5.991464547107982, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.214608098422191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.396929655216146, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.551080335043404, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.684611727667927, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {6.802394763324311, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {7.600902459542082, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.006367567650246, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.294049640102028, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.517193191416238, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.699514748210191, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.85366542803745, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {8.987196820661973, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.104979856318357, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {9.903487552536127, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.308952660644293`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.596634733096073`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {10.819778284410283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.002099841204238`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.156250521031495`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.289781913656018`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {11.407564949312402`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.206072645530174`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.611537753638338`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {12.89921982609012, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.122363377404328`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.304684934198283`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.458835614025542`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.592367006650065`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.710150042306449`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {13.815510557964274`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {14.508657738524219`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {14.914122846632385`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.201804919084164`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.424948470398375`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.60727002719233, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.761420707019587`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {15.89495209964411, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}, {16.012735135300492`, 
       FormBox[
        InterpretationBox[
         StyleBox[
          
          GraphicsBox[{}, ImageSize -> {0., 0.}, BaselinePosition -> 
           Baseline], "CacheGraphics" -> False], 
         Spacer[{0., 0.}]], TraditionalForm], {0.005, 0.}, {
        AbsoluteThickness[0.1]}}}}]]], "Output",
 CellChangeTimes->{{3.6629195243763123`*^9, 3.662919549754793*^9}, {
   3.662919673779022*^9, 3.662919696547244*^9}, {3.662919941558745*^9, 
   3.6629199463885736`*^9}, 3.662919982330668*^9, 3.666519674041045*^9, {
   3.6665198482785673`*^9, 3.66651987739053*^9}}]
}, Open  ]],

Cell[TextData[{
 "The above compares the gate synthesis data with the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["MEK", "L"], " "}], TraditionalForm]]],
 "data.\n\nPlots above used as basis of Fig. 5 of paper.\n"
}], "Text",
 CellChangeTimes->{{3.6648047136000834`*^9, 3.664804735966116*^9}, {
  3.664872652515892*^9, 3.664872672220492*^9}}]
}, Open  ]]
},
WindowSize->{1516, 735},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"10.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 9, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 95, 1, 64, "Section"],
Cell[678, 25, 411, 6, 28, "Input"],
Cell[CellGroupData[{
Cell[1114, 35, 1252, 30, 97, "Input"],
Cell[2369, 67, 2724, 38, 28, "Output"],
Cell[5096, 107, 2579, 35, 28, "Output"],
Cell[7678, 144, 2578, 35, 28, "Output"]
}, Open  ]],
Cell[10271, 182, 216, 5, 49, "Text"],
Cell[10490, 189, 380, 8, 63, "Input"],
Cell[10873, 199, 492, 12, 108, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11402, 216, 102, 1, 65, "Chapter"],
Cell[CellGroupData[{
Cell[11529, 221, 172, 2, 64, "Section"],
Cell[11704, 225, 337, 7, 49, "Text"],
Cell[CellGroupData[{
Cell[12066, 236, 292, 8, 45, "Subsection"],
Cell[12361, 246, 2086, 61, 133, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14484, 312, 136, 2, 44, "Subsection"],
Cell[14623, 316, 2231, 74, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16891, 395, 168, 2, 44, "Subsection"],
Cell[17062, 399, 1740, 55, 134, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18839, 459, 327, 7, 44, "Subsection"],
Cell[19169, 468, 6199, 156, 204, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[25405, 629, 324, 5, 44, "Subsection"],
Cell[25732, 636, 1220, 27, 65, "Input"],
Cell[26955, 665, 749, 13, 87, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27753, 684, 184, 2, 64, "Section"],
Cell[CellGroupData[{
Cell[27962, 690, 3643, 81, 91, "Input"],
Cell[31608, 773, 18608, 331, 451, "Output"]
}, Open  ]],
Cell[50231, 1107, 820, 24, 90, "Text"],
Cell[CellGroupData[{
Cell[51076, 1135, 210, 3, 53, "Subsection"],
Cell[51289, 1140, 2517, 67, 306, "Input"],
Cell[53809, 1209, 222, 5, 49, "Text"],
Cell[54034, 1216, 3890, 98, 380, "Input"],
Cell[57927, 1316, 909, 32, 51, "Text"],
Cell[58839, 1350, 5260, 99, 301, "Input"],
Cell[64102, 1451, 833, 16, 70, "Text"],
Cell[64938, 1469, 2356, 66, 204, "Input"],
Cell[67297, 1537, 316, 7, 49, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[67662, 1550, 133, 5, 99, "Section"],
Cell[CellGroupData[{
Cell[67820, 1559, 126, 1, 44, "Subsection"],
Cell[67949, 1562, 2559, 59, 250, "Input"],
Cell[CellGroupData[{
Cell[70533, 1625, 1562, 39, 165, "Input"],
Cell[72098, 1666, 2017, 32, 24, "Message"],
Cell[74118, 1700, 25213, 640, 242, "Output"],
Cell[99334, 2342, 445, 7, 32, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99828, 2355, 135, 4, 69, "Subsection"],
Cell[CellGroupData[{
Cell[99988, 2363, 279, 8, 28, "Input"],
Cell[100270, 2373, 580, 11, 46, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[100887, 2389, 1758, 43, 148, "Input"],
Cell[CellGroupData[{
Cell[102670, 2436, 1405, 23, 22, "Print"],
Cell[104078, 2461, 1407, 23, 22, "Print"],
Cell[105488, 2486, 1407, 23, 22, "Print"],
Cell[106898, 2511, 1407, 23, 22, "Print"]
}, Open  ]],
Cell[108320, 2537, 1658, 28, 24, "Message"],
Cell[109981, 2567, 26459, 655, 242, "Output"]
}, Open  ]],
Cell[136455, 3225, 92, 1, 28, "Input"],
Cell[136550, 3228, 70, 1, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[136657, 3234, 245, 3, 44, "Subsection"],
Cell[CellGroupData[{
Cell[136927, 3241, 246, 6, 28, "Input"],
Cell[137176, 3249, 1415, 22, 22, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[138628, 3276, 1557, 40, 114, "Input"],
Cell[CellGroupData[{
Cell[140210, 3320, 1383, 22, 22, "Print"],
Cell[141596, 3344, 1386, 22, 22, "Print"],
Cell[142985, 3368, 1386, 22, 22, "Print"],
Cell[144374, 3392, 1384, 22, 22, "Print"]
}, Open  ]],
Cell[145773, 3417, 1116, 20, 24, "Message"],
Cell[146892, 3439, 25916, 650, 242, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[172857, 4095, 292, 4, 44, "Subsection"],
Cell[CellGroupData[{
Cell[173174, 4103, 298, 7, 28, "Input"],
Cell[173475, 4112, 1279, 21, 22, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[174791, 4138, 1602, 40, 114, "Input"],
Cell[CellGroupData[{
Cell[176418, 4182, 1267, 20, 22, "Print"],
Cell[177688, 4204, 1268, 20, 22, "Print"],
Cell[178959, 4226, 1269, 20, 22, "Print"],
Cell[180231, 4248, 1268, 20, 22, "Print"]
}, Open  ]],
Cell[181514, 4271, 1388, 24, 24, "Message"],
Cell[182905, 4297, 26494, 661, 242, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[209448, 4964, 342, 4, 44, "Subsection"],
Cell[CellGroupData[{
Cell[209815, 4972, 348, 8, 28, "Input"],
Cell[210166, 4982, 1211, 20, 22, "Print"]
}, Open  ]],
Cell[CellGroupData[{
Cell[211414, 5007, 1605, 40, 114, "Input"],
Cell[CellGroupData[{
Cell[213044, 5051, 1209, 19, 22, "Print"],
Cell[214256, 5072, 1211, 19, 22, "Print"],
Cell[215470, 5093, 1211, 19, 22, "Print"],
Cell[216684, 5114, 1211, 19, 22, "Print"]
}, Open  ]],
Cell[217910, 5136, 791, 15, 24, "Message"],
Cell[218704, 5153, 27652, 698, 244, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[246405, 5857, 129, 4, 69, "Subsection"],
Cell[CellGroupData[{
Cell[246559, 5865, 1665, 40, 137, "Input"],
Cell[248227, 5907, 632, 13, 24, "Message"],
Cell[248862, 5922, 25594, 620, 246, "Output"]
}, Open  ]],
Cell[274471, 6545, 311, 10, 51, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[274819, 6560, 145, 5, 69, "Subsection"],
Cell[274967, 6567, 1443, 47, 97, "Input"],
Cell[276413, 6616, 194, 5, 49, "Text"],
Cell[276610, 6623, 3151, 78, 236, "Input"],
Cell[279764, 6703, 469, 13, 51, "Text"],
Cell[CellGroupData[{
Cell[280258, 6720, 901, 22, 63, "Input"],
Cell[281162, 6744, 680, 13, 24, "Message"],
Cell[281845, 6759, 682, 13, 24, "Message"],
Cell[282530, 6774, 680, 13, 24, "Message"],
Cell[283213, 6789, 726, 13, 24, "Message"],
Cell[283942, 6804, 23506, 428, 357, "Output"]
}, Open  ]],
Cell[307463, 7235, 594, 11, 65, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[308118, 7253, 129, 2, 65, "Chapter"],
Cell[308250, 7257, 120, 2, 28, "Input"],
Cell[308373, 7261, 3343, 103, 101, "Input"],
Cell[311719, 7366, 3224, 101, 101, "Input"],
Cell[CellGroupData[{
Cell[314968, 7471, 4099, 126, 119, "Input"],
Cell[319070, 7599, 612, 12, 24, "Message"],
Cell[319685, 7613, 16546, 413, 245, "Output"]
}, Open  ]],
Cell[336246, 8029, 356, 8, 68, "Text"],
Cell[336605, 8039, 3186, 74, 267, "Input"],
Cell[339794, 8115, 454, 12, 63, "Input"],
Cell[340251, 8129, 89, 1, 46, "Input"],
Cell[CellGroupData[{
Cell[340365, 8134, 2348, 51, 97, "Input"],
Cell[342716, 8187, 585, 13, 24, "Message"],
Cell[343304, 8202, 584, 13, 24, "Message"],
Cell[343891, 8217, 585, 13, 24, "Message"],
Cell[344479, 8232, 29170, 730, 369, "Output"]
}, Open  ]],
Cell[373664, 8965, 94, 1, 28, "Input"],
Cell[373761, 8968, 138, 4, 49, "Text"],
Cell[CellGroupData[{
Cell[373924, 8976, 202, 4, 28, "Input"],
Cell[374129, 8982, 33839, 810, 362, "Output"]
}, Open  ]],
Cell[407983, 9795, 356, 9, 89, "Text"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
