(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     38234,       1057]
NotebookOptionsPosition[     36236,        988]
NotebookOutlinePosition[     36646,       1006]
CellTagsIndexPosition[     36603,       1003]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 "Finding the ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["MEK", "L"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " Performance"
}], "Title",
 CellChangeTimes->{{3.65798077482286*^9, 3.657980807771776*^9}, {
  3.664802232410149*^9, 3.664802241667838*^9}}],

Cell[CellGroupData[{

Cell["\<\

Definitions\
\>", "Section",
 CellChangeTimes->{{3.6579803257039013`*^9, 3.6579803286688967`*^9}, 
   3.6579807663658047`*^9}],

Cell[BoxData["Definitions"], "Output",
 CellChangeTimes->{3.657980661258325*^9, 3.6579807055966177`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ID", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"X", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Z", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "1"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Y", "=", 
   RowBox[{"\[ImaginaryI]", "*", 
    RowBox[{"X", ".", "Z"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"HL", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"Cos", "[", "\[Theta]", "]"}], "*", "X"}], "+", 
    RowBox[{
     RowBox[{"Sin", "[", "\[Theta]", "]"}], "Z"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"HL\[Eta]", "[", "x\[Eta]_", "]"}], "=", 
   RowBox[{"HL", ".", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"\[ImaginaryI]", "*", "Y"}], ",", "x\[Eta]"}], "]"}]}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.656159141324512*^9, 3.656159160144353*^9}, {
   3.656159332054468*^9, 3.656159362535819*^9}, {3.6561594182496977`*^9, 
   3.6561594335464163`*^9}, {3.6573528683009453`*^9, 3.657352870823656*^9}, {
   3.6574651206068363`*^9, 3.6574651290880547`*^9}, {3.662881927573105*^9, 
   3.662881942835382*^9}, {3.662882794258767*^9, 3.66288279720103*^9}, {
   3.6628828435558977`*^9, 3.6628828821479683`*^9}, {3.662884140080226*^9, 
   3.66288415465648*^9}, {3.664802251700748*^9, 3.664802252260532*^9}, {
   3.664802283159343*^9, 3.664802305094578*^9}, 3.664802511201004*^9}],

Cell["\<\

Defining some matrices\
\>", "Text",
 CellChangeTimes->{{3.6579782627866163`*^9, 3.657978281163808*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]ONE", "[", " ", "\[Epsilon]_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"ID", "+", 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"2", "\[Epsilon]"}]}], ")"}], "*", "HL"}]}], ")"}], "/", 
      "2"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Rho]PerfectGlobal", "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"ID", "+", "HL"}], ")"}], "/", "2"}], ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"ID", "+", "HL"}], ")"}], "/", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Rho]PerfectLocal1", "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"ID", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"ID", "+", "HL"}], ")"}], "/", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Rho]PerfectLocal2", "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{"ID", ",", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"ID", "+", "HL"}], ")"}], "/", "2"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"\[Rho]", "[", " ", "\[Epsilon]_", "]"}], "=", 
     RowBox[{"KroneckerProduct", "[", 
      RowBox[{
       RowBox[{"\[Rho]ONE", "[", " ", "\[Epsilon]", "]"}], ",", 
       RowBox[{"\[Rho]ONE", "[", " ", "\[Epsilon]", "]"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.657353218423606*^9, 3.657353219775869*^9}, {
   3.657354755588666*^9, 3.6573547584114313`*^9}, {3.657354841222538*^9, 
   3.6573548427902412`*^9}, {3.657354906019425*^9, 3.6573549419797287`*^9}, {
   3.657465133321197*^9, 3.657465163272965*^9}, {3.657465197965043*^9, 
   3.6574652141376677`*^9}, {3.6579802908916683`*^9, 3.657980310901639*^9}, {
   3.6628819473491173`*^9, 3.66288195045173*^9}, 3.662882239375655*^9, {
   3.66480245967771*^9, 3.664802463726733*^9}}],

Cell["\<\

We think of MEK being a protocol that takes 2 magic states in the state \
\[Rho][\[Epsilon]] and pumps on them with a circuit using a further 8 copies.\
\
\>", "Text",
 CellChangeTimes->{{3.657978284128399*^9, 3.657978328709742*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Channels", "Section",
 CellChangeTimes->{{3.657980346800449*^9, 3.6579803476296473`*^9}, 
   3.657980761483905*^9}],

Cell[BoxData["Channels"], "Output",
 CellChangeTimes->{3.657980661414111*^9, 3.6579807057648087`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"U1", "[", 
    RowBox[{
    "x1_", ",", "x2_", ",", "x3_", ",", "x4_", ",", "x5_", ",", "x6_", ",", 
     "x7_", ",", "x8_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{"X", ",", "X"}], "]"}], ",", " ", 
      RowBox[{"x1", "+", "x3"}]}], "]"}], ".", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{"Z", ",", "Z"}], "]"}], ",", " ", 
      RowBox[{"x2", "+", "x4"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"U2", "[", 
    RowBox[{
    "x1_", ",", "x2_", ",", "x3_", ",", "x4_", ",", "x5_", ",", "x6_", ",", 
     "x7_", ",", "x8_"}], "]"}], "=", 
   RowBox[{
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{"X", ",", "X"}], "]"}], ",", " ", 
      RowBox[{"x5", "+", "x7"}]}], "]"}], ".", 
    RowBox[{"MatrixPower", "[", 
     RowBox[{
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{"Z", ",", "Z"}], "]"}], ",", " ", 
      RowBox[{"x6", "+", "x8"}]}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"Proj", "[", 
     RowBox[{
     "x1_", ",", "x2_", ",", "x3_", ",", "x4_", ",", "x5_", ",", "x6_", ",", 
      "x7_", ",", "x8_", ",", " ", "x\[Eta]_"}], "]"}], "=", 
    RowBox[{
     RowBox[{
      RowBox[{"KroneckerProduct", "[", 
       RowBox[{"ID", ",", 
        RowBox[{"HL\[Eta]", "[", "x\[Eta]", "]"}]}], "]"}], ".", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"KroneckerProduct", "[", 
         RowBox[{"ID", ",", "ID"}], "]"}], "+", 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"-", "1"}], ")"}], 
          RowBox[{"(", 
           RowBox[{"x3", "+", "x4", "+", "x5", "+", "x6"}], ")"}]], 
         RowBox[{"KroneckerProduct", "[", 
          RowBox[{
           RowBox[{"HL\[Eta]", "[", "x\[Eta]", "]"}], ",", 
           RowBox[{"HL\[Eta]", "[", "x\[Eta]", "]"}]}], "]"}]}]}], ")"}]}], 
     "/", "2"}]}], ";"}], "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Kraus", "[", 
    RowBox[{
    "x1_", ",", "x2_", ",", "x3_", ",", "x4_", ",", "x5_", ",", "x6_", ",", 
     "x7_", ",", "x8_", ",", "x\[Eta]_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"U2", "[", 
     RowBox[{
     "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", 
      ",", "x8"}], "]"}], ".", 
    RowBox[{"Proj", "[", 
     RowBox[{
     "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", 
      ",", "x8", ",", "x\[Eta]"}], "]"}], ".", 
    RowBox[{"U1", "[", 
     RowBox[{
     "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", 
      ",", "x8"}], "]"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6561590782514343`*^9, 3.656159301333596*^9}, {
   3.656159365864483*^9, 3.656159368808272*^9}, {3.6561594372457743`*^9, 
   3.656159503357341*^9}, {3.6561611048236637`*^9, 3.656161174232795*^9}, {
   3.656161358480164*^9, 3.656161389839869*^9}, {3.6561615492391567`*^9, 
   3.6561615521492243`*^9}, {3.65616222551856*^9, 3.6561622576137457`*^9}, {
   3.656163843749412*^9, 3.65616386170506*^9}, {3.657351116283246*^9, 
   3.657351129488716*^9}, {3.6573528774890137`*^9, 3.657352944082919*^9}, {
   3.657353408796509*^9, 3.657353411957201*^9}, 3.6574652276373863`*^9, {
   3.6574657396724167`*^9, 3.657465745738097*^9}, {3.6579795812197227`*^9, 
   3.65797966815637*^9}, {3.658643844064464*^9, 3.6586438510989313`*^9}, {
   3.662882136986752*^9, 3.6628821386982193`*^9}, 3.662882199310389*^9, {
   3.662882802945734*^9, 3.662882828610611*^9}, {3.6628829166615963`*^9, 
   3.662882933958415*^9}, {3.664802320906061*^9, 3.664802323898447*^9}}],

Cell["\<\
We will apply a noisy channel to \[Rho][\[Epsilon]] which is a sum over Kraus \
operators labelled by [x1_,x2_,x3_,x4_,x5_,x6_,x7_,x8_], where 
xj=1 indicates an error on the j^th of te 8 pumping magic states.  

For each Kraus operator we further break it up into 3 parts U1, Proj and U2.  \

U1 and U2 are unitaries that consist of Pauli errors.
Proj is a noisy parity projection, which is usually a projection onto the \
even parity Hadamard space, though some Pauli errors can generate a \
projection onto the odd parity Hadamard space.\
\>", "Text",
 CellChangeTimes->{{3.657353003682605*^9, 3.657353053647189*^9}, {
   3.6573530839604473`*^9, 3.6573530869681377`*^9}, {3.6579783391995296`*^9, 
   3.657978454966799*^9}, {3.6579794553529797`*^9, 3.657979547108705*^9}, 
   3.6579819000420303`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Channel", "[", 
   RowBox[{
   "x1_", ",", "x2_", ",", "x3_", ",", "x4_", ",", "x5_", ",", "x6_", ",", 
    "x7_", ",", "x8_", ",", "x\[Eta]_", ",", " ", "\[Rho]in_"}], "]"}], ":=", 
  
  RowBox[{
   RowBox[{"Kraus", "[", 
    RowBox[{
    "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", 
     ",", "x8", ",", "x\[Eta]"}], "]"}], ".", "\[Rho]in", ".", 
   RowBox[{"ConjugateTranspose", "[", 
    RowBox[{"Kraus", "[", 
     RowBox[{
     "x1", ",", "x2", ",", "x3", ",", "x4", ",", "x5", ",", "x6", ",", "x7", 
      ",", "x8", ",", "x\[Eta]"}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.657979742394456*^9, 3.657979771032589*^9}, 
   3.65797987166466*^9, {3.657980673119182*^9, 3.657980673837927*^9}, 
   3.6579814032785482`*^9, {3.657981461394684*^9, 3.657981463002387*^9}, {
   3.657981496219144*^9, 3.657981501923098*^9}, {3.662882940137189*^9, 
   3.6628829473524857`*^9}}],

Cell["\<\
The above code simply takes a Kraus operator and makes a quantum channel from \
it\
\>", "Text",
 CellChangeTimes->{{3.65797971793038*^9, 3.657979733174707*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"w0", "=", 
   RowBox[{"Permutations", "[", 
    RowBox[{"{", 
     RowBox[{
     "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w2", "=", 
   RowBox[{"Permutations", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
      "0"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w4", "=", 
   RowBox[{"Permutations", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", "0", ",", "0", ",", 
      "0"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w6", "=", 
   RowBox[{"Permutations", "[", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "0", ",", 
      "0"}], "}"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w8", "=", 
   RowBox[{"{", 
    RowBox[{"{", 
     RowBox[{
     "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
      "1"}], "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"w", "=", 
   RowBox[{"Union", "[", 
    RowBox[{"w0", ",", "w2", ",", " ", "w4", ",", " ", "w6", ",", " ", "w8"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"size", "=", 
   RowBox[{
    RowBox[{"Dimensions", "[", "w", "]"}], "[", 
    RowBox[{"[", "1", "]"}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.656159788070732*^9, 3.656159821303933*^9}, {
  3.656159851610509*^9, 3.656159864281427*^9}, {3.656159900476367*^9, 
  3.6561599087631683`*^9}, {3.65615999662257*^9, 3.656159996894175*^9}, {
  3.656233258347067*^9, 3.656233301565381*^9}, {3.656234037497233*^9, 
  3.6562340941875896`*^9}, {3.656234169133938*^9, 3.656234169392475*^9}, {
  3.657351254484968*^9, 3.657351263004074*^9}, {3.6573513051897287`*^9, 
  3.657351331294764*^9}, {3.657351560820945*^9, 3.657351561436706*^9}, {
  3.657353143989737*^9, 3.657353144445912*^9}, {3.657354415220313*^9, 
  3.657354446186344*^9}, {3.657465502368452*^9, 3.657465525751114*^9}}],

Cell["\<\

We construct a list of all nontrivial even weight errors (odd weight errors \
are always detected by the circuit)\
\>", "Text",
 CellChangeTimes->{{3.657353152756098*^9, 3.6573531809579163`*^9}, 
   3.6579797785139837`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FullChannel", "[", 
    RowBox[{"\[Epsilon]_", ",", "\[Delta]_", ",", " ", "\[Rho]in_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Delta]"}], ")"}], "*", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["\[Epsilon]", 
            RowBox[{"1", "-", "\[Epsilon]"}]], ")"}], 
          RowBox[{"Total", "[", 
           RowBox[{"w", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "]"}]], "*", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Epsilon]"}], ")"}], "8"], "*", 
         RowBox[{"Channel", "[", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "5"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "6"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "7"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "8"}], "]"}], "]"}], ",", "0", ",", "  ", 
           "\[Rho]in"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "size"}], "}"}]}], "]"}]}], ")"}], "+", 
    RowBox[{"(", 
     RowBox[{"\[Delta]", "*", 
      RowBox[{"Sum", "[", 
       RowBox[{
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox["\[Epsilon]", 
            RowBox[{"1", "-", "\[Epsilon]"}]], ")"}], 
          RowBox[{"Total", "[", 
           RowBox[{"w", "[", 
            RowBox[{"[", "k", "]"}], "]"}], "]"}]], "*", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Epsilon]"}], ")"}], "8"], "*", 
         RowBox[{"Channel", "[", 
          RowBox[{
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "1"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "3"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "4"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "5"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "6"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "7"}], "]"}], "]"}], ",", 
           RowBox[{"w", "[", 
            RowBox[{"[", 
             RowBox[{"k", ",", "8"}], "]"}], "]"}], ",", "1", ",", "  ", 
           "\[Rho]in"}], "]"}]}], ",", 
        RowBox[{"{", 
         RowBox[{"k", ",", "1", ",", "size"}], "}"}]}], "]"}]}], ")"}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.6579806846414433`*^9, 3.657980686599412*^9}, 
   3.657980972877982*^9, {3.657981127132194*^9, 3.657981127434526*^9}, {
   3.66288295915907*^9, 3.6628830026341333`*^9}, {3.662883051178323*^9, 
   3.662883113164608*^9}, {3.662883810502719*^9, 3.662883826261434*^9}, 
   3.662884236100197*^9}],

Cell[TextData[{
 "Above we form a channel by summing over all errors of even weight (those \
not detected) and weight them by ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox["\[Epsilon]", "N"], "*", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", "\[Epsilon]"}], ")"}], 
    RowBox[{"N", "-", "8"}]]}]]],
 " where N is the number of errors (the number of nonzero values for \
[x1_,x2_,x3_,x4_,x5_,x6_,x7_,x8_], )"
}], "Text",
 CellChangeTimes->{{3.657979938705195*^9, 3.657980029144866*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Output state", "Section",
 CellChangeTimes->{{3.6579803536898937`*^9, 3.657980366582725*^9}, 
   3.6579807552312803`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"\[Rho]OUT", "[", " ", 
    RowBox[{"\[Epsilon]3_", ",", " ", "\[Epsilon]k_", ",", " ", "\[Delta]_"}],
     "]"}], "=", 
   RowBox[{"FullChannel", "[", 
    RowBox[{"\[Epsilon]3", ",", "\[Delta]", ",", "  ", 
     RowBox[{"\[Rho]", "[", "\[Epsilon]k", "]"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6573519124306717`*^9, 3.6573519256471043`*^9}, {
   3.657353242578356*^9, 3.657353250465468*^9}, {3.657353313149658*^9, 
   3.657353336666402*^9}, {3.6573534852815657`*^9, 3.657353489431497*^9}, {
   3.65746524868438*^9, 3.6574652531157618`*^9}, {3.657465386100999*^9, 
   3.6574653873013067`*^9}, {3.6574655283926764`*^9, 3.657465537435178*^9}, {
   3.657465572519506*^9, 3.6574655726957006`*^9}, 3.657980690929178*^9, {
   3.657980837350664*^9, 3.6579808375761557`*^9}, {3.657982177410088*^9, 
   3.657982191473012*^9}, {3.662882516615972*^9, 3.662882519559396*^9}, {
   3.662882592571672*^9, 3.6628826036104*^9}, {3.6628830101685123`*^9, 
   3.6628830156417723`*^9}, {3.6628838315092287`*^9, 3.6628838346531477`*^9}}],

Cell["\<\
We find \[Rho]OUT[ \[Epsilon]] by applying the noisy map FullChannel[\
\[Epsilon], \[Rho]in] to the input \[Rho][ \[Epsilon]].  Remember the input \
consists of 2 noisy magic states and 8 noisy magic were responsible for \
implementing the noisy map.\
\>", "Text",
 CellChangeTimes->{{3.657979781126279*^9, 3.6579798613361073`*^9}, {
   3.657980037984941*^9, 3.657980103362761*^9}, 3.65798037970483*^9, 
   3.6579806936180487`*^9, {3.657981921390067*^9, 3.657981921765836*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Polynomials", "Section",
 CellChangeTimes->{{3.657980370627543*^9, 3.6579803732470427`*^9}, 
   3.657980748666888*^9, 3.657981162847106*^9}],

Cell[BoxData["Polynomials"], "Output",
 CellChangeTimes->{3.657980663744781*^9, 3.6579807078867893`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Psuc", "[", " ", 
   RowBox[{"\[Epsilon]3_", ",", " ", "\[Epsilon]k_", ",", " ", "\[Delta]_"}], 
   "]"}], "=", 
  RowBox[{"Simplify", "[", 
   RowBox[{
    RowBox[{"Simplify", "[", 
     RowBox[{"Simplify", "[", 
      RowBox[{
       RowBox[{"Tr", "[", 
        RowBox[{
         RowBox[{"\[Rho]OUT", "[", " ", 
          RowBox[{
          "\[Epsilon]3", ",", " ", "\[Epsilon]k", ",", " ", "\[Delta]"}], 
          "]"}], " ", "/.", 
         RowBox[{"{", " ", 
          RowBox[{
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", " ", 
           RowBox[{
            RowBox[{"Conjugate", "[", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "]"}], "/.", 
       RowBox[{"{", " ", 
        RowBox[{
         RowBox[{
          RowBox[{"Conjugate", "[", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
          RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", " ", 
         RowBox[{
          RowBox[{"Conjugate", "[", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
          RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "]"}], "]"}], "/.", 
    RowBox[{"{", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Sin", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
       RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", " ", 
      RowBox[{
       RowBox[{"Conjugate", "[", 
        RowBox[{"Cos", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
       RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6573533247486963`*^9, 3.657353325385808*^9}, {
   3.6573533699816236`*^9, 3.6573533983508177`*^9}, {3.657353474566524*^9, 
   3.657353506981702*^9}, {3.6574652581437817`*^9, 3.657465261207522*^9}, {
   3.657465390206189*^9, 3.657465391374361*^9}, {3.657465544300606*^9, 
   3.657465545468915*^9}, {3.657974548827703*^9, 3.657974558553296*^9}, {
   3.657980128742073*^9, 3.6579801350287533`*^9}, {3.657980216784437*^9, 
   3.657980222355751*^9}, 3.657980456402927*^9, {3.657981345646681*^9, 
   3.657981351325279*^9}, {3.662882355009819*^9, 3.66288240560527*^9}, {
   3.6628825025690603`*^9, 3.662882510119966*^9}, {3.662882611662602*^9, 
   3.662882620651729*^9}, {3.662883019242777*^9, 3.662883024890163*^9}, {
   3.6628831475658712`*^9, 3.6628831479656343`*^9}, {3.662883837527615*^9, 
   3.662883840229937*^9}, {3.6648023668890457`*^9, 3.664802370233953*^9}, 
   3.664803610280052*^9}],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"448", " ", 
   SuperscriptBox["\[Epsilon]3", "5"]}], "+", 
  RowBox[{"448", " ", 
   SuperscriptBox["\[Epsilon]3", "6"]}], "-", 
  RowBox[{"256", " ", 
   SuperscriptBox["\[Epsilon]3", "7"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[Epsilon]3", "8"]}], "-", 
  RowBox[{
   FractionBox["1", "2"], " ", "\[Delta]", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "\[Epsilon]3"}]}], ")"}], "4"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "-", 
      RowBox[{"2", " ", "\[Epsilon]k"}]}], ")"}], "2"]}], "-", 
  RowBox[{"2", " ", "\[Epsilon]k"}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[Epsilon]3", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", "\[Epsilon]k", "+", 
     SuperscriptBox["\[Epsilon]k", "2"]}], ")"}]}], "+", 
  RowBox[{"32", " ", 
   SuperscriptBox["\[Epsilon]3", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"9", "-", "\[Epsilon]k", "+", 
     SuperscriptBox["\[Epsilon]k", "2"]}], ")"}]}], "-", 
  RowBox[{"8", " ", "\[Epsilon]3", " ", 
   RowBox[{"(", 
    RowBox[{"1", "-", 
     RowBox[{"2", " ", "\[Epsilon]k"}], "+", 
     RowBox[{"2", " ", 
      SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}]}], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[Epsilon]3", "2"], " ", 
   RowBox[{"(", 
    RowBox[{"5", "-", 
     RowBox[{"6", " ", "\[Epsilon]k"}], "+", 
     RowBox[{"6", " ", 
      SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}]}]}]], "Output",
 CellChangeTimes->{
  3.662882406579261*^9, 3.662882445936717*^9, {3.6628825037557297`*^9, 
   3.662882511630115*^9}, 3.6628826729461*^9, 3.662883035709939*^9, 
   3.662883118413517*^9, 3.6628831537354097`*^9, {3.662883840802825*^9, 
   3.6628838488425493`*^9}, 3.662884159354519*^9, 3.662884198057251*^9, 
   3.662884246108708*^9, 3.663957864856498*^9, {3.6648024588959093`*^9, 
   3.664802487706751*^9}, 3.664802520609075*^9}]
}, Open  ]],

Cell["The success probability.", "Text",
 CellChangeTimes->{{3.657980138314183*^9, 3.657980171981882*^9}, {
  3.657981418690199*^9, 3.657981425175218*^9}, {3.6579823115447206`*^9, 
  3.657982313224777*^9}, {3.664802364250062*^9, 3.664802373048011*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Epsilon]out", "[", " ", 
     RowBox[{
     "\[Epsilon]3_", ",", " ", "\[Epsilon]k_", ",", " ", "\[Delta]_"}], "]"}],
     "=", 
    RowBox[{
     FractionBox["1", 
      RowBox[{"Psuc", "[", " ", 
       RowBox[{"\[Epsilon]3", ",", " ", "\[Epsilon]k", ",", " ", "\[Delta]"}],
        "]"}]], "*", 
     RowBox[{"Expand", "[", 
      RowBox[{"Simplify", "[", 
       RowBox[{
        RowBox[{"Simplify", "[", 
         RowBox[{
          RowBox[{"Tr", "[", 
           RowBox[{
            RowBox[{"\[Rho]OUT", "[", " ", 
             RowBox[{
             "\[Epsilon]3", ",", " ", "\[Epsilon]k", ",", " ", "\[Delta]"}], 
             "]"}], ".", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"KroneckerProduct", "[", 
               RowBox[{"ID", ",", "ID"}], "]"}], "-", "\[Rho]PerfectLocal1"}],
              ")"}]}], "]"}], "  ", "/.", 
          RowBox[{"{", " ", 
           RowBox[{
            RowBox[{
             RowBox[{"Conjugate", "[", 
              RowBox[{"Sin", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
             RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", " ", 
            RowBox[{
             RowBox[{"Conjugate", "[", 
              RowBox[{"Cos", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
             RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "]"}], "/.", 
        
        RowBox[{"{", " ", 
         RowBox[{
          RowBox[{
           RowBox[{"Conjugate", "[", 
            RowBox[{"Sin", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
           RowBox[{"Sin", "[", "\[Theta]", "]"}]}], ",", " ", 
          RowBox[{
           RowBox[{"Conjugate", "[", 
            RowBox[{"Cos", "[", "\[Theta]", "]"}], "]"}], "\[Rule]", " ", 
           RowBox[{"Cos", "[", "\[Theta]", "]"}]}]}], "}"}]}], "]"}], 
      "]"}]}]}], "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.6579804777933073`*^9, 3.6579804898605757`*^9}, {
   3.657980523853805*^9, 3.657980523989958*^9}, 3.6579813745841923`*^9, 
   3.657982544395073*^9, {3.662882642638894*^9, 3.662882659324233*^9}, {
   3.6628827104187803`*^9, 3.662882758225222*^9}, {3.662883030137658*^9, 
   3.662883034169952*^9}, {3.6628838667787313`*^9, 3.662883868887239*^9}, {
   3.664802385721436*^9, 3.664802386585453*^9}, {3.664802424522847*^9, 
   3.664802434939303*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    FractionBox["\[Delta]", "4"], "-", 
    RowBox[{"2", " ", "\[Delta]", " ", "\[Epsilon]3"}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["\[Epsilon]3", "2"]}], "+", 
    RowBox[{"6", " ", "\[Delta]", " ", 
     SuperscriptBox["\[Epsilon]3", "2"]}], "-", 
    RowBox[{"48", " ", 
     SuperscriptBox["\[Epsilon]3", "3"]}], "-", 
    RowBox[{"8", " ", "\[Delta]", " ", 
     SuperscriptBox["\[Epsilon]3", "3"]}], "+", 
    RowBox[{"136", " ", 
     SuperscriptBox["\[Epsilon]3", "4"]}], "+", 
    RowBox[{"4", " ", "\[Delta]", " ", 
     SuperscriptBox["\[Epsilon]3", "4"]}], "-", 
    RowBox[{"224", " ", 
     SuperscriptBox["\[Epsilon]3", "5"]}], "+", 
    RowBox[{"224", " ", 
     SuperscriptBox["\[Epsilon]3", "6"]}], "-", 
    RowBox[{"128", " ", 
     SuperscriptBox["\[Epsilon]3", "7"]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["\[Epsilon]3", "8"]}], "+", 
    SuperscriptBox["\[Epsilon]k", "2"], "-", 
    RowBox[{"\[Delta]", " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
    RowBox[{"8", " ", "\[Epsilon]3", " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
    RowBox[{"8", " ", "\[Delta]", " ", "\[Epsilon]3", " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
    RowBox[{"24", " ", 
     SuperscriptBox["\[Epsilon]3", "2"], " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
    RowBox[{"24", " ", "\[Delta]", " ", 
     SuperscriptBox["\[Epsilon]3", "2"], " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
    RowBox[{"32", " ", 
     SuperscriptBox["\[Epsilon]3", "3"], " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
    RowBox[{"32", " ", "\[Delta]", " ", 
     SuperscriptBox["\[Epsilon]3", "3"], " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "+", 
    RowBox[{"16", " ", 
     SuperscriptBox["\[Epsilon]3", "4"], " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
    RowBox[{"16", " ", "\[Delta]", " ", 
     SuperscriptBox["\[Epsilon]3", "4"], " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}], "/", 
  RowBox[{"(", 
   RowBox[{"1", "-", 
    RowBox[{"448", " ", 
     SuperscriptBox["\[Epsilon]3", "5"]}], "+", 
    RowBox[{"448", " ", 
     SuperscriptBox["\[Epsilon]3", "6"]}], "-", 
    RowBox[{"256", " ", 
     SuperscriptBox["\[Epsilon]3", "7"]}], "+", 
    RowBox[{"64", " ", 
     SuperscriptBox["\[Epsilon]3", "8"]}], "-", 
    RowBox[{
     FractionBox["1", "2"], " ", "\[Delta]", " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "\[Epsilon]3"}]}], ")"}], "4"], " ", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"2", " ", "\[Epsilon]k"}]}], ")"}], "2"]}], "-", 
    RowBox[{"2", " ", "\[Epsilon]k"}], "+", 
    RowBox[{"2", " ", 
     SuperscriptBox["\[Epsilon]k", "2"]}], "-", 
    RowBox[{"64", " ", 
     SuperscriptBox["\[Epsilon]3", "3"], " ", 
     RowBox[{"(", 
      RowBox[{"2", "-", "\[Epsilon]k", "+", 
       SuperscriptBox["\[Epsilon]k", "2"]}], ")"}]}], "+", 
    RowBox[{"32", " ", 
     SuperscriptBox["\[Epsilon]3", "4"], " ", 
     RowBox[{"(", 
      RowBox[{"9", "-", "\[Epsilon]k", "+", 
       SuperscriptBox["\[Epsilon]k", "2"]}], ")"}]}], "-", 
    RowBox[{"8", " ", "\[Epsilon]3", " ", 
     RowBox[{"(", 
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "\[Epsilon]k"}], "+", 
       RowBox[{"2", " ", 
        SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}]}], "+", 
    RowBox[{"8", " ", 
     SuperscriptBox["\[Epsilon]3", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"5", "-", 
       RowBox[{"6", " ", "\[Epsilon]k"}], "+", 
       RowBox[{"6", " ", 
        SuperscriptBox["\[Epsilon]k", "2"]}]}], ")"}]}]}], ")"}]}]], "Output",\

 CellChangeTimes->{
  3.664802465202873*^9, {3.664802501009404*^9, 3.664802527380748*^9}}]
}, Open  ]],

Cell["\<\

Error probability on a single output qubit.\
\>", "Text",
 CellChangeTimes->{{3.664802402211866*^9, 3.664802414937952*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Expand", "[", 
  RowBox[{"Psuc", "[", " ", 
   RowBox[{"\[Epsilon]", ",", " ", "\[Epsilon]", ",", " ", "0"}], "]"}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"\[Epsilon]out", "[", " ", 
    RowBox[{"\[Epsilon]", ",", " ", "\[Epsilon]", ",", " ", "0"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Epsilon]", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6648036194635887`*^9, 3.6648036604233294`*^9}}],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"10", " ", "\[Epsilon]"}], "+", 
  RowBox[{"58", " ", 
   SuperscriptBox["\[Epsilon]", "2"]}], "-", 
  RowBox[{"192", " ", 
   SuperscriptBox["\[Epsilon]", "3"]}], "+", 
  RowBox[{"400", " ", 
   SuperscriptBox["\[Epsilon]", "4"]}], "-", 
  RowBox[{"544", " ", 
   SuperscriptBox["\[Epsilon]", "5"]}], "+", 
  RowBox[{"480", " ", 
   SuperscriptBox["\[Epsilon]", "6"]}], "-", 
  RowBox[{"256", " ", 
   SuperscriptBox["\[Epsilon]", "7"]}], "+", 
  RowBox[{"64", " ", 
   SuperscriptBox["\[Epsilon]", "8"]}]}]], "Output",
 CellChangeTimes->{{3.6648036230331783`*^9, 3.6648036608608503`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"9", " ", 
    SuperscriptBox["\[Epsilon]", "2"]}], "+", 
   RowBox[{"34", " ", 
    SuperscriptBox["\[Epsilon]", "3"]}], "-", 
   RowBox[{"22", " ", 
    SuperscriptBox["\[Epsilon]", "4"]}], "-", 
   RowBox[{"720", " ", 
    SuperscriptBox["\[Epsilon]", "5"]}], "-", 
   RowBox[{"2756", " ", 
    SuperscriptBox["\[Epsilon]", "6"]}], "+", 
   RowBox[{"1144", " ", 
    SuperscriptBox["\[Epsilon]", "7"]}], "+", 
   RowBox[{"56056", " ", 
    SuperscriptBox["\[Epsilon]", "8"]}], "+", 
   RowBox[{"227072", " ", 
    SuperscriptBox["\[Epsilon]", "9"]}], "-", 
   RowBox[{"31472", " ", 
    SuperscriptBox["\[Epsilon]", "10"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "\[Epsilon]", "]"}], "11"],
    SeriesData[$CellContext`\[Epsilon], 0, {}, 2, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`\[Epsilon], 0, {9, 34, -22, -720, -2756, 1144, 
   56056, 227072, -31472}, 2, 11, 1],
  Editable->False]], "Output",
 CellChangeTimes->{{3.6648036230331783`*^9, 3.6648036608818283`*^9}}]
}, Open  ]],

Cell["\<\
Above equations match the results of MEK
\
\>", "Text",
 CellChangeTimes->{{3.664803662548938*^9, 3.664803681127804*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"Psuc", "[", " ", 
        RowBox[{
         RowBox[{"\[Epsilon]3", "*", "t"}], ",", " ", 
         RowBox[{"\[Epsilon]k", "*", "t"}], ",", " ", 
         RowBox[{"\[Delta]", "*", "t"}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "1"}], "}"}]}], "]"}], "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"t", "\[Rule]", " ", "1"}], "}"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Normal", "[", 
     RowBox[{"Series", "[", 
      RowBox[{
       RowBox[{"\[Epsilon]out", "[", " ", 
        RowBox[{
         RowBox[{"\[Epsilon]3", "*", "t"}], ",", " ", 
         RowBox[{"\[Epsilon]k", "*", "t"}], ",", " ", 
         RowBox[{"\[Delta]", "*", 
          SuperscriptBox["t", "2"]}]}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "0", ",", "2"}], "}"}]}], "]"}], "]"}], " ", "/.", 
    RowBox[{"{", 
     RowBox[{"t", "\[Rule]", " ", "1"}], "}"}]}]}]}]], "Input",
 CellChangeTimes->{{3.664803682660207*^9, 3.6648036950559063`*^9}, {
  3.664803743003895*^9, 3.664803766459263*^9}, {3.66480381471915*^9, 
  3.664803913536725*^9}}],

Cell[BoxData[
 RowBox[{"1", "-", 
  FractionBox["\[Delta]", "2"], "-", 
  RowBox[{"8", " ", "\[Epsilon]3"}], "-", 
  RowBox[{"2", " ", "\[Epsilon]k"}]}]], "Output",
 CellChangeTimes->{{3.664803754362753*^9, 3.66480376678111*^9}, {
  3.664803825347093*^9, 3.664803862876658*^9}, {3.664803894031623*^9, 
  3.664803913790392*^9}}],

Cell[BoxData[
 RowBox[{
  FractionBox["\[Delta]", "4"], "+", 
  RowBox[{"8", " ", 
   SuperscriptBox["\[Epsilon]3", "2"]}], "+", 
  SuperscriptBox["\[Epsilon]k", "2"]}]], "Output",
 CellChangeTimes->{{3.664803754362753*^9, 3.66480376678111*^9}, {
  3.664803825347093*^9, 3.664803862876658*^9}, {3.664803894031623*^9, 
  3.664803913793991*^9}}]
}, Open  ]],

Cell[TextData[{
 "The leading order ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["P", "suc"], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Epsilon]", "out"], "."}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 "\n"
}], "Text",
 CellChangeTimes->{{3.664803916335991*^9, 3.664803971237742*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1139, 699},
WindowMargins->{{Automatic, 49}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
FrontEndVersion->"10.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 9, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 283, 9, 92, "Title"],
Cell[CellGroupData[{
Cell[888, 35, 137, 5, 99, "Section"],
Cell[1028, 42, 104, 1, 28, "Output"],
Cell[1135, 45, 1905, 53, 131, "Input"],
Cell[3043, 100, 115, 4, 49, "Text"],
Cell[3161, 106, 2049, 55, 114, "Input"],
Cell[5213, 163, 244, 6, 49, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5494, 174, 121, 2, 64, "Section"],
Cell[5618, 178, 101, 1, 28, "Output"],
Cell[5722, 181, 3824, 93, 152, "Input"],
Cell[9549, 276, 812, 15, 144, "Text"],
Cell[10364, 293, 945, 21, 46, "Input"],
Cell[11312, 316, 171, 4, 30, "Text"],
Cell[11486, 322, 2142, 54, 131, "Input"],
Cell[13631, 378, 234, 6, 49, "Text"],
Cell[13868, 386, 3760, 101, 173, "Input"],
Cell[17631, 489, 503, 13, 51, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18171, 507, 127, 2, 64, "Section"],
Cell[18301, 511, 1075, 18, 28, "Input"],
Cell[19379, 531, 487, 8, 49, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19903, 544, 146, 2, 64, "Section"],
Cell[20052, 548, 104, 1, 28, "Output"],
Cell[CellGroupData[{
Cell[20181, 553, 2701, 58, 80, "Input"],
Cell[22885, 613, 1986, 52, 71, "Output"]
}, Open  ]],
Cell[24886, 668, 252, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[25163, 675, 2391, 57, 172, "Input"],
Cell[27557, 734, 3792, 99, 157, "Output"]
}, Open  ]],
Cell[31364, 836, 134, 4, 49, "Text"],
Cell[CellGroupData[{
Cell[31523, 844, 493, 11, 46, "Input"],
Cell[32019, 857, 634, 17, 32, "Output"],
Cell[32656, 876, 1077, 29, 32, "Output"]
}, Open  ]],
Cell[33748, 908, 131, 4, 49, "Text"],
Cell[CellGroupData[{
Cell[33904, 916, 1237, 32, 69, "Input"],
Cell[35144, 950, 327, 7, 47, "Output"],
Cell[35474, 959, 343, 8, 47, "Output"]
}, Open  ]],
Cell[35832, 970, 376, 14, 51, "Text"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
